# THIS procedure add database entries to a software database.  The additions
#    are made in update mode.

package provide Server 1.0

proc SVdbAddSW { aDir arInfo } {
   global env aCodeDir SySCmDs

   upvar $arInfo aI

# THIS is the database directorys 

   set dbDir [file join $aDir Database]

# GET all loose database entries and put them into a list

   set fList [exec $SySCmDs(ls) $dbDir]
   set fLen [llength $fList]
   set dbList ""
   for { set I 0 } { $I < $fLen } { incr I } {
      set fName [lindex $fList $I]
      set fExt   [file extension $fName]
      if [string match ".dbe" $fExt] { lappend dbList $fName }
   }

# IF there are no database entries then there is nothing to do

   set dbLen [llength $dbList]
   if { $dbLen == 0 } { return 1 }

# DATABASE entries are entered one at a time.  Slow and inefficient but
#   the database name comes from within the entry.
#
# LOOP over the database entries. 

   for { set I 0 } { $I < $dbLen } { incr I } {

# FORM the database entry name and read its contents

      set dbE [file join $dbDir [lindex $dbList $I]]
      if [info exists dBEntry] { unset dBEntry }
      set dbN [SVswdbEntry $dbE dBEntry]

# ADD the archive code to the database entry

     set dBEntry(ACODE) $aI(aCode)

# DELETE the database entry

      if [file exists $dbE] { file delete -force $dbE }

# GET the current time

      set dBEntry(TIME) [clock format [clock seconds] -format %Y:%j:%H:%M:%S]

# FORM the full database name
     
      set dbF [file join $dbDir $dbN ]

# SEE if there are entries for this package in the database already.  If
#   there are see if any match this revision number.  If so modify that
#   entry - otherwise tack this entry onto the end.

     set Status [SVswdbSearch $dbF $dBEntry(PKG) $dBEntry(REV) dBF dBE]

# THERE are three status conditions.  
#
#   -1 - The database could not be created.
#    0 - The database was created and/or is empty
#    1 - Found a matching entry 

     if { [lindex $Status 0] == 1 } {
         set Pos [lindex $Status 1]
	 set aCode [lindex $dBE(ACODE) $Pos]
	 set pName [lindex $dBE(PKG) $Pos]
	 set pRev [lindex $dBE(REV) $Pos]
         if ![string match $aCode $dBEntry(ACODE)] { 
            set swDir $aCodeDir($aCode)
            set PkG [file join $swDir $pName.$pRev.tgz]
            if [file exists $PkG] { file delete -force $PkG }
         }

         set fLen [llength $dBF]
         for { set J 0 } { $J < $fLen } { incr J } {
            set FlD [lindex $dBF $J] 
            if { [llength $dBE($FlD)] > $Pos } {
               if [info exists dBEntry($FlD)] {
                  set dBE($FlD) [lreplace $dBE($FlD) $Pos $Pos $dBEntry($FlD)] 
               } else { set dBE($FlD) [lreplace $dBE($FlD) $Pos $Pos ""] }
            } else {
               if [info exists dBEntry($FlD)] {
                  lappend dBE($FlD) $dBEntry($FlD) 
               } else { lappend dBE($FlD) "" }
            }
         }
      } elseif { [lindex $Status 0] == 0 } {
        set fLen [llength $dBF]
         for { set J 0 } { $J < $fLen } { incr J } {
            set FlD [lindex $dBF $J] 
            if [info exists dBEntry($FlD)] {
               lappend dBE($FlD) $dBEntry($FlD) 
            } else { lappend dBE($FlD) "" }
         }
      } else { return -1 }

# NOW reform the database

      SVswdbWrite $dbF $dBF dBE 
   }

   return 1
}
