# THIS procedure creates database entries for all of the data to be inserted 
#    into the archive and updates all of the necessary databases.  The 
#    updating needs to be done experiment by experiment as the archive 
#    databases exist on the experiment level.

package provide Server 1.0

proc SVdbAddHD { aDir arInfo pList } {
   global env 

   upvar $arInfo aI

# THIS is the directory where the incoming files are found and where the
#    loose files are.

   set iDir [file join $aDir Incoming]

# THIS is the directory where the VIDF files are found

   set vDir [file join $aDir VIDFS]

# LOOP over the file list until all of the files have been put into the 
#   their respective databases.
#
# USE an attrition scheme in parsing the files to be processed.  Split out 
#   all files belonging to the first experiment.  Do this by building two
#   lists, one containing all of the files to be processed and one containing 
#   all the files belonging to other experiments.  Process the first set
#   of files and transfer the No Process List to the Process List and 
#   continue until there is nothing left to process.

   set pLen [llength $pList]
   while { $pLen != 0 } {
      set DoList ""
      set NoDoList ""
      set uExP [lindex [lindex $pList 0] 1]
      set pLen [llength $pList]
      for { set I 0 } { $I < $pLen } { incr I } {
         set Entry [lindex $pList $I]
         set tExP [lindex $Entry 1]
         if [string match $tExP $uExP] {
   	    lappend DoList [lindex $Entry 0]
         } else { lappend NoDoList $Entry }
      }

      set pList $NoDoList
      set pLen [llength $pList]

# PROCESS the To Do files.  dBF is the base database name for this UDF
#    experiment definition

# THIS is the database we will be updating

      set dbF [file join $aDir Database ${uExP}.HD.DBF]

# THIS is the file where we will generate the database entries

      set dbE [file join $iDir D.asc]
      
# GENERATE the database entries

      DBgenEntries D $vDir $iDir $dbE $DoList $aI(aCode) $aI(cCode)

# APPEND the entries to the database

      DBdbfAppend $dbF $dbE
   }
}
