#  THIS procedure processes all the files in an Archive Incoming directory.
#
# INPUTS:
#    aDir  - the archive directory

package provide Server 1.0

proc SVautoIncoming { aDir } {
   global env sCFG UDFdataOrder tcl_platform 

# Set UDFdataOrder here in case it has not yet been set.

   TUreadUDFrc UDF askANS

   if ![info exists askANS(Data)] {
      set UDFdataOrder $tcl_platform(byteOrder)
   } else { set UDFdataOrder $askANS(Data) }

# THIS is the incoming directory for the archive

   set bDir [file join $aDir Incoming]

# READ the configuration file for this archive

   set cFg [file join $aDir ArchiveConfig]
   if [catch {open $cFg r} fd ] {
      set TiMe [clock format [clock seconds] -format "%c"]
      puts $sCFG(efd) "$TiMe: SVautoIncoming: CANNOT OPEN $cFg"
      flush $sCFG(efd) 
      return 0
   }

   while { [gets $fd LiNe] > 0 } {
      set Flds [split $LiNe "|"]
      set arInfo([lindex $Flds 0]) [lindex $Flds 1]
   }
   close $fd

# NOW get all files from the Incoming directory which need to be processed.
#    If there arn't any files then we can leave.  If there are files they
#    come back in pF.  pF is a list of up to 5 lists.  The multiple lists
#    are used only when processing UDF data archives.  The first list in
#    this case holds all of the tgz Header/Data bundle followed by all of
#    the tgz VIDF bundles, PIDF bundles, individual VIDF files, and 
#    individual PIDF files.  

   set pF [SVgetIncoming $aDir arInfo]
   set pLen [llength $pF]
   if { $pLen == 0 } { return 1 }

# TIME to insert the data into the archive.  At this point the only real
#   interesting insertion code occurs when working with a UDF header/data
#   archive.  In all the rest you just move the data into the archive and
#   compress it if required.  One thing to remember is that when processing
#   a UDF header/data archive ALWAYS process any VIDF files first since
#   the VIDF's are necessary to process the header/data files and we need
#   to make sure they are in place.

# SWITCH on the archive type and process the incoming files.
   
   set aID [split $arInfo(aID) "."]
   set aType [lindex $aID 0]

   switch -exact -- $aType {
      software { 
         SVprocSW $aDir arInfo $pF
      }

      server { 
      }

      default {
         if { [llength $aID] == 3 } {
            set sType [lindex $aID 2]
         } else { set sType D }
         switch -exact -- $sType {
            D {
              SVprocVIDFS $aDir arInfo $pF
              SVprocHD $aDir arInfo $pF
            }

            V {
              SVprocVIDFS $aDir arInfo $pF
            }

            P {
              SVprocPIDFS $aDir arInfo $pF
            }
         }
      }
   } 

# AT this point set up a time to recall this routine so that the Incoming
#   directory is swept at whatever interval the user has set.

   if { $arInfo(bTime) != 0 } { 
     if { $arInfo(bTime) < 60000 } { set arInfo(bTime) 60000 }
     after $arInfo(bTime) SVautoIncoming $aDir 
   }
     
   return 1
}
