#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#include "ADump_str.h"
#include "ADump_ansi.h"

void MenuMain (ByTe_4 PN)
{
   extern struct MeNuS Ms;
   extern struct UserDefs InFo;
   extern ByTe_2 BatchTime[];

   struct PaGe *Pg;
   struct QuEsTiOnS *Qs, *QsEnd;

   size_t  B;
   ByTe_4  H, M, S;
   ByTe_1 *c1;

/*****************************************************************************/
/*                            MAIN MENU                                      */
/*                                                                           */
/* ID[00] BEGINNING TIME                                                     */
/* ID[01] ENDING TIME                                                        */
/* ID[02] DEFINE IDFS SOURCE                                                 */
/* ID[03] OUTPUT FILE                                                        */
/* ID[04] OUTPUT PRINT FORMAT                                                */
/*                                                                           */
/*****************************************************************************/

   Pg = (struct PaGe *) Ms.page;
   Qs = (struct QuEsTiOnS *) Pg->Ques;
   QsEnd = Qs + Pg->NumQ; 

   for ( ; Qs < QsEnd; ++Qs)
   {
      switch (Qs->ID)
      {
         case 0:
           BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
           sscanf (Qs->CReply, Qs->Fmt, &InFo.TB.Yr, &InFo.TB.Dy, &H, &M, &S);
           InFo.TB.Ns = 0;
           if (BatchTime[0] >= 0)
           {
              InFo.TB.Yr = BatchTime[0];
              InFo.TB.Dy = BatchTime[1];
              InFo.TB.Ms = (BatchTime[2] * 3600 + BatchTime[3] * 60 + 
                            BatchTime[4]) * 1000;
            }
            else
               InFo.TB.Ms = (H * 3600 + M * 60 + S) * 1000;
         break;
         case 1:
           BreaKOuT (Qs->CReply, (ByTe_1 *)0, 0, 0);
           sscanf (Qs->CReply, Qs->Fmt, &InFo.TE.Yr, &InFo.TE.Dy, &H, &M, &S);
           InFo.TE.Ns = 0;
            if (BatchTime[0] >= 0)
            {
               InFo.TE.Yr = BatchTime[5];
               InFo.TE.Dy = BatchTime[6];
               InFo.TE.Ms = (BatchTime[7] * 3600 + BatchTime[8] * 60 + 
                             BatchTime[9]) * 1000;
            }
            else
               InFo.TE.Ms = (H * 3600 + M * 60 + S) * 1000;
         break;
         case 2:
           InFo.EmptySrc = 0;
           InFo.NSrcs = Qs->NWins;
           if (Qs->NWins > 0)
              strcpy (InFo.SrcWns, Qs->Wins);

           B = InFo.NSrcs * sizeof (struct SrcInfo);
           if ((InFo.Src = malloc (B)) == 0)
              exit(-1); 
         break;
         case 3:
           strcpy (InFo.OutFile, Qs->CReply);
         break;
         case 4:
           strcpy (InFo.OutFmt, Qs->CReply);
           c1 = InFo.OutFmt;
           InFo.NeedInt = 1;
           while (*c1 != 0)
           {
              if (*c1 == 'g' || *c1 == 'e' || *c1 == 'f') 
                 InFo.NeedInt = 0;
              ++c1;
           } 
         break;
      }
   }
}
