#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "PidfStr.h"
#include "PidfAnsi.h"
#include "PidfRets.h"
#include "PidfDefs.h"
#include "libbase_udf.h"

#include "ADump_str.h"
#include "ADump_ansi.h"

void DupSrc (ByTe_2 SrcB, ByTe_2 N, ByTe_2 UnitN)
{
   extern struct UserDefs InFo;
   struct SrcInfo *S, *Sn;

   struct Pidf *P;
   struct PidfSensor *Ps;
   struct PidfMode *Pm;
   struct PidfUnit *Pu;
   struct PidfAnc *Pa;

   ByTe_2 PGNum, VGNum;
   ByTe_2 PSNum, VSNum;
   ByTe_1 SRCid;

   if (UnitN < 0)
      return;

   S = (struct SrcInfo *)InFo.Src + SrcB;
   Sn = (struct SrcInfo *)InFo.Src + InFo.EmptySrc++;
   P = (struct Pidf *)InFo.PIDF;

   SRCid = S->DType;
   switch (S->DType)                               /* switch on data type    */
   {                                               /* BEG DATA TYPE SWITCH   */
      case 0:                                      /* START SENSOR           */
      case 1:                                      /* START SCAN             */
        Ps = (struct PidfSensor *)P->Sensors + N;  /* Sensor Info            */ 
        PGNum = Ps->PidfNum;                       /* Xfer Pidf Get Num      */
        VSNum = (Ps->Src == 'A') ? Ps->AncSen : Ps->VidfNum;
        SRCid = (Ps->Src == 'A') ? 2 : S->DType;
        VGNum = Ps->VidfNum;                       /* Xfer Vidf Get Num      */
        PSNum = Ps->PidfNum;                       /* Xfer Pidf Sen Num      */
      break;                                       /* STOP SENSOR OR SCAN    */
      case 2:                                      /* START SCAN             */
        Pa = (struct PidfAnc *)P->Ancil + N;       /* Sensor Info            */ 
        PGNum = Pa->PidfNum;                       /* Xfer Pidf Get Num      */
        VGNum = Pa->VidfNum;                       /* Xfer Vidf Get Num      */
        PSNum = S->SenPN;                          /* Xfer Pidf Sen Num      */
        VSNum = S->SenVN;                          /* Xfer Vidf Sen Num      */
      break;                                       /* STOP SENSOR OR SCAN    */
      case 6:                                      /* START MODE             */
        Ps = (struct PidfSensor *)P->Sensors;      /* Sensor 0 Info          */ 
        Pm = (struct PidfMode *)P->Modes + N;      /* Mode Info              */ 
        PGNum = Pm->PidfNum;                       /* Xfer Pidf Get Num      */
        VGNum = Pm->VidfNum;                       /* Xfer Vidf Get Num      */
        PSNum = Ps->PidfNum;                       /* Xfer Dummy Pidf Sen #  */
        VSNum = Ps->VidfNum;                       /* Xfer Dummy Vidf Sen #  */
      break;                                       /* STOP MODE              */
   }                                               /* BEG DATA TYPE SWITCH   */

   Sn->P = S->P;                                    /* Xfer Project          */
   Sn->M = S->M;                                    /* Xfer Mission          */
   Sn->E = S->E;                                    /* Xfer Experiment       */
   Sn->I = S->I;                                    /* Xfer Instrument       */
   Sn->V = S->V;                                    /* Xfer Project          */
   Sn->Key = S->Key;                                /* Xfer Project          */
   Sn->Ver = S->Ver;                                /* Xfer Version          */
   Sn->DType = S->DType;                            /* Xfer Data Type        */
   Sn->Group = S->Group;                            /* Xfer Group            */
   Sn->SenPN = PSNum;                               /* Xfer Pidf Num         */
   Sn->GetPN = PGNum;                               /* Xfer Pidf Num         */
   Sn->SenVN = VSNum;                               /* Xfer Vidf Num         */
   Sn->GetVN = VGNum;                               /* Xfer Vidf Num         */
   Sn->GetUN = UnitN;                               /* Xfer Unit Number      */
   Sn->AltUN = S->AltUN;                            /* Xfer Alt Unit Num     */
   Sn->UDFSrc = SRCid;                              /* Xfer source id        */
   Sn->TotMCols = S->TotMCols;                      /* Xfer matrix columns   */
   Sn->SenRN = S->SenRN;                            /* Xfer matrix col num   */
   Sn->BufSize = 0;                                 /* Empty Buffer          */
   Sn->OneAll = -1;                                 /* Not Parent Sensor     */
   Sn->Pri = 0;                                     /* No Sensor Memory      */
   Sn->Alt = 0;                                     /* No Alt Memory         */
   Sn->Pha = 0;                                     /* No Phase Memory       */
   Sn->Pol = 0;                                     /* No Polar Memory       */
   Sn->Phase = (S->Phase == 2) ? 1 : 0;             /* phase data flag       */
   Sn->Polar = (S->Polar == 2) ? 1 : 0;             /* polar data flag       */
   Pu = (struct PidfUnit *)P->Units + UnitN;        /* Unit Info             */
   Sn->GetNAS = Pu->NTbls;                          /* Num Alg Steps         */
   if (Pu->NTbls > 0) 
   {
      Sn->GetTbls = TransFer(Pu->Tbls, 1, (ByTe_2)Pu->NTbls);
      Sn->GetOps = TransFer((ByTe_1 *)Pu->Ops, 2, (ByTe_2)Pu->NTbls);
   }

   if (S->AltUN >= 0)
   {
      Pu = (struct PidfUnit *)P->Units + S->AltUN;
      Sn->AltNAS = Pu->NTbls;

      if (Pu->NTbls > 0)
      {
         Sn->AltTbls = TransFer(Pu->Tbls, 1, (ByTe_2)Pu->NTbls);
         Sn->AltOps = TransFer((ByTe_1 *)Pu->Ops, 2, (ByTe_2)Pu->NTbls); 
      }
   }
}
