C*PWI -- Calibrate DE PWI data and write it to a file.
C+
      PROGRAM PWI
C
C This program will ask the user several questions to allow him/her to
C specify the desired data, and will create a user-specified output file
C containing this data.  The format of the output file is discussed in
C the software metadata files located on the optical disk.
C
C Inputs:
C
C   1) The type of data desired.
C   2) The time interval of the desired data.
C   3) The full name of the output file to write.
C
C   Depending on the type of data requested, the user may also be asked
C   for the desired receiver (A or B).
C
C Outputs:
C
C   The output consists of an ASCII file containing the following items
C   for each data measurement contained in the time interval.
C
C      1) The time of the measurement.
C      2) The frequency of the measurement (if appropriate).
C      3) The data value(s) expressed in physical units.
C      4) An indication of the quality of the data (if appropriate).
C      5) The antenna(s) used during the measurement.
C      6) The geocentric radial distance of the spacecraft.
C      7) The L-Shell value.
C      8) The magnetic local time.
C      9) The magnetic latitude.
C--
C Version 1.0  01-Jun-1990  Scott C. Allendorf
C                           - Original version.
C-----------------------------------------------------------------------
      INTEGER HR, IERR, MINS, OPNUSE, OUNIT, RCV, SEC, TEMP, TYPE
      INTEGER USEBEG(2), USEEND(2)
      CHARACTER FILNAM*80, RCVSTR*80
C
C Print out a warning message.
C
      WRITE (*, '(A)') ' '
      WRITE (*, '(A)') '                WARNING'
      WRITE (*, '(A)') ' '
      WRITE (*, '(A)') ' This program has the potential to'
      WRITE (*, '(A)') ' produce large amounts of output.  Choose'
      WRITE (*, '(A)') ' your input parameters carefully.'
C
C Get the type of data from the user.
C
   10 WRITE (*, '(A)') ' '
      WRITE (*, '(A)') ' Available types of data:'
      WRITE (*, '(A)') ' '
      WRITE (*, '(A)') '    0 - SFR Amplitudes'
      WRITE (*, '(A)') '    1 - LFC Amplitudes'
      WRITE (*, '(A)') '    2 - SFR Phases'
      WRITE (*, '(A)') '    3 - LFC Phases'
      WRITE (*, '(A)') '    4 - DC Electric Fields'
      WRITE (*, '(A)') ' '
      WRITE (*, '(A)') '$Enter desired type of data (0-4): '
      READ  (*, *, END = 999, ERR = 20) TYPE
C
C Check for user input error.
C
      IF ((TYPE .GE. 0) .AND. (TYPE .LE. 4)) GOTO 30
C
C Handle errors in the input.
C
   20 WRITE (*, '(A)') ' '
      WRITE (*, '(A)') ' ERROR: INVALID DATA TYPE CODE.'
      GOTO 10
C
C If the user requested the SFR, get the desired receiver.
C
   30 IF (TYPE .EQ. 0) THEN
   40    WRITE (*, '(A)') ' '
         WRITE (*, '(A)') '$Enter the desired receiver (A or B): '
         READ  (*, '(A)', END = 999, ERR = 50) RCVSTR
C
C Check for user input error.
C
         IF ((RCVSTR(1:1) .EQ. 'A') .OR. (RCVSTR(1:1) .EQ. 'B') .OR.
     +       (RCVSTR(1:1) .EQ. 'a') .OR. (RCVSTR(1:1) .EQ. 'b')) GOTO 60
C
C Handle errors in the input.
C
   50    WRITE (*, '(A)') ' '
         WRITE (*, '(A)') ' ERROR: INVALID RECEIVER CODE.'
         GOTO 40
C
C Convert the user input to a numeric quantity.
C
   60    IF ((RCVSTR(1:1) .EQ. 'A') .OR. (RCVSTR(1:1) .EQ. 'a')) THEN
            RCV = 0
         ELSE
            RCV = 1
         END IF
C
C If the user requested the LFC, get the desired correlator.
C
      ELSE IF (TYPE .EQ. 1) THEN
   70    WRITE (*, '(A)') ' '
         WRITE (*, '(A)') '$Enter the desired correlator (A or B): '
         READ  (*, '(A)', END = 999, ERR = 80) RCVSTR
C
C Check for user input error.
C
         IF ((RCVSTR(1:1) .EQ. 'A') .OR. (RCVSTR(1:1) .EQ. 'B') .OR.
     +       (RCVSTR(1:1) .EQ. 'a') .OR. (RCVSTR(1:1) .EQ. 'b')) GOTO 90
C
C Handle errors in the input.
C
   80    WRITE (*, '(A)') ' '
         WRITE (*, '(A)') ' ERROR: INVALID CORRELATOR CODE.'
         GOTO 70
C
C Convert the user input to a numeric quantity.
C
   90    IF ((RCVSTR(1:1) .EQ. 'A') .OR. (RCVSTR(1:1) .EQ. 'a')) THEN
            RCV = 0
         ELSE
            RCV = 1
         END IF
      END IF
C
C Get the start time from the user.
C
  100 WRITE (*, '(A)') ' '
      WRITE (*, '(A)') '$Enter the desired start time (YYDDD HHMMSS): '
      READ  (*, *, END = 999, ERR = 110) USEBEG(1), TEMP
C
C Check for user input error.  First, extract the hours and check for a
C valid range.
C
      HR = TEMP / 10000
      IF ((HR .GE. 0) .AND. (HR .LE. 23)) THEN
C
C Extract the minutes and check for a valid range.
C
         MINS = MOD (TEMP / 100, 100)
         IF ((MINS .GE. 0) .AND. (MINS .LE. 59)) THEN
C
C Extract the seconds and check for a valid range.
C
            SEC = MOD (TEMP, 100)
            IF ((SEC .GE. 0) .AND. (SEC .LE. 59)) THEN
C
C Convert the user start time to milliseconds.
C
               USEBEG(2) = ((HR * 60 + MINS) * 60 + SEC) * 1000
C
C Verify that the user input time is valid.
C
               CALL TIMADD (USEBEG, 0, USEBEG, IERR)
               IF (IERR .EQ. 1) GOTO 120
            END IF
         END IF
      END IF
C
C Handle errors in the input.
C
  110 WRITE (*, '(A)') ' '
      WRITE (*, '(A)') ' ERROR: INVALID START TIME.'
      GOTO 100
C
C Get the stop time from the user.
C
  120 WRITE (*, '(A)') ' '
      WRITE (*, '(A)') '$Enter the desired stop time (YYDDD HHMMSS):  '
      READ  (*, *, END = 999, ERR = 130) USEEND(1), TEMP
C
C Check for user input error.  First, extract the hours and check for a
C valid range.
C
      HR = TEMP / 10000
      IF ((HR .GE. 0) .AND. (HR .LE. 23)) THEN
C
C Extract the minutes and check for a valid range.
C
         MINS = MOD (TEMP / 100, 100)
         IF ((MINS .GE. 0) .AND. (MINS .LE. 59)) THEN
C
C Extract the seconds and check for a valid range.
C
            SEC = MOD (TEMP, 100)
            IF ((SEC .GE. 0) .AND. (SEC .LE. 59)) THEN
C
C Convert the user stop time to milliseconds.
C
               USEEND(2) = ((HR * 60 + MINS) * 60 + SEC) * 1000
C
C Verify that the user input time is valid.
C
               CALL TIMADD (USEEND, 0, USEEND, IERR)
               IF (IERR .EQ. 1) GOTO 140
            END IF
         END IF
      END IF
C
C Handle errors in the input.
C
  130 WRITE (*, '(A)') ' '
      WRITE (*, '(A)') ' ERROR: INVALID STOP TIME.'
      GOTO 120
C
C Get the output filename from the user.
C
  140 WRITE (*, '(A)') ' '
      WRITE (*, '(A)') '$Enter the output file name: '
      READ  (*, '(A)', END = 999, ERR = 150) FILNAM
      WRITE (*, '(A)') ' '
C
C Check to see that the specified file may be opened.
C
      OUNIT = OPNUSE (FILNAM)
      IF (OUNIT .LT. 0) GOTO 150
C
C The file may be opened, now close and delete it.
C
      CLOSE (OUNIT, STATUS = 'DELETE')
      GOTO 160
C
C Handle errors in the input.
C
  150 WRITE (*, '(A)') ' ERROR: INVALID FILE.'
      GOTO 140
C
C Do the necessary work.
C
  160 CALL DOIT (USEBEG, USEEND, TYPE, RCV, FILNAM)
C
C All done.
C
  999 WRITE (*, '(A)') ' '
      WRITE (*, '(A)') ' Have a nice day.'
      END
