#!/usr/bin/python

import sys

def main(argv):
	
	perr = sys.stdout.write
	
	if len(argv) < 2 or argv[1] == '-h' or argv[1] == '--help':
		perr("check_sweep.py FILE1 FILE2 FILE3 ...\n")
		perr("\n")
		perr("Reads DE low-rate binary files and dumps the sweep rate indicator\n")
	
	
	for sPath in argv[1:]:
		fIn = file(sPath, 'rb')
		
		nRec = 1
		sRec = fIn.read(442 * 4)
		
		while len(sRec) == (442 * 4):
			
			nByte = ord(sRec[8*4])
			lTmp = [ ord(sRec[8*4]), ord(sRec[8*4+1]), ord(sRec[8*4+2]), ord(sRec[8*4+3])]
			lWord = [ "%02X"%n for n in lTmp ]
			
			lSweep = [ (n >> 7) & 0x1 for n in lTmp ]
			
			#if lSweep != [0,0,0,0]:
				#sSweep = "x1 rate (32 sec)"
				#sSweep = "x4 rate (8 sec)"
			print "sPath, rec %04d: Sweep State: %s"%(nRec, lSweep)
			
			#print "Word 9:", lWord, " Sweep:", nSweep, sSweep
			#print sSweep
			
			nRec += 1
			sRec = fIn.read(442 * 4)
			
	
	return 0
	
if __name__ == '__main__':
	sys.exit(main(sys.argv))
