      SUBROUTINE SUBOPTR (LUN)
C
C-----------------------------------------------------------------------
C
C     Writes the current subperiod start and stop times to the unit
C     number specified.
C
C     Written by     R. L. WEST     BCSS      4-JAN-1990
C
C-----------------------------------------------------------------------
C
      INTEGER*2 LUN,NDIV
C
      INTEGER*4 SLIMS(4)
C
      REAL*8    STRIP_TIMES(4)
C
      COMMON    /COMLIM/STRIP_TIMES,NDIV
C
C-----------------------------------------------------------------------
C     *** convert from REAL*8 to INTEGER*4 ***
C-----------------------------------------------------------------------
C
      SLIMS(1)=STRIP_TIMES(1)
      SLIMS(2)=STRIP_TIMES(2)/1000.0D0
      SLIMS(3)=STRIP_TIMES(3)
      SLIMS(4)=STRIP_TIMES(4)/1000.0D0
C
C-----------------------------------------------------------------------
C     *** convert from milliseconds to hours,minutes,seconds,millis ***
C-----------------------------------------------------------------------
C
      CALL MSHMSM (SLIMS(2),IH,IM,IS,MS)
      CALL MSHMSM (SLIMS(4),JH,JM,JS,MS)
C
C-----------------------------------------------------------------------
C     *** output the time ***
C-----------------------------------------------------------------------
C
      WRITE (LUN,50) SLIMS(1),IH,IM,IS,SLIMS(3),JH,JM,JS
   50 FORMAT (' CURRENT SUBPERIOD TIME LIMITS ',2(I5,I3,2(':',I2) ) )
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END
