	SUBROUTINE SRTRP2(MODBLK,CTS,ICTN,I1,I2,JFLAG,IRPA,NDIF)
C
C THIS SUBROUTINE SORTS DATA FOR A GIVEN HEAD AND GIVEN MASS IN
C TERMS OF INSTRUMENT RPA SETTING.
C
C NOTE *** THIS VERSION FOR CESPEC PROGRAM ***
C
C INPUT ARGUMENTS ARE:
C	MODBLK	SEE SENTGS INPUT SUBROUTINE
C	I1    - START SAMPLE INDEX OF DATA TO BE INCLUDED
C	I2    - STOP SAMPLE INDEX. I1, I2 ARE IN RANGE [1,512]
C       IRPA  - CONTAINS THE NDIF SORTED UNIQUE RPA SETTINGS FOR THIS
C               MODE
C       NDIF  - NUMBER OF IRPA VALUES
C OUTPUT ARGUMENTS, IN ADDITION TO CTS, CTN,
C	JFLAG - SET TO 0 IF NO DATA ADDED TO ARRAYS, OTHERWISE 1
C
C THE ARRAYS CTS(NANG) AND ICTN(NANG) ARE UPDATED APPROPRIATELY
C NOTE *** BEFORE THIS ROUTINE IS CALLED, THE INFORMATION IN THE
C FOLLOWING COMMON BLOCKS MUST BE DEFINED
C	COMMON	UPDATED BY CALLING
C	------	------------------
C	RPAMSH	GETMOD.  CONTAINS INSTRUMENT RPA, IMS SETTINGS
C	I7FLGS	DEFFGS.  CONTAINS INSTRUMENT MODE FLAGS.
C
C V1.0 JFE JOHNSON 22 OCT 82
C
	INTEGER*4 IDCODC
	INTEGER JRPA(512),JMSH(512),MODBLK(8)
	INTEGER IDAT(2812),ICDE(512,2),JCR(512,2)
	INTEGER ICTN(32),IRPA(NDIF)
	REAL CTS(32)
	EQUIVALENCE (ICDE(1,1),IDAT(1789))
	EQUIVALENCE (JCR(1,1),IDAT(253))
	COMMON/RPAMSH/JRPA,JMSH
	COMMON/MAF1/IDAT
C
	JFLAG=0
C
C FIRST CALL REFANG, TO DEFINE PHASE ANGLE REFERENCE
C
	CALL REFANG(DEGSAM,RAMANG)
C
	IF(MODBLK(1).EQ.1)GO TO 601
C Z HEAD PROCESSING
	IDET=(MODBLK(1)-2)*2+MODBLK(2)
	DO 630 I=I1,I2
C SCAN THE RPA SETTING TABLE TO DETERMINE INDEX
	DO 500 IRP=1,NDIF
	IF(JRPA(I).EQ.IRPA(IRP))GO TO 501
  500	CONTINUE
	GO TO 630			! NO VALUE FOUND
  501	CONTINUE
C CHECK THIS SAMPLE IS IN THE ANGLE RANGE REQUIRED
	IANG=ISANGL(DEGSAM,RAMANG,I)
	IF(IANG.LT.MODBLK(7).OR.IANG.GT.MODBLK(8))GO TO 630
C CHECK THAT THIS MASS IS IN THE RANGE REQUIRED
	IF(JMSH(I).LT.MODBLK(3).OR.JMSH(I).GT.MODBLK(4))GO TO 630
C CHECK WE HAVE DATA FOR THIS Z HEAD DETECTOR
	ICH=IGTZMS(IDET,I)
	IF(ICH.LE.0)GO TO 630
	JFLAG=1
	CTS(IRP)=CTS(IRP)+IDCODC(ICDE(I,ICH),IC)
	ICTN(IRP)=ICTN(IRP)+IC
  630	CONTINUE
  610	CONTINUE
	GO TO 600
C
  601	CONTINUE
C RADIAL HEAD PROCESSING
	DO 700 I=I1,I2
C SCAN THE RPA SETTING TABLE TO DETERMINE INDEX
	DO 502 IRP=1,NDIF
	IF(JRPA(I).EQ.IRPA(IRP))GO TO 503
  502	CONTINUE
	GO TO 700			! NO VALUE FOUND
  503	CONTINUE
C CHECK THIS SAMPLE IS IN THE ANGLE RANGE REQUIRED
	IANG=ISANGL(DEGSAM,RAMANG,I)
	IF(IANG.LT.MODBLK(7).OR.IANG.GT.MODBLK(8))GO TO 700
C CHECK THAT THIS MASS IS IN THE RANGE REQUIRED
	IF(JMSH(I).LT.MODBLK(3).OR.JMSH(I).GT.MODBLK(4))GO TO 700
	JFLAG=1
	CTS(IRP)=CTS(IRP)+IDCODC(JCR(I,MODBLK(2)),IC)
	ICTN(IRP)=ICTN(IRP)+IC
  700	CONTINUE
C
  600	CONTINUE
	RETURN
	END
