	PROGRAM SENTGS
C
C-----------------------------------------------------------------------
C SENTGS.FOR --- SPIN/ENERGY TIME SPECTROGRAM PROGRAM, RUNS OFF MAF1
C                FORMAT DATA.
C-----------------------------------------------------------------------
C
C     *****     COMPILE /NOI4     ***
C
C-----------------------------------------------------------------------
C
C V1.0 4 MAR 82 STEVE JEFFERYS/JFE JOHNSON     **
C
C V2.0 JFE JOHNSON 25 JUL 82 SOMETHING OF A REWRITE, USE OF MODBLK
C
C                  25 AUG 82 CALLS GETMD1, SUPPRESS NEWFRM FOR BLANK FRAMES
C
C V2.1 JFEJ         8 SEP 82 ADDED CALL TO PITPHA, MIN PITCH ANGLE PLOT
C
C V3.0 CREATED BY J.GREEN ADDED TO SENTGS BY D.STATUM MARCH83
C
C V4.0 B. GILES    11 SEP 85 OPTION TO SELECT BIAS VOLTAGE
C
C V4.1 R.L.WEST BCSS  8 JUL 86 INCORPORATED NEW VERSION OF IDCODC
C
C V5.0 R.L.WEST BCSS  3 DEC 87 MODIFIED TO NOT DO ANY PLOTTING SO CAN
C                              BE PUT ON OPTICAL DISK FOR GSFC
C V5.1 R.L.WEST BCSS 10 MAR 88 ELIMINATED THE EXTRA CALL TO GETMF1 ON
C                              THE SECOND AND SUBSEQUENT PLOTS (IFIRST1)
C-----------------------------------------------------------------------
C-------------------------------------------------------------------
C     V6.0
C     modified by     R.L. WEST     BCSS     31-MAR-1989
C            Eliminated all plotting calls, instead write enough
C            information to FOR002.DAT to create the plot
C-------------------------------------------------------------------
C
C
	BYTE ICX
C
	INTEGER KODE,MODBLK(8)
C
C-----------------------------------------------------------------------
C INITIALISATION
C-----------------------------------------------------------------------
C
	LIN=1
	LUNTI=5
	LUNTO=6
	CALL DELUNS(LIN,LUNTI,LUNTO)
	WRITE(LUNTO,50)
   50	FORMAT(' SENTGS V6.0')
	CALL DEOPEN
  100	CONTINUE
	CALL INPUT_SENTGS(KODE,MODBLK,NANG,ICX)
	IF(KODE.EQ.-1)GO TO 500
C
C---------------------------------------------------------------------
C PROCESSING
C-----------------------------------------------------------------------
C
  200	CONTINUE
	CALL PROCES_SENTGS(MODBLK,IRET,KFLAG,NANG,ICX)
C
C-----------------------------------------------------------------------
C END OF FILE LOGIC
C-----------------------------------------------------------------------
C
  	IF(IRET.EQ.-10)WRITE(LUNTO,300)
  300	FORMAT(' END OF FILE')
	IF(IRET.EQ.1)WRITE(LUNTO,400)
  400	FORMAT(' NO MORE SUBPERIODS')
	CALL DEFFRAR (KODE)
	IF (KODE .NE. 0) THEN
	   WRITE (LUNTO,450)
  450	   FORMAT (' NO MORE FRAMES')
	   CALL REWDED
	   GO TO 100
	END IF
	GO TO 200
C
C-----------------------------------------------------------------------
C NORMAL EXIT
C-----------------------------------------------------------------------
C
  500	CONTINUE
	CALL EXIT
	STOP
	END

	SUBROUTINE INPUT_SENTGS(KODE,MODBLK,NANG,ICX)
C
C-----------------------------------------------------------------------
C INPUT SUBROUTINE FOR SENTGS
C
C THE MODBLK ARRAY STORES A GIVEN DATA SELECTION, AS FOLLOWS
C   ELEMENT   FUNCTIONS		VALUES
C	1	HEAD		1=RADIAL,2=+Z,3=-Z
C	2	ILOHI		1=LO MASS,2=HI MASS
C	3	IM1		LOWER MASS SETTING
C	4	IM2		UPPER MASS SETTING
C	5	IRPA1		LOWER RPA SETTING
C	6	IRPA2		UPPER RPA SETTING
C	7	IANG1		LOWER PHASE ANGLE (+/- 180)
C	8	IANG2		UPPER PHASE ANGLE (+/- 180)
C-----------------------------------------------------------------------
C
	BYTE ICX,TEXT(4)
	INTEGER MODBLK(8)
	COMMON/DELUNS/LUNI,LUNIN,LUNOUT
C
C-----------------------------------------------------------------------
C GET START AND STOP TIMES AND DURATION OF EACH FRAME
C-----------------------------------------------------------------------
C
	CALL LMSSETR (KODE)
	IF(KODE.EQ.-1)GO TO 99
	CALL FRASETR (KODE)
C
C-----------------------------------------------------------------------
C DEFINE WHICH HEAD
C-----------------------------------------------------------------------
C
	CALL HEDSET(MODBLK(1))
	IF(MODBLK(1).EQ.4) GO TO 10
C
C-----------------------------------------------------------------------
C DEFINE MASS SETTING RANGE
C-----------------------------------------------------------------------
C
	CALL MASSET(JM1,JM2)
C
C-----------------------------------------------------------------------
C SINGLE MASS DET DEFINE ILOHI LO/HI FLAG
C-----------------------------------------------------------------------
C
	CALL MASTXT(JM1,JM2,MODBLK(2),TEXT,TEXT)
	MODBLK(3)=JM1
	MODBLK(4)=JM2
	CALL MASCNV(MODBLK(3),MODBLK(4))
   10	CONTINUE
C
C-----------------------------------------------------------------------
C DEFINE RPA RANGE
C-----------------------------------------------------------------------
C
	CALL RPASET(MODBLK(5),MODBLK(6))
C
C-----------------------------------------------------------------------
C DEFINE ANGLE RANGE
C-----------------------------------------------------------------------
C
	CALL ANGSET(MODBLK(7),MODBLK(8))
C
C-----------------------------------------------------------------------
C DEFINE # ANGLE BINS
C-----------------------------------------------------------------------
C
	NANG=0
   51	WRITE(LUNOUT,50)
   50	FORMAT($,' GIVE THE NUMBER OF ANGLE BINS (0==32): ')
	READ(LUNIN,*,END=99)NANG
	IF(NANG.GT.360)GO TO 51
	IF(NANG.LE.0)NANG=32
C
C-----------------------------------------------------------------------
C DEFINE APERTURE BIAS
C-----------------------------------------------------------------------
C
	CALL APSET(ICX)
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
   99	RETURN
	END

	SUBROUTINE PROCES_SENTGS(MODBLK,KODE,LFLAG,NANG,ICX)
C
C-----------------------------------------------------------------------
C THIS ROUTINE DOES ALL THE DATA ACCUMULATION 
C PART OF THE SENTGS PROGRAM
C-----------------------------------------------------------------------
C
        LOGICAL   IFIRST1
C
	BYTE      ICX
C
	INTEGER*2 CTN(360,2),INUM,MODBLK(8)
C
	INTEGER*4 FTMS1(4),IFIRST(2),IORBOFT,IORBTIME,IORBYD,
     *            ISTRIP_TIMES(180,2),ITIME(2,13),PITCH_ANGLE(180,2)
	INTEGER*4 IRECYD,IRECMS
C
	REAL      CTS(360,2),ORBS(4,13),RPA_DATA(180,32),RPA_VAL(32),
     *            SPN_DATA(180,360),SPN_VAL(360)
C
	REAL*8    STMS(4),FTMS(4)
C
	COMMON    /COMLIM/STMS,
     *	          /DELUNS/LUNDAT,LUNTI,LUNTO,
     *	          /FRATMS/FTMS,NDIV,
     *            /ORBDAT/ITIME,ORBS
     *            /ORBIT/IORBOFT,IORBYD,IORBTIME,INUM,IFIRST
	COMMON /BLKTIM/IRECYD,IRECMS
C
	DATA      IFIRST1/.TRUE./,
     *	          RPA_VAL/0.0, 0.05, 0.10, 0.15, 0.20, 0.25, 0.30, 0.35,
     *                    0.45, 0.55, 0.65, 0.85, 1.05, 1.25, 1.6, 1.95,
     *                    2.45, 3.00, 3.75, 4.65, 5.75, 7.15, 8.9, 11.0,
     *                   13.7, 16.9, 21.1, 26.1, 32.4, 40.3, 50.0,51.15/
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
	LFLAG=0
	MFLAG=0			! FLAG FOR PITCH ANGLE IDENT
C
C-----------------------------------------------------------------------
C DEFINE AND OUTPUT NEW TIME LIMITS 
C-----------------------------------------------------------------------
C
	CALL FRAOPTR (LUNTO)
	CALL SUBOPTR (LUNTO)
C
C-----------------------------------------------------------------------
C INITIALISE THE ORBIT PARAMETERS AND INITIALIZE SAVE INFORMATION
C-----------------------------------------------------------------------
C
	CALL ORBOFTR
	DO 200 I=1,11
	   ITIME(1,I)=-1
           ITIME(2,I)=-1
           DO 100 J=1,4
              ORBS(J,I)=0.0
  100	   CONTINUE
  200	CONTINUE
C
C-----------------------------------------------------------------------
C GET FIRST BLOCK IN
C-----------------------------------------------------------------------
C
	IF (IFIRST1) THEN
	   CALL GETMF1(KODE)
	   IF(KODE.EQ.-10)GO TO 1400
	   IFIRST1=.FALSE.
	END IF
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
	INDIV=0
	DO 1300 IDIV=1,NDIV
	   INDIV=INDIV+1
C-----------------------------------------------------------------------
C		INITIALISE WORKING ARRAYS
C-----------------------------------------------------------------------
	   MINANG=-1000
	   JFLAG=0
	   DO 300 I=1,360
	      CTS(I,1)=0.0
	      CTN(I,1)=0
	      CTN(I,2)=0
	      CTS(I,2)=0.0
  300	   CONTINUE
C-----------------------------------------------------------------------
C		DATA WITHIN TIME LIMITS
C-----------------------------------------------------------------------
  400	   CALL LMSTSSR (KODE,I1,I2)
	   IF(KODE)500,600,1200
C-----------------------------------------------------------------------
C		GET NEXT RECORD
C-----------------------------------------------------------------------
  500	   CALL GETMF1(KODE)
	   IF(KODE.EQ.-10)GO TO 1400		! END OF FILE
	   GO TO 400
  600	   CONTINUE
C-----------------------------------------------------------------------
C		THIS BLOCK IN CURRENT LIMITS SO PROCESS
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C		SEE IF TIME TO SAVE ORBIT PARAMETERS
C-----------------------------------------------------------------------
	   CALL ORB_SAVE
C-----------------------------------------------------------------------
C 		TEST IF DATA IS WITHIN REQUIRED APERTURE BIAS RANGE
C-----------------------------------------------------------------------
	   CALL APTST(ICX,KODE)
	   IF(KODE.EQ.-1)GOTO 700
C-----------------------------------------------------------------------
C		WITHIN APERTURE BIAS LIMITS - CONTINUE PROCESSING
C-----------------------------------------------------------------------
	   CALL DEFFGS				! DEFINE FLAGS
	   CALL GETMD1				! AND INSTRUMENT MODE
C-----------------------------------------------------------------------
C		PROCESS THE DATA FOR SPIN-TIME ARRAY
C-----------------------------------------------------------------------
	   ILH=1
	   IF(MINANG.EQ.-1000)CALL PITPHA(MINANG)
	   CALL SRTANG(MODBLK,CTS(1,ILH),CTN(1,ILH),NANG,I1,I2,KFLAG)
	   JFLAG=MAX0(JFLAG,KFLAG)
	   LFLAG=MAX0(JFLAG,LFLAG)
C-----------------------------------------------------------------------
C		NOW PROCESS DATA FOR ENERGY-TIME PANEL
C-----------------------------------------------------------------------
	   ILH =2
 	   CALL SRTRPA_SENTGS(MODBLK,CTS(1,ILH),CTN(1,ILH),I1,I2,KFLAG)
	   JFLAG=MAX0(JFLAG,KFLAG)
	   LFLAG=MAX0(JFLAG,LFLAG)
  700	   CONTINUE
C-----------------------------------------------------------------------
C SAVE ORBIT DATA FOR THIS SUBPERIOD IF NECESSARY
C-----------------------------------------------------------------------
  	   IF(I2.EQ.512)GO TO 500
C-----------------------------------------------------------------------
C		INTERPOLATE DATA
C-----------------------------------------------------------------------
	   IF(JFLAG.NE.1)GO TO 1100
	   DO 1000 ILH=1,2
	      DO 900 I=1,360
	         IF(CTN(I,ILH).LE.0) THEN
	            CTS(I,ILH)=-1.0
	         ELSE
	            CTS(I,ILH)=CTS(I,ILH)/FLOAT(CTN(I,ILH))
	         END IF
  900	      CONTINUE
 1000	   CONTINUE
C-----------------------------------------------------------------------
C		PUT THE DATA IN THE STORAGE ARRAYS
C-----------------------------------------------------------------------
	   IFLAG=1
	   ISTRIP_TIMES(IDIV,1)=STMS(1)+80000.0D0
           ISTRIP_TIMES(IDIV,2)=STMS(2)/1000.0D0
	   DO ISPN=1,NANG
	      SPN_DATA(IDIV,ISPN)=CTS(ISPN,1)
	   END DO
	   DO IRPA=1,32
	      RPA_DATA(IDIV,IRPA)=CTS(IRPA,2)
	   END DO
C-----------------------------------------------------------------------
C		DRAW LINE FOR MINIMUM PITCH ANGLE (RADIAL HEAD ONLY)
C-----------------------------------------------------------------------
	   IF(MODBLK(1).NE.1)GO TO 1100
	   IF(MINANG.EQ.-1000)GO TO 1100
	   PITCH_ANGLE(IDIV,1)=MINANG
	   MFLAG=1
	   MAXANG=MINANG+180
	   IF(MAXANG.GT.180)MAXANG=MAXANG-360
	   PITCH_ANGLE(IDIV,2)=MAXANG
 1100	   CONTINUE
C-----------------------------------------------------------------------
C		AND GET NEXT LIMITS
C-----------------------------------------------------------------------
 1200	   CALL LMSNXTR (KODE)
	   CALL SUBOPTR (LUNTO)
	   IF(KODE.NE.0)GO TO 1400
 1300	CONTINUE
C
C-----------------------------------------------------------------------
C OUTPUT DATA ARRARY TO OUTPUT FILE
C-----------------------------------------------------------------------
C
 1400	CONTINUE
	FTMS1(1)=FTMS(1)+80000.0D0
	FTMS1(2)=FTMS(2)/1000.0D0
	FTMS1(3)=FTMS(3)+80000.0D0
	FTMS1(4)=FTMS(4)/1000.0D0
        WRITE (2) (MODBLK(I),I=1,8),(FTMS1(I),I=1,4),ICX
        NDIF=32
	WRITE (2) INUM,INDIV,NANG,NDIF
	DO I=1,INUM
	   WRITE (2) ITIME(1,I)+80,ITIME(2,I),(ORBS(J,I),J=1,4)
        END DO
	BIN_SIZE=360.0/FLOAT(NANG)
	DO I=1,NANG
	   SPN_VAL(I)=-180.0+BIN_SIZE/2.0+FLOAT(I-1)*BIN_SIZE
	END DO
        WRITE (2) (SPN_VAL(I),I=1,NANG)
        WRITE (2) (RPA_VAL(I),I=1,NDIF)
        DO I=1,NDIV
           WRITE (2) ISTRIP_TIMES(I,1),ISTRIP_TIMES(I,2),
     *               (PITCH_ANGLE(I,J),J=1,2)
           WRITE (2) (SPN_DATA(I,J),J=1,NANG)
           WRITE (2) (RPA_DATA(I,J),J=1,NDIF)
        END DO
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
	RETURN
	END

	SUBROUTINE SRTRPA_SENTGS(MODBLK,CTS,ICTN,I1,I2,JFLAG)
C
C THIS SUBROUTINE SORTS DATA FOR A GIVEN HEAD AND GIVEN MASS IN
C TERMS OF INSTRUMENT RPA SETTING.
C PART OF THE SENTGS PROGRAM
C
C INPUT ARGUMENTS ARE:
C	MODBLK	SEE SENTGS INPUT SUBROUTINE
C	I1    - START SAMPLE INDEX OF DATA TO BE INCLUDED
C	I2    - STOP SAMPLE INDEX. I1, I2 ARE IN RANGE [1,512]
C OUTPUT ARGUMENTS, IN ADDITION TO CTS, CTN,
C	JFLAG - SET TO 0 IF NO DATA ADDED TO ARRAYS, OTHERWISE 1
C
C THE ARRAYS CTS(NANG) AND ICTN(NANG) ARE UPDATED APPROPRIATELY
C NOTE *** BEFORE THIS ROUTINE IS CALLED, THE INFORMATION IN THE
C FOLLOWING COMMON BLOCKS MUST BE DEFINED
C	COMMON	UPDATED BY CALLING
C	------	------------------
C	RPAMSH	GETMOD.  CONTAINS INSTRUMENT RPA, IMS SETTINGS
C	I7FLGS	DEFFGS.  CONTAINS INSTRUMENT MODE FLAGS.
C
C V1.0 JFE JOHNSON 25 JUL 82
C V1.1 JFEJ        17 AUG 82 ADDED IDCODC CALL
C V1.2 JL GREEN	   14 SEPT 82 ADDED ELECTROMETER CODE
C V2.0 R.L.WEST  BSCC  27-JAN-1986
C                if subroutines call were small enough their calls were
C                eleminated and the code actually brought in, also some
C                logic was rearranged.
C V2.1 R.L.WEST     8 JUL 86 INCORPORATED NEW VERSION OF IDCODC
C
	INTEGER*4 IDCODC
	INTEGER JRPA(512),JMSH(512),MODBLK(8),LKURPA(33)
	INTEGER IDAT(2812),ICDE(512,2),JCR(512,2)
	INTEGER ICTN(32),KCEL(512)
	REAL CTS(32)
	EQUIVALENCE (ICDE(1,1),IDAT(1789))
	EQUIVALENCE (JCR(1,1),IDAT(253))
	EQUIVALENCE (KCEL(1),IDAT(1277))
	COMMON/RPAMSH/JRPA,JMSH
	COMMON/MAF1/IDAT
	DATA LKURPA/  0,   1,   2,   2,   3,   4,   5,
     1                6,   7,   9,  11,  13,  17,  21,  25,
     2               32,  39,  49,  60,  75,  93, 115, 143,
     3              178, 220, 274, 338, 422, 522, 648, 806,1000,
     4              1023/
C
	JFLAG=0
C
C-----------------------------------------------------------------------
C     *** first call REFANG, to define phase angle reference ***
C-----------------------------------------------------------------------
C
	CALL REFANG(DEGSAM,RAMANG)
C
C-----------------------------------------------------------------------
C     *** see which head ***
C-----------------------------------------------------------------------
C
	IF(MODBLK(1).EQ.4)GO TO 1000			! ELECTROMETER
	IF(MODBLK(1).EQ.1)GO TO 601			! RADIAL
C
C-----------------------------------------------------------------------
C     *** Z head processing ***
C-----------------------------------------------------------------------
C
	IDET=(MODBLK(1)-2)*2+MODBLK(2)			! GET DETECTOR
C
	DO 630 I=I1,I2
           IF (JMSH(I) .GE. MODBLK(3)) THEN		! CHAEK MASS
              IF (JMSH(I) .LE. MODBLK(4)) THEN
	         ANG=RAMANG+(I-1)*DEGSAM+720.0		! GET ANGLE
	         ANG=AMOD(ANG,360.0)
	         IANG=ANG
	         IF(IANG.GT.180)IANG=IANG-360
                 IF (IANG .GE. MODBLK(7)) THEN		! CHECK ANGLE
                    IF (IANG .LE. MODBLK(8)) THEN
	               ICH=IGTZMS(IDET,I)		! HAVE DATA ?
	               IF(ICH.LE.0)GO TO 630
	               DO K=1,33			! HAVE DATA ?
	                  KDWN=34-K
	                  IF( LKURPA(KDWN).LE.JRPA(I) )  GO TO 100
	               END DO
  100                  CONTINUE
	               IRP=KDWN
	               IF(IRP.EQ.33)GO TO 630
	               JFLAG=1
                       CTS(IRP)=CTS(IRP)+FLOAT(IDCODC(ICDE(I,ICH),IC))
	               ICTN(IRP)=ICTN(IRP)+IC
	            END IF
	         END IF
	      END IF
           END IF
  630	CONTINUE
C
	GO TO 9000
C
  601	CONTINUE
C
C-----------------------------------------------------------------------
C     *** RADIAL head processing
C-----------------------------------------------------------------------
C
	DO 700 I=I1,I2
           IF (JMSH(I) .GE. MODBLK(3)) THEN		! CHECK MASS
              IF (JMSH(I) .LE. MODBLK(4)) THEN
	         ANG=RAMANG+(I-1)*DEGSAM+720.0		! GET ANGLE
	         ANG=AMOD(ANG,360.0)
	         IANG=ANG
 	         IF(IANG.GT.180)IANG=IANG-360
                 IF (IANG .GE. MODBLK(7)) THEN		! CHACK ANGLE
                    IF (IANG .LE. MODBLK(8)) THEN
	               DO K=1,33			! CHECK ENERGY
	                  KDWN=34-K
	                  IF( LKURPA(KDWN).LE.JRPA(I) )  GO TO 200
	               END DO
  200                  CONTINUE
	               IRP=KDWN
	               IF(IRP.EQ.33)GO TO 700
   	               JFLAG=1
                       CTS(IRP)=CTS(IRP)+
     *                                FLOAT(IDCODC(JCR(I,MODBLK(2)),IC))
	               ICTN(IRP)=ICTN(IRP)+IC
	            END IF
	         END IF
	      END IF
	   END IF
  700	CONTINUE
C
	GO TO 9000
C
 1000	CONTINUE
C
C-----------------------------------------------------------------------
C     *** ELECTROMETER channel ***
C-----------------------------------------------------------------------
C
	DO 2000 I=I1,I2
	   ANG=RAMANG+(I-1)*DEGSAM+720.0		! GET ANGLE
	   ANG=AMOD(ANG,360.0)
	   IANG=ANG
	   IF(IANG.GT.180)IANG=IANG-360
           IF (IANG .GE. MODBLK(7)) THEN		! CHECK ANGLE
              IF (IANG .LE. MODBLK(8)) THEN
	         DO K=1,33				! CHECK ENERGY
  	            KDWN=34-K
	            IF( LKURPA(KDWN).LE.JRPA(I) )  GO TO 300
	         END DO
  300            CONTINUE
	         IRP=KDWN
	         IF(IRP.EQ.33)GO TO 2000
	         JFLAG=1
                 CTS(IRP)=CTS(IRP)+FLOAT(IDCODC(KCEL(I),IC))
	         ICTN(IRP)=ICTN(IRP)+IC
	      END IF
	   END IF
 2000	CONTINUE
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
 9000	CONTINUE
	RETURN
	END
