	SUBROUTINE RBFAVG(BAVG)
C RBFAVG COMPUTES THE AVERAGE OF THE ROTATED B-FIELD COMPONENTS FOR AN
C 8-SECOND MAF1 RECORD
C
C METHOD:  THE B-FIELD COMPONENTS FOR EACH SECOND (1-8) OF A MAF1 RECORD
C	   ARE ROTATED AND A RUNNING SUM IS KEPT FOR EACH COMPONENT WHICH
C	   IS AVERAGED AFTER ALL 8 SECONDS HAVE BEEN SUMMED.
C
C RESTRICTIONS:  MAF1 RECORD MUST BE IN COMMON BLOCK "MAF1" SET UP AS
C		 FOLLOWS -
C		     INTEGER*2 IDATA
C		     COMMON /MAF1/IDATA(2812)
C
C ARGUMENTS:
C	BAVG(1-3)  (REAL,OUTPUT) - AVERAGED ROTATED B-FIELD COMPONENTS
C
	REAL B(3),BROT(3),BAVG(3)
	INTEGER IDAT(2812)
	COMMON/MAF1/IDAT
C
C ZERO OUT B-FIELD AVERAGE COMPONENTS
	DO I=1,3
	  BAVG(I)=0.
	END DO
C
C GET B-FIELD SCALE FACTOR FROM MAF1 RECORD
	BSCALE=IDAT(25)
C
C SET K TO B-FIELD START LOCATION MINUS 1
	K=100
C
C J IS SECOND COUNTER
	DO J=1,8
C
C I IS COMPONENT COUNTER (1=X,2=Y,3=Z)
C B ARRAY IS SET EQUAL TO B-FIELD COMPONENTS
	  DO I=1,3
	    K=K+1
	    B(I)=BSCALE*IDAT(K)
	  END DO
C
C GET SPIN ANGLE AT EACH SECOND [SPANG = RAM * SPINRATE * (J-1)]
	  SPANG=0.1*IDAT(23)+0.01*IDAT(20)*(J-1)
	  IF(SPANG.LT.-180.0)SPANG=SPANG+360.0
	  IF(SPANG.GT. 180.0)SPANG=SPANG-360.0
C
C ROTATE TO FIXED FRAME
	  CALL AXISRT(B,-SPANG,BROT)
C
C SUM ROTATED B-FIELD COMPONENTS
	  DO I=1,3
	    BAVG(I)=BAVG(I)+BROT(I)
	  END DO
	END DO
C END OF SECOND COUNTER LOOP
C
C COMPUTE AVERAGE OF ROTATED B-FIELD COMPONENTS
	DO I=1,3
	  BAVG(I)=BAVG(I)/8.
	END DO
	RETURN
	END
