	SUBROUTINE PITPHA(MINANG)
C
C ROUTINE RETURNS THE SPIN PHASE ANGLE WHERE THE MINIMUM PITCH ANGLE
C IS SAMPLED.
C MINANG IS RETURNED IN RANGE -180 TO +180 DEG.
C
C V1.0 JFE JOHNSON 9 SEP 82
C 23-SEP-86:  MODIFIED BY B. LEE/BCSS TO USE AVERAGE OF ROTATED B-FIELD
C	      COMPONENTS.
C 13-NOV-86:  MODIFIED BY R.L.WEST/BCSS TO CHECK VALUES OF BAVG AND RETURN
C             OLD MINANG IF BAVG ZEROZ
C
	REAL BAVG(3)
C
C GET AVERAGE OF ROTATED B-FIELD COMPONENTS
	CALL RBFAVG(BAVG)
	IF (BAVG(2) .EQ. 0.0  .AND.  BAVG(1) .EQ. 0.0) THEN
	   MINANG=IOLD_MINANG
	   RETURN
	END IF
C
C DETERMINE PHASE ANGLE AT WHICH WE LOOK, WHICH IS PROJECTED ANGLE OF
C ROTATED B FIELD ONTO SPIN PLANE
	RMINAN=ATAN2(BAVG(2),BAVG(1))
	RMINAN=RMINAN*180.0/3.14159
	RMINAN=AMOD(RMINAN+360.0,360.0)
	IF(RMINAN.GT.180.0)RMINAN=RMINAN-360.0
	MINANG=RMINAN
	IOLD_MINANG=MINANG
	RETURN
	END
