      SUBROUTINE ORBOFTR
C
C----------------------------------------------------------------------|
C                                                                      |
C      Determines how often to save the orbit parameters               |
C                                                                      |
C      Written by     R. L. WEST     BCSS      2-DEC-1987              |
C                                                                      |
C      ********************                                            |
C      VARIABLE     MEANING                                            |
C        ***          ***                                              |
C                                                                      |
C      ********************                                            |
C      COMMON       PURPOSE                                            |
C        ***          ***                                              |
C                                                                      |
C      ********************                                            |
C      SUB/FUNC     PURPOSE                                            |
C        ***          ***                                              |
C                                                                      |
C----------------------------------------------------------------------|
C
      INTEGER*2 IN,NDIV
C
      INTEGER*4 FTMS(4),IADD,ID,IDIF,IFIRST(2),IORBOFT,IORBTIME,IORBYD,
     *          IY
C
      REAL*8    FRAME_TIMES(4)
C
      COMMON    /FRATMS/FRAME_TIMES,NDIV,
     *          /ORBIT/IORBOFT,IORBYD,IORBTIME,IN,IFIRST
C
C-----------------------------------------------------------------------
C     *** calculate length of plot in msec ***
C-----------------------------------------------------------------------
C
      FTMS(1)=FRAME_TIMES(1)
      FTMS(2)=FRAME_TIMES(2)/1000.0D0
      FTMS(3)=FRAME_TIMES(3)
      FTMS(4)=FRAME_TIMES(4)/1000.0D0
      CALL TIMDIF (FTMS(1),FTMS(2),FTMS(3),FTMS(4),IDIF)
C
C-----------------------------------------------------------------------
C     *** see how often to save orbit parameters ***
C-----------------------------------------------------------------------
C
      IF (IDIF .LE. 0) THEN
         TYPE '('' ERROR IN START AND STOP TIMES !'')'
         STOP
      ELSE IF (IDIF .LE. 600000) THEN		! 10 MIN
         IORBOFT=60000				! 1 MIN
      ELSE IF (IDIF .LE. 1200000) THEN		! 20 MIN
         IORBOFT=120000				! 2 MIN
      ELSE IF (IDIF .LE. 1800000) THEN		! 30 MIN
         IORBOFT=180000				! 3 MIN
      ELSE IF (IDIF .LE. 2400000) THEN		! 40 MIN
         IORBOFT=240000				! 4 MIN
      ELSE IF (IDIF .LE. 3600000) THEN		! 60 MIN
         IORBOFT=300000				! 5 MIN
      ELSE IF (IDIF .LE. 7200000) THEN		! 2 HR
         IORBOFT=600000				! 10 MIN
      ELSE IF (IDIF .LE. 10800000) THEN		! 3 HR
         IORBOFT=900000				! 15 MIN
      ELSE IF (IDIF .LE. 14400000) THEN		! 4 HR
         IORBOFT=1200000			! 20 MIN
      ELSE IF (IDIF .LE. 18000000) THEN		! 5 HR
         IORBOFT=1800000			! 30 MIN
      ELSE IF (IDIF .LE. 43200000) THEN		! 12 HR
         IORBOFT=3600000			! 1 HR
      ELSE IF (IDIF .LE. 86400000) THEN		! 24 HR
         IORBOFT=7200000			! 2 HR
      ELSE
         IORBOFT=1440000			! 4 HR
      END IF
C
C-----------------------------------------------------------------------
C     *** calculate time of first save ***
C-----------------------------------------------------------------------
C
      IDIF=MOD(FTMS(2),IORBOFT)
      IF (IDIF .GT. 0) THEN
         IADD=IORBOFT-IDIF
      ELSE
         IADD=0
      END IF
      CALL ADDTM2 (FTMS(1),FTMS(2),IADD,IORBYD,IORBTIME)
      IFIRST(1)=IORBYD
      IFIRST(2)=IORBTIME
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      IN=0
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END
