      SUBROUTINE ORB_SAVE
C
C----------------------------------------------------------------------|
C                                                                      |
C      Save the orbit parameters for the time specified.               |
C                                                                      |
C      Written by     R. L. WEST     BCSS      3-DEC-1987              |
C                                                                      |
C      ********************                                            |
C      VARIABLE     MEANING                                            |
C        ***          ***                                              |
C                                                                      |
C      HEADER       ARRAY CONTIANING ORBITAL INFORMATION               |
C      IFIRST       TIME OF THE FIRST SAVED SET OF ORBIT PARAMETERS    |
C      IMS          MILLISECONDS OF DAY OF THIS RECORD                 ;
C      IN           TOTAL NUMBER OF ORBITAL DATA SETS SAVED            |
C      IORBOFT      HOW OFTEN TO SAVE ORBIT DATA, IN MILLISECONDS      |
C      IORBTIME     MILLISECONDS OF DAY OF WHEN TO SAVE NEXT ORBIT SET |
C      IORBYD       YEAR AND DOY OF WHEN TO SAVE NEXT ORBIT SET        |
C      IRECSTOP_MS  END TIME(MILLIS) OF THE RECORD                     |
C      IRECSTRT_MS  START TIME(MILLIS) OF RECORD                       |
C      IRECSTOP_YD  END TIME(YDOY) OF THE RECORD                       |
C      IRECSTRT_YD  START TIME(YDOY) OF RECORD                         |
C      ITIME        YEAR, DOY, AND MILLISECONDS OF DAY OF ORBIT SAVE SET
C      IYD          YEAR AND DOY OF THIS RECORD                        |
C      JDAT         ARRAY CONTAINING ALL THE DATA                      |
C      ORBS         THE ORBIT DATA SAVE SET                            |
C                                                                      |
C      ********************                                            |
C      COMMON       PURPOSE                                            |
C        ***          ***                                              |
C                                                                      |
C      BLKTIM                                                          |
C      MAF1                                                            |
C      ORBDAT                                                          |
C      ORBIT                                                           |
C                                                                      |
C      ********************                                            |
C      SUB/FUNC     PURPOSE                                            |
C        ***          ***                                              |
C                                                                      |
C      ADDTM2                                                          |
C      CMPTM2                                                          |
C                                                                      |
C----------------------------------------------------------------------|
C
      INTEGER*2   HEADER(24),IN,JDAT(2812)
C
      INTEGER*4   IFIRST(2),IFLAG,IMS,IORBOFT,IORBTIME,IORBYD,
     *            IRECSTOP_MS,IRECSTOP_YD,IRECSTRT_MS,IRECSTRT_YD,
     *            ITIME(2,13),IYD
C
      REAL        ORBS(4,13)
C
      EQUIVALENCE (JDAT(1),HEADER(1))
C
      COMMON      /BLKTIM/IYD,IMS,
     *            /MAF1/JDAT,
     *            /ORBDAT/ITIME,ORBS,
     *            /ORBIT/IORBOFT,IORBYD,IORBTIME,IN,IFIRST
C
      DATA        INC/7999/
C
C-----------------------------------------------------------------------
C     *** get the start and stop time of the record ***
C-----------------------------------------------------------------------
C
      IRECSTRT_YD=IYD
      IRECSTRT_MS=IMS
      CALL ADDTM2 (IRECSTRT_YD,IRECSTRT_MS,INC,IRECSTOP_YD,IRECSTOP_MS)
C
C-----------------------------------------------------------------------
C     *** see if record prior to orbit time ***
C-----------------------------------------------------------------------
C
  100 CONTINUE
      CALL CMPTM2 (IRECSTOP_YD,IRECSTOP_MS,IORBYD,IORBTIME,IFLAG)
      IF (IFLAG .LT. 0) THEN          ! record stop prior to orbit time
         RETURN
      ELSE IF (IFLAG .EQ. 0) THEN     ! record stop = orbit time,
         GO TO 1000                   ! save them
      ELSE
C        
C-----------------------------------------------------------------------
C        *** record stop after orbit see if ***
C        *** record start before orbit time ***
C-----------------------------------------------------------------------
C
         CALL CMPTM2 (IRECSTRT_YD,IRECSTRT_MS,IORBYD,IORBTIME,IFLAG)
         IF (IFLAG .GT. 0) THEN     ! record start after orbit time,
            IN=IN+1                 ! so save only the time
            ITIME(1,IN)=IORBYD
            ITIME(2,IN)=IORBTIME
            DO I=1,4
               ORBS(1,IN)=0.0
            END DO
            CALL ADDTM2 (IORBYD,IORBTIME,IORBOFT,IORBYD,IORBTIME)
            GO TO 100     ! get next ^ orbit save time and recompare
         END IF
      END IF
C
C-----------------------------------------------------------------------
C     *** save time for this set ***
C-----------------------------------------------------------------------
C 
 1000 CONTINUE
      IN=IN+1
      ITIME(1,IN)=IORBYD
      ITIME(2,IN)=IORBTIME
C
C-----------------------------------------------------------------------
C     *** save the orbital data for this set ***
C-----------------------------------------------------------------------
C 
C-----------------------------------------------------------------------
C     RADIAL DISTANCE
C-----------------------------------------------------------------------
      R=0.0
      DO I=1,3
         R=R+FLOAT(HEADER(I+8))*FLOAT(HEADER(I+8))*1E-6
      END DO
      ORBS(1,IN)=SQRT(R)
C-----------------------------------------------------------------------
C     L VALUE
C-----------------------------------------------------------------------
      ORBS(2,IN)=FLOAT(HEADER(15))*0.01
C-----------------------------------------------------------------------
C     MAGNETIC LOCAL TIME
C-----------------------------------------------------------------------
      ORBS(3,IN)=FLOAT(HEADER(19))*0.01
C-----------------------------------------------------------------------
C     MAGNETIC LATITUDE
C-----------------------------------------------------------------------
      ORBS(4,IN)=FLOAT(HEADER(17))*0.01
C
C-----------------------------------------------------------------------
C     *** get next orbit save time ***
C-----------------------------------------------------------------------
C
      CALL ADDTM2 (IORBYD,IORBTIME,IORBOFT,IORBYD,IORBTIME)
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END
