	SUBROUTINE MODMSH(IRPA,IMSH)
C
C MODIFY MASS SETTINGS.   THIS ROUTINE COPES WITH 'MASS SLIDE'
C MASS SETTING SEQUENCES, FOR INSTANCE, AS USED FOR THE OXYGEN PEAK.
C IT LOOKS THROUGH THE IRPA SETTINGS, AND DETERMINES THE 'NOMINAL'
C MASS SETTINGS THAT HAVE BEEN USED FOR ZERO RPA, FOR MASS
C SPECIES O+ AND O++, WHERE 'SLIDES' WILL BE APPLIED.
C THESE NOMINAL VALUES THEN REPLACE THE ACTUAL MASS SETTINGS TO
C BE USED IN THE IMS ARRAYS FOR FURTHER SORTING (GNMAF2)
C
C V1.0 JL GREEN/ JFE JOHNSON 29 OCT 81 
C V1.1 JFEJ 26 FEB 82 NOW USES MASTAB ROUTINE
C V1.2 JFEJ  6 OCT 82 INCREASED MASTAB TABLE SIZE
C V1.3 JHWJR 8 JUN 84 ADDED HE+ TO MASS SLIDE CORRECTION
C
	INTEGER IRPA(32),IMSH(32),IMSTAB(2,4)
C                                          *----1=HE+,2=O+,3=O++,4=N+
C                                        *------1=LOWER,2=UPPER
C DEFINE IMSTAB DATA
	CALL MASTAB(IMSTAB)
C
	MSET4=0
	MSET8=0
	MSET16=0
	MSET14=0
C NOTE WE ONLY LOOK AT THE IMS SETTING AT ZERO RPA
	DO 900 I=1,32
	IF(IRPA(I).NE.0)GO TO 900
	IF(IMSH(I).GE.IMSTAB(1,1).AND.IMSH(I).LE.IMSTAB(2,1))MSET4=IMSH(I)
	IF(IMSH(I).GE.IMSTAB(1,2).AND.IMSH(I).LE.IMSTAB(2,2))MSET16=IMSH(I)
	IF(IMSH(I).GE.IMSTAB(1,3).AND.IMSH(I).LE.IMSTAB(2,3))MSET8=IMSH(I)
	IF(IMSH(I).GE.IMSTAB(1,4).AND.IMSH(I).LE.IMSTAB(2,4))MSET14=IMSH(I)
  900	CONTINUE
C
	IF(MSET4+MSET8+MSET16+MSET14.EQ.0)RETURN
C
C NOW UPDATE THE MASS SETTINGS USING FOUND VALUE
C
	DO 1000 I=1,32
	IF(IMSH(I).GE.IMSTAB(1,1).AND.IMSH(I).LE.IMSTAB(2,1))IMSH(I)=MSET4
	IF(IMSH(I).GE.IMSTAB(1,2).AND.IMSH(I).LE.IMSTAB(2,2))IMSH(I)=MSET16
	IF(IMSH(I).GE.IMSTAB(1,3).AND.IMSH(I).LE.IMSTAB(2,3))IMSH(I)=MSET8
	IF(IMSH(I).GE.IMSTAB(1,4).AND.IMSH(I).LE.IMSTAB(2,4))IMSH(I)=MSET14
 1000	CONTINUE
	RETURN
	END
