      SUBROUTINE MASTXT(IM1,IM2,ILOHI,TXTLM,TXTHM)
C
C ROUTINE RETURNS TEXT STRINGS CORRESPONDING TO THE MASS SPECIES
C WHICH ARE DETECTED IN LOW MASS DET (TXTLM) AND HIGH MASS
C DETECTOR (TXTHM) WITH MASS SETTING RANGE OF IM1 TO IM2.
C
C IF EITHER OF IM1, IM2 IS OUTSIDE THE NOMINAL RANGE
C BOTH TXTLM AND TXTHM ARE SET TO '????'.
C
C V1.0 JFEJOHNSON  3 FEB 82
C V1.1            18 FEB 82 USES MASTAB ROUTINE
C V1.2 JFEJ        6 OCT 82 INCREASED MASTAB ARRAY SIZE
C
C *NOTE* ORDER OF ELEMENTS IN MASS ARRAY MUST MATCH TEXT IN TXTL/TXTH
C
      BYTE TXTLM(4),TXTHM(4),QUEST
      BYTE TXTL(4,4),TXTH(4,4)
      INTEGER MASS(2,4)
      DATA QUEST/'?'/
      DATA TXTL/'H','+',' ',' ', 'H','E','+',' ', 'H','E','+','+',
     1 '3','.','5',' '/
      DATA TXTH/'H','E','+',' ', 'O','+',' ',' ', 'O','+','+',' ',
     1 'N','+',' ',' '/
C
      CALL MASTAB(MASS)
      ILOHI=2
      IF(IM1.LT.0.AND.IM2.LT.0)ILOHI=1
      JM1=IM1
      JM2=IM2
      IF(ILOHI.EQ.1)JM1=-JM1/4
      IF(ILOHI.EQ.1)JM2=-JM2/4
      JM1=MIN0(JM1,JM2)
      JM2=MAX0(JM1,JM2)
      DO IM=1,4
         IF (JM1.GE.MASS(1,IM) .AND. JM2.LE.MASS(2,IM)) GO TO 30
      END DO
C
C NOT IN RANGE, SO PUT IN ????
C
      DO I=1,4
         TXTLM(I)=QUEST
         TXTHM(I)=QUEST
      END DO
      RETURN
C
C IN RANGE SO SUPPLY TEXT
C
   30 DO I=1,4
         TXTLM(I)=TXTL(I,IM)
         TXTHM(I)=TXTH(I,IM)
      END DO
      RETURN
      END
