      SUBROUTINE LMSTSTR (KODE)
C
C-----------------------------------------------------------------------
C
C     Checks to see if any of the current record is within the current
C     subperiod time limits.
C
C     KODE = -1, all of record prior to subperiod start time
C          =  0, some of record within subperiod time limits
C          =  1, all of record after subperiod stop time
C
C     Written by     R. L. WEST     BCSS      6-APR-1989
C
C-----------------------------------------------------------------------
C     Modification of the original LMSTST written by JFE JOHNSON.
C-----------------------------------------------------------------------
C
      INTEGER*4 IFLAG,IT,IY,IYD
C
      REAL*8    DE,INC,RTE,RTS,RYDE,RYDS,STRIP_TIMES(4),YE
C
      COMMON    /BLKTIM/IYD,IT
     *          /COMLIM/STRIP_TIMES
C
      DATA      INC/7984375.0D0/,     ! 8000000.0D0-15625.0D0
     *          OFFSET_WORD4/7464.84390D0/
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      KODE=0
C
C-----------------------------------------------------------------------
C     *** get start and stop time of current record ***
C-----------------------------------------------------------------------
C
      RYDS=IYD
      RTS=FLOAT(IT)*1000.0D0-OFFSET_WORD4
      CALL ADDTM2R (RYDS,RTS,INC,RYDE,RTE)
C
C-----------------------------------------------------------------------
C     *** see if record end time prior to subperiod start time
C-----------------------------------------------------------------------
C
      CALL CMPTM2R (RYDE,RTE,STRIP_TIMES(1),STRIP_TIMES(2),IFLAG)
      IF (IFLAG .EQ. -1) THEN
         KODE=-1
         RETURN
      END IF
C
C-----------------------------------------------------------------------
C     *** see if record start time after subperiod stop time ***
C-----------------------------------------------------------------------
C
      CALL CMPTM2R (RYDS,RTS,STRIP_TIMES(3),STRIP_TIMES(4),IFLAG)
      IF (IFLAG .EQ. 1) THEN
         KODE=1
         RETURN
      END IF
C
C-----------------------------------------------------------------------
C     *** some of the record is within subperiod time limits ***
C-----------------------------------------------------------------------
C
      KODE=0
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END
