      SUBROUTINE LMSTSSR (KODE,IS,IE)
C
C-----------------------------------------------------------------------
C
C     Checks to see if any of the record is within the strip time limits
C     , if it is returns the start and stop sample numbers.
C
C     Return KODE = -1, all of record prior to start time
C                 =  0, some of record within limits
C                 =  1, all of record after stop time
C
C     Written by     R. L. WEST     BCSS      6-APR-1989
C
C-----------------------------------------------------------------------
C     Modification of the original LMSTSS written by JFE JOHNSON.
C-----------------------------------------------------------------------
C
C      NSAMP is the number of data samples in a record
C      F is the number of samples/millisecond
C
C-----------------------------------------------------------------------
C
      REAL*8    STRIP_TIMES(4),REC_YD,REC_T,IDMS
C
      INTEGER*4 IYD,IT,IFLAG,ME,MS
C
      COMMON    /BLKTIM/IYD,IT
      COMMON    /COMLIM/STRIP_TIMES
C
      DATA F,NSAMP/0.064,512/
C
C-----------------------------------------------------------------------
C     *** see if any of this record is within the strip time limits ***
C-----------------------------------------------------------------------
C
      IS=0
      IE=0
      CALL LMSTSTR (KODE)
      IF (KODE .NE. 0) RETURN     ! none of it is
C
C-----------------------------------------------------------------------
C     *** find the first sample within ***
C-----------------------------------------------------------------------
C
      IS=1
      REC_YD=IYD
      REC_T=FLOAT(IT)*1000.0D0
      CALL DIFTMSR (STRIP_TIMES(1),STRIP_TIMES(2),REC_YD,REC_T,IFLAG,
     *              IDMS)
      IF (IFLAG .EQ. 0) THEN
         MS=1.0D0+(IDMS/1000.0D0)*F
         IF (MS .GT. 0) IS=MS
         IF (MS .LT. 1) IS=1
      END IF
C
C-----------------------------------------------------------------------
C     *** find the last sample within ***
C-----------------------------------------------------------------------
C
      IE=NSAMP
      CALL DIFTMSR (STRIP_TIMES(3),STRIP_TIMES(4),REC_YD,REC_T,IFLAG,
     *              IDMS)
      IF (IFLAG .EQ. 0) THEN
         ME=1.0D0+(IDMS/1000.0D0)*F
         IF (ME .LE. NSAMP) IE=ME
         IF (ME. GT. NSAMP) IE=NSAMP
      END IF
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END
