      SUBROUTINE LMSSETR (KODE)
C
C-----------------------------------------------------------------------
C
C     Prompts for the run start and stop times and inilializes the strip
C     times.
C
C     Return KODE = -1, end of file in input
C                 =  0, successful input
C
C     Written by     R. L. WEST     BCSS      6-APR-1989
C
C-----------------------------------------------------------------------
C     Modification of the original LMSSET written by JFE JOHNSON.
C-----------------------------------------------------------------------
C
      INTEGER*2 IH,IM,IS,KODE
C
      INTEGER*4 HHMMSS,IFLAG
C
      REAL*8    DUR,FRAME_TIMES(4),ILIMS(8),INC,NDIV,RUN_TIMES(4),
     *          STRIP_TIMES(4)
C
      COMMON    /COMLIM/STRIP_TIMES,
     *          /COMTMS/RUN_TIMES,INC,DUR,
     *          /DELUNS/LUNDAT,LUNIN,LUNOUT,
     *          /FRATMS/FRAME_TIMES,NDIV
C
C-----------------------------------------------------------------------
C     *** prompt for run start and stop times
C-----------------------------------------------------------------------
C
    1 CONTINUE
      KODE=0
    5 WRITE (LUNOUT,10)
   10 FORMAT (' START YR,DN,HHMMSS,MILLISEC STOP YR,DN,HHMMSS,MILLISEC')
      READ (LUNIN,*,END=99) ILIMS
C
C-----------------------------------------------------------------------
C     *** see if stop year and day same as start year and day ***
C-----------------------------------------------------------------------
C
      IF (ILIMS(5) .EQ. 0) ILIMS(5)=ILIMS(1)
      IF (ILIMS(6) .EQ. 0) ILIMS(6)=ILIMS(2)
C
C-----------------------------------------------------------------------
C     *** convert start YY,DDD to YDDD ***
C-----------------------------------------------------------------------
C
      ILIMS(1)=ILIMS(1)-80.0D0
      ILIMS(1)=ILIMS(1)*1000.0D0+ILIMS(2)
      RUN_TIMES(1)=ILIMS(1)
C
C-----------------------------------------------------------------------
C     *** convert start HHMMSS,MSEC to microseconds ***
C-----------------------------------------------------------------------
C
      HHMMSS=ILIMS(3)
      CALL THMS(HHMMSS,IH,IM,IS)
      ILIMS(2)=IH
      ILIMS(2)=1000000.0D0*(ILIMS(2)*3600.0D0+IM*60.0D0+IS)
      RUN_TIMES(2)=ILIMS(2)+ILIMS(4)*1000.0D0
C
C-----------------------------------------------------------------------
C     *** convert stop YY,DDD to YDDD
C-----------------------------------------------------------------------
C
      ILIMS(3)=ILIMS(5)-80.0D0
      ILIMS(3)=ILIMS(3)*1000.0D0+ILIMS(6)
      RUN_TIMES(3)=ILIMS(3)
C
C-----------------------------------------------------------------------
C     *** convert stop HHMMSS,MILLISEC to microseconds ***
C-----------------------------------------------------------------------
C
      HHMMSS=ILIMS(7)
      CALL THMS(HHMMSS,IH,IM,IS)
      ILIMS(4)=IH
      ILIMS(4)=1000000.0D0*(ILIMS(4)*3600.0D0+IM*60.0D0+IS)
      RUN_TIMES(4)=ILIMS(4)+ILIMS(8)*1000.0D0
C
C-----------------------------------------------------------------------
C     *** check to make certain start time is prior to stop time ***
C-----------------------------------------------------------------------
C
      CALL CMPTM2R (RUN_TIMES(1),RUN_TIMES(2),RUN_TIMES(3),RUN_TIMES(4),
     *              IFLAG)
      IF (IFLAG .GE. 0) THEN
         WRITE (LUNTOUT,'('' START TIME IS NOT PRIOR TO STOP TIME, ''
     *                     ''REENTER.'')')
         GO TO 1
      END IF
C
C-----------------------------------------------------------------------
C     *** initialize strip time limits to run time limits ***
C-----------------------------------------------------------------------
C
      DO I=1,4
         STRIP_TIMES(I)=RUN_TIMES(I)
         FRAME_TIMES(I)=RUN_TIMES(I)
      END DO
      INC=0.0D0
      DUR=0.0D0
      NDIV=0.0D0
      RETURN
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
   99 KODE=-1
      RETURN
      END
