      SUBROUTINE LMSNXTR (KODE)
C
C-----------------------------------------------------------------------
C
C     Updates the new current subperiod time limits
C
C     Return KODE = 1, subperiods not defined, or done with frame
C                   0, update successful
C
C     Written by     R. L. WEST     BCSS      6-APR-1989
C
C-----------------------------------------------------------------------
C     Modification of the original LMSNXT written by JFE JOHNSON.
C-----------------------------------------------------------------------
C
      INTEGER*2 KODE
C
      INTEGER*4 IFLAG
C
      REAL*8    DUR,FRAME_TIMES(4),INC,ITSAV,IYDSAV,RUN_TIMES(4),
     *          STRIP_TIMES(4)
C
      COMMON    /COMLIM/STRIP_TIMES,
     *          /COMTMS/RUN_TIMES,INC,DUR,
     *          /FRATMS/FRAME_TIMES
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      KODE=1
C
C-----------------------------------------------------------------------
C     *** check to see if subperiods have been defined  ***
C-----------------------------------------------------------------------
C
      IF (INC .LE. 0  .AND.  IDUR .LE. 0) RETURN
C
C-----------------------------------------------------------------------
C     *** see if current subperiod last one in frame ***
C-----------------------------------------------------------------------
C
      CALL CMPTM2R (STRIP_TIMES(3),STRIP_TIMES(4),
     *              FRAME_TIMES(3),FRAME_TIMES(4),IFLAG)
      IF (IFLAG .GE. 0) RETURN
C
C-----------------------------------------------------------------------
C     *** calculate new subperiods time limite ***
C-----------------------------------------------------------------------
C
      KODE=0
      IYDSAV=STRIP_TIMES(1)
      ITSAV=STRIP_TIMES(2)
      CALL ADDTM2R (IYDSAV,ITSAV,INC,STRIP_TIMES(1),STRIP_TIMES(2))
      CALL ADDTM2R (STRIP_TIMES(1),STRIP_TIMES(2),DUR,STRIP_TIMES(3),
     *               STRIP_TIMES(4))
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END
