      PROGRAM IMSTGS
C
C-----------------------------------------------------------------------
C                                                                      |
C      IMSTGS.FTN --- MASS TIME SPECTROGRAM PROGRAM, RUNNING OFF       |
C                      MAF1 FORMAT DATA.                               |
C----------------------------------------------------------------------|
C      V5.0                                                            |
C      MODIFIED BY     R.L.WEST     BCSS            7-JUN-1990         |
C               Modified to improve internal documemtation             |
C               Eliminated all plotting code and modified to output data
C                  to file instead                                     |
C               Modified to utilize FRASETR,DEFFRAR,ORBOFTR,ORB_SAVE   |
C----------------------------------------------------------------------|
C      V4.3                                                            |
C      MODIFIED BY     R.L.WEST     BCSS            2-FEB-1989         |
C               ADDED THE CODE NECESSARY TO UTILIZE THE AED            |
C----------------------------------------------------------------------|
C      V4.2                                                            |
C      MODIFIED BY     R.L.WEST     BCSS           10-MAR-1988         |
C               ELIMINATED THE EXTRA CALL TO GETMF1 ON THE SECOND AND  |
C               SUBSEQUENT PLOTS (IFIRST1)                             |
C----------------------------------------------------------------------|
C      V4.1                                                            |
C      MODIFIED BY     R.L.WEST     INTERGRAPH      6-DEC-1984         |
C               REMOVED 'NDIV=180' AND INSERTED A CALL TO RESLTN       |
C                                                                      |
C               CHANGED WHERE TO GO WHEN THE KODE RETURNED BY LMSTSS   |
C                  IS GREATER THAN 1                                   |
C----------------------------------------------------------------------|
C                                                                      |
C  V4.0  R.L.WEST  INTERGRAPH  6-JULY-84                               |
C        ADDED CTRSET (SELECTABLE CONTOUR TABLE)                       |
C        ADDED SELECTABLE ANGLE RANGE                                  |
C        MODIFIED GRID TO BE COMPATABLE WITH OTHERS                    |
C        USED ORBPL1 INSTEAD OF ORBPLT                                 |
C                                                                      |
C  V3.1  RCO  22-JULY-82 MINOR CHANGES TO HANDLE TOGGLE DATA           |
C                                                                      |
C  V3.0  RCO  31-MAR-82  FLIP HI/LO MASS PLOTS                         |
C                                                                      |
C V2.0 RCO LOTS OF CHANGES, EXPMD1 FOR CORRECT MASSES,                 |
C      CHANGES IN Y AXES                                               |
C      ONLY 6 CALLS TO ORBPLT, MASS DATA OVER LKUIMS(32) REJECTED,ETC. |
C      26-FEB-82                                                       |
C                                                                      |
C V1.0       RCO      4 FEB 82 ADAPTED FROM RPATGS,                    |
C      ( V1.3 JFEJ 20 DEC 81 )                                         |
C                                                                      |
C-----------------------------------------------------------------------
C
      LOGICAL   IFIRST1
C
      INTEGER*2 CTN(32,2),IAT(8),IAZ(8),ICAL(8),ICDE(512,2),IDAT(2812),
     *          IFXS(8),IIT(8),IIZ(8),IMDF(8),IMSF(8),IMSH(32,2,8),INUM,
     *          IRPA(32,2,8),IRPAC(8),IRPF(8),ITR(8),IW7(16,8),
     *          IZMS(512),JCR(512,2),JMS(32),JMSH(512),JRPA(512),
     *          LKUIMS(2,32),MODBLK(8),NDIV

C
      INTEGER*4 IDTMS,IDTYD,IFIRST(2),IFLAG,IORBOFT,IORBTIME,IORBYD,
     *          ITIME(2,13)
C
      REAL      CTS(32,2),CTS_STORE(360,32,2)
C
      REAL*8    DUR,IMS,INC,ORBS(4,13),FRAME_TIMES(4),RUN_TIMES(4),
     *          STRIP_TIMES(4),TIME_STORE(360,2)
C
      COMMON    /BLKTIM/IDTYD,IDTMS,
     *          /COMLIM/STRIP_TIMES,
     *          /COMTMS/RUN_TIMES,INC,DUR,
     *          /FRATMS/FRAME_TIMES,NDIV,
     *          /MAF1/IDAT,
     *          /ORBDAT/ITIME,ORBS,
     *          /ORBIT/IORBOFT,IORBYD,IORBTIME,INUM,IFIRST,
     *          /SCALE/LKUIMS
C
      EQUIVALENCE (IDAT(125),IW7(1,1)),
     *            (IDAT(253),JCR(1)),
     *            (IDAT(1789),ICDE(1,1)),
     *            (IMSH(1,1,1),JMSH(1)),
     *            (IRPA(1,1,1),JRPA(1))
C
      DATA      IFIRST1/.TRUE./
C
C-----------------------------------------------------------------------
C     *** initialization ***
C-----------------------------------------------------------------------
C
      LIN=1
      LUNTI=5
      LUNTO=6
      CALL DELUNS(LIN,LUNTI,LUNTO)
      WRITE(LUNTO,1001)
 1001 FORMAT('IMSTGS V5.0')
      CALL DEOPEN
C
C-----------------------------------------------------------------------
C     *** this is the top of the logic loop ***
C-----------------------------------------------------------------------
C
  100 CONTINUE
C
C-----------------------------------------------------------------------
C     *** get run time limits ***
C-----------------------------------------------------------------------
C
  110 CALL LMSSETR (KODE)
      IF (KODE .EQ. -1) GO TO 9999
C
C-----------------------------------------------------------------------
C     *** get the increment, duration  ***
C     *** and define initial subperiod ***
C-----------------------------------------------------------------------
C
      CALL FRASETR (KODE)
C
C-----------------------------------------------------------------------
C     *** prompt for the head ***
C-----------------------------------------------------------------------
C
      CALL HEDSET (IHEAD)
      MODBLK(1)=IHEAD
C
C-----------------------------------------------------------------------
C      *** get angle range ***
C-----------------------------------------------------------------------
C
      CALL ANGSET (MODBLK(7),MODBLK(8))
C
C-----------------------------------------------------------------------
C     *** display current frame times ***
C-----------------------------------------------------------------------
C
  200 CONTINUE
      CALL FRAOPTR (LUNTO)
C
C-----------------------------------------------------------------------
C      *** see how often to save orbit parameters ***
C-----------------------------------------------------------------------
C
      CALL ORBOFTR
C
C-----------------------------------------------------------------------
C     *** initialize orbit arrays for current frame ***
C-----------------------------------------------------------------------
C
      INUM=0
      DO I=1,13
         ITIME(1,I)=0
         ITIME(2,I)=0
         DO J=1,4
            ORBS(J,I)=0.0
         END DO
      END DO
C
C-----------------------------------------------------------------------
C     *** read first record ***
C-----------------------------------------------------------------------
C
      IF (IFIRST1) THEN
         CALL GETMF1 (KODE)
         IF (KODE. EQ. -10) GO TO 999
         IFIRST1=.FALSE.
      END IF
C
C-----------------------------------------------------------------------
C     *** start collecting the data ***
C-----------------------------------------------------------------------
C
      DO 900 IDIV=1,NDIV
C
C-----------------------------------------------------------------------
C        *** display current subperiod times ***
C-----------------------------------------------------------------------
C
         CALL SUBOPTR (LUNTO)
         TIME_STORE(IDIV,1)=STRIP_TIMES(2)/1.0D6
         TIME_STORE(IDIV,2)=STRIP_TIMES(4)/1.0D6
C
C-----------------------------------------------------------------------
C        *** initialize working arrays ***
C-----------------------------------------------------------------------
C
         DO I=1,32
            CTS(I,1)=0.0
            CTN(I,1)=0
            CTN(I,2)=0
            CTS(I,2)=0.0
         END DO
C
C-----------------------------------------------------------------------
C        *** see if record is within time limits ***
C-----------------------------------------------------------------------
C
  240    CALL LMSTSSR (KODE,I1,I2)
         IF (KODE) 245,250,610
C
C-----------------------------------------------------------------------
C        *** get next record ***
C-----------------------------------------------------------------------
C
  245    CALL GETMF1 (KODE)
         IF (KODE .EQ. -10) THEN
            GO TO 999
         ELSE IF (KODE .EQ. -1) THEN            ! end of tape
            GO TO 910
         ELSE
            GO TO 240
         END IF
C
C-----------------------------------------------------------------------
C        *** this record in current time limits so process ***
C-----------------------------------------------------------------------
C
  250    CONTINUE
C
C-----------------------------------------------------------------------
C        *** see if time to save orbit parameters ***
C-----------------------------------------------------------------------
C
         CALL ORB_SAVE
C
C-----------------------------------------------------------------------
C        *** get the spin rate and the RAM reference angle ***
C-----------------------------------------------------------------------
C
         CALL REFANG (DEGSAM,RAMANG)
C
C-----------------------------------------------------------------------
C        *** get all the word 7 flags needed ***
C-----------------------------------------------------------------------
C
         CALL W7FLGS (IW7,IMDF,ITR,IIT,IIZ,ICAL,IFXS,IRPAC,IAT,IAZ,IMSF,
     *                                                             IRPF)
C
C-----------------------------------------------------------------------
C        *** see if in toggle mode ***
C-----------------------------------------------------------------------
C
         IF (IMSF(1) .EQ. 1) GO TO 245
C
C-----------------------------------------------------------------------
C        *** get flags and instrument modes ***
C-----------------------------------------------------------------------
C
         DO IR=1,8
            DO IT=1,2
               CALL EXPMD1 (IMDF(IR),ICAL(IR),IMSF(IR),IRPF(IR),
     *                            IRPAC(IR),IRPA(1,IT,IR),IMSH(1,IT,IR))
               CALL SCLIM2 (IMSH(1,IT,IR),IBAD)
               IF (IBAD .EQ. 1) GO TO 245
               CALL SCLIMS (IMSH(1,IT,IR))
               CALL SCLRPA (IRPA(1,IT,IR))
            END DO
         END DO
C
C-----------------------------------------------------------------------
C        *** check the head to be processed ***
C-----------------------------------------------------------------------
C
         IF (IHEAD .EQ. 1) GO TO 401
C
C-----------------------------------------------------------------------
C        *** Z head processing ***
C-----------------------------------------------------------------------
C
         DO 410 ILH=1,2
C
            IDET=(IHEAD-2)*2+ILH
            CALL DEFZMS(IIZ,IAZ,ITR,IDET,IZMS)
C
            DO 430 I=I1,I2
C
C-----------------------------------------------------------------------
C              *** make certain RPA is valid ***
C-----------------------------------------------------------------------
C
               IF (JRPA(I) .LT. 1) GO TO 430
C
C-----------------------------------------------------------------------
C              *** make certain MASS is valid and define MASS bin ***
C-----------------------------------------------------------------------
C
               IF (JMSH(I) .LT. 1) GO TO 430
C
C-----------------------------------------------------------------------
C              *** make certain proper head/channel combination ***
C-----------------------------------------------------------------------
C
               IF (IZMS(I) .LE. 0) GO TO 430
C
C-----------------------------------------------------------------------
C              *** make certain in angle range ***
C-----------------------------------------------------------------------
C
               IANG=ISANGL(DEGSAM,RAMANG,I)
               IF (IANG.LT.MODBLK(7) .OR. IANG.GT.MODBLK(8)) GO TO 430
C
C-----------------------------------------------------------------------
C              *** sum the data ***
C-----------------------------------------------------------------------
C
               CTS(JMSH(I),ILH)=CTS(JMSH(I),ILH)+
     *                                        IDCODC(ICDE(I,IZMS(I)),IC)
               CTN(JMSH(I),ILH)=CTN(JMSH(I),ILH)+IC
C
  430      CONTINUE
  410    CONTINUE
C
C-----------------------------------------------------------------------
C        *** done with this record ***
C-----------------------------------------------------------------------
C
         GO TO 600
C
C-----------------------------------------------------------------------
C        *** RADIAL head processing ***
C-----------------------------------------------------------------------
C
  401    CONTINUE
C
         DO 500 I=I1,I2
C
C-----------------------------------------------------------------------
C              *** make certain RPA is valid ***
C-----------------------------------------------------------------------
C
            IF (JRPA(I) .LT. 1) GO TO 500
C
C-----------------------------------------------------------------------
C              *** make certain MASS is valid and define MASS bin ***
C-----------------------------------------------------------------------
C
            IF (JMSH(I) .LT. 1) GO TO 500
C
C-----------------------------------------------------------------------
C              *** make certain in angle range ***
C-----------------------------------------------------------------------
C
            IANG=ISANGL(DEGSAM,RAMANG,I)
            IF (IANG.LT.MODBLK(7) .OR. IANG.GT.MODBLK(8)) GO TO 500
C
C-----------------------------------------------------------------------
C              *** collect the data ***
C-----------------------------------------------------------------------
C
            DO ILH=1,2
               CTS(JMSH(I),ILH)=CTS(JMSH(I),ILH)+IDCODC(JCR(I,ILH),IC)
               CTN(JMSH(I),ILH)=CTN(JMSH(I),ILH)+IC
            END DO

  500    CONTINUE
C
C-----------------------------------------------------------------------
C        *** done with this record ***
C-----------------------------------------------------------------------
C
  600    CONTINUE
C
C-----------------------------------------------------------------------
C        *** see if need to get next record ***
C-----------------------------------------------------------------------
C
         IF (I2 .EQ. 512) GO TO 245
C
C-----------------------------------------------------------------------
C        *** done with this subperiod, average data ***
C-----------------------------------------------------------------------
C
  610    CONTINUE
         DO ILH=1,2
            DO I=1,32
               IF (CTN(I,ILH) .GT. 0) THEN
                  CTS(I,ILH)=CTS(I,ILH)/FLOAT(CTN(I,ILH))
               ELSE
                  CTS(I,ILH)=-1.0
               END IF
            END DO
         END DO
C
C-----------------------------------------------------------------------
C        *** store the data for this subperiod ***
C-----------------------------------------------------------------------
C
         DO ILH=1,2
            DO I=1,32
               CTS_STORE(IDIV,I,ILH)=CTS(I,ILH)
            END DO
         END DO
C
C-----------------------------------------------------------------------
C        *** get next subperiod time limits ***
C-----------------------------------------------------------------------
C
         CALL LMSNXTR (KODE)
         IF (KODE .NE. 0) GO TO 999
  900 CONTINUE                  !THIS IS THE END OF THE NDIV LOOP
C
C-----------------------------------------------------------------------
C     *** end of frame, so output data ***
C-----------------------------------------------------------------------
C
  999 CONTINUE
      CALL PLTNEW_IMSTGS (MODBLK)
      WRITE (2,'(1X,16I4)') (LKUIMS(1,I),I=1,16)
      WRITE (2,'(1X,16I4)') (LKUIMS(1,I),I=17,32)
      WRITE (2,'(1X,16I4)') (LKUIMS(2,I),I=1,16)
      WRITE (2,'(1X,16I4)') (LKUIMS(2,I),I=17,32)
      WRITE (2,'(1X,I4)') NDIV
      DO I=1,NDIV
         WRITE (2,'(1X,2F15.6)') TIME_STORE(I,1),TIME_STORE(I,2)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,1),J=1,4)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,1),J=5,8)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,1),J=9,12)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,1),J=13,16)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,1),J=17,20)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,1),J=21,24)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,1),J=25,28)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,1),J=29,32)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,2),J=1,4)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,2),J=5,8)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,2),J=9,12)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,2),J=13,16)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,2),J=17,20)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,2),J=21,24)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,2),J=25,28)
         WRITE (2,'(1X,4F12.3)') (CTS_STORE(I,J,2),J=29,32)
      END DO
C
C-----------------------------------------------------------------------
C     *** end of run, so output data ***
C-----------------------------------------------------------------------
C
      WRITE (LUNTO,'('' NO MORE SUBPERIODS'')')
      CALL DEFFRAR (KODE)
      IF (KODE .NE. 0) THEN
         WRITE (LUNTO,'('' NO MORE FRAMES'')')
         CALL REWDED
         GO TO 9400
      END IF
      GO TO 200
C
C-----------------------------------------------------------------------
C     *** see if want to process more data ***
C-----------------------------------------------------------------------
C
 9400 CONTINUE
      WRITE (LUNTO,9500)
 9500 FORMAT ($,' DO YOU WANT TO CONTINUE WITH THIS DATA (Y/N)?')
      READ (LUNTI,9600) IANS
 9600 FORMAT(A1)
      IF (IANS .EQ. 'N'  .OR. IANS .EQ. 'n') GO TO 9700
      GO TO 100
 9700 CONTINUE
      CALL EXIT
      STOP
C
C-----------------------------------------------------------------------
C      *** end of tape logic ***
C-----------------------------------------------------------------------
C
  910 WRITE (LUNTO,920)
  920 FORMAT (' END OF TAPE')
 9999 CONTINUE
      CALL DECLOS
      STOP
      END

      SUBROUTINE PLTNEW_IMSTGS (MODBLK)
C
C-----------------------------------------------------------------------
C
C ROUTINE OUTPUTS THE HEADER AND ORBIT INFORMATION
C PART OF THE IMSTGS PROGRAM
C
C  JFE JOHNSON 3 NOV 81
C
C-----------------------------------------------------------------------
C
      BYTE      BUF(52)
C
      INTEGER*2 HEAD(3),INUM,MODBLK(8)
C
      INTEGER*4 IFIRST(2),IORBOFT,IORBTIME,IORBYD,ITIME(2,13),ITMS,MNA
C
      REAL      ORBS(4,13)
C
      REAL*8    RUN_TIMES(4),INC,DUR
C
      COMMON    /COMTMS/RUN_TIMES,INC,DUR,
     *          /ORBDAT/ITIME,ORBS,
     *          /ORBIT/IORBOFT,IORBYD,IORBTIME,INUM,IFIRST
C
      DATA      HEAD/'RL','+Z','-Z'/
C
C-----------------------------------------------------------------------
C     *** OUTPUT TIME, LINE 1 ***
C-----------------------------------------------------------------------
C
      ITMS=RUN_TIMES(2)/1000.0D0
      CALL MSHMSM (ITMS,IHR,IMN,ISC,MS)
      ITMS=RUN_TIMES(4)/1000.0D0
      CALL MSHMSM (ITMS,JHR,JMN,JSC,MS)
      IYR=RUN_TIMES(1)/1000.0D0
      IDN=MOD(RUN_TIMES(1),1000.0D0)
      IYR=IYR+80
      CALL DNDT (IYR,IDN,MN,IDY,MNA)
      ENCODE (59,100,BUF) IYR,IDN,IDY,MNA,IHR,IMN,ISC,JHR,JMN,JSC
100   FORMAT (' DE RIMS M-T SUMMARY (V5.0) ',I2,'/',2I3,'-',A3,I3.2,
     *                                 2(':',I2.2),'-',I2.2,2(':',I2.2))
      WRITE (2,'(59A1)') (BUF(I),I=1,59)
C
C-----------------------------------------------------------------------
C     *** OUTPUT HEAD AND ANGLE RANGE, LINE 2 ***
C-----------------------------------------------------------------------
C
      ENCODE (26,120,BUF) HEAD(MODBLK(1)),MODBLK(7),MODBLK(8)
  120 FORMAT (' HEAD-',A2,' ANG: ',I4,' TO ',I4)
      WRITE (2,'(26A1)') (BUF(I),I=1,26)
C
C-----------------------------------------------------------------------
C     *** output the orbit information ***
C-----------------------------------------------------------------------
C
      WRITE (2,'(I3)') INUM
      DO I=1,INUM
         CALL MSHMSM (ITIME(2,I),IHR,IMN,ISC,MS)
         WRITE (2,'(1X,2I2.2,'':'',I2.2,''.'',I3.3,4F8.2)')
     *                                  IHR,IMN,ISC,MS,(ORBS(J,I),J=1,4)
      END DO
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END
