      INTEGER*4  FUNCTION IDCODC(IDATA,IFLAG)
C
C IDCODC DECOMPRESSES DATA THAT HAS BEEN LOGARITHMICALLY
C COMPRESSED (OR CODED) BY CODECR.  SEE CODECR FOR MORE INFO.
C
C DEFINITION OF ARGUMENTS:
C IDATA - COMPRESSED (CODED) DATA.
C IFLAG - FLAG INDICATING WHETHER DATA IS VALID (IFLAG=1) OR
C         FILL (IFLAG=0).  IDCODC RETURNS A ZERO VALUE IF DATA
C         IS FILL, I.E. EQUAL TO -1.  COUNT SUMMATION CAN BE DONE
C         AS FOLLOWS:
C
C                   CTS=CTS+IDCODC(IDATA,IC)
C                   CTN=CTN+IC
C
C WRITTEN BY BARRY LEE 10/30/81
C
      IF (IDATA .GT. 7128) THEN
         IFLAG=1
         F=IDATA
         IDCODC=10.**(6.092796E-5*F+3.418674)
      ELSE
         IF(IDATA.LT.0)THEN
           IFLAG=0
           IDCODC=0
         ELSE
           IFLAG=1
           IDCODC=IDATA
         END IF
      END IF
      RETURN
      END
