      SUBROUTINE FRAOPTR (LUN)
C
C-----------------------------------------------------------------------
C
C     Writes the current frame start and stop times to the unit number
C     specified.
C
C     Written by     R. L. WEST     BCSS      6-APR-1989
C
C-----------------------------------------------------------------------
C
      INTEGER*2 LUN,NDIV
C
      INTEGER*4 FLIMS(4)
C
      REAL*8    FRAME_TIMES(4)
C
      COMMON    /FRATMS/FRAME_TIMES,NDIV
C
C-----------------------------------------------------------------------
C     *** convert from REAL*8 to INTEGER*4 ***
C-----------------------------------------------------------------------
C
      FLIMS(1)=FRAME_TIMES(1)
      FLIMS(2)=FRAME_TIMES(2)/1000.0D0
      FLIMS(3)=FRAME_TIMES(3)
      FLIMS(4)=FRAME_TIMES(4)/1000.0D0
C
C-----------------------------------------------------------------------
C     *** convert from milliseconds to hours,minutes,seconds,millis ***
C-----------------------------------------------------------------------
C
      CALL MSHMSM (FLIMS(2),IH,IM,IS,MS)
      CALL MSHMSM (FLIMS(4),JH,JM,JS,MS)
C
C-----------------------------------------------------------------------
C     *** output the time ***
C-----------------------------------------------------------------------
C
      WRITE (LUN,50) FLIMS(1),IH,IM,IS,FLIMS(3),JH,JM,JS
   50 FORMAT (' CURRENT FRAME TIME LIMITS ',2(I5,I3,2(':',I2) ) )
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END
