      SUBROUTINE DEFFRAR (KODE)
C
C-----------------------------------------------------------------------
C
C     Updates the new current frame time limits.
C
C     Returned KODE: = 0, updated time limits, continue processing
C                    = 1, done with this run
C
C     Written by     R.L. WEST     BCSS      7-APR-1989
C
C-----------------------------------------------------------------------
C     Modification of the original DEFFRA written by JFE JOHNSON.
C-----------------------------------------------------------------------
C
      LOGICAL*1 FIRST
C
      INTEGER*2 KODE
C
      INTEGER*4 IFLAG
C
      REAL*8    DUR,INC,FRAME_TIMES(4),RUN_TIMES(4),STRIP_TIMES(4),TIME
C
      COMMON    /COMLIM/STRIP_TIMES,
     *          /COMTMS/RUN_TIMES,INC,DUR,
     *          /FRATMS/FRAME_TIMES,NDIV
C
      DATA      FIRST/.TRUE./
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      KODE=1
C
C-----------------------------------------------------------------------
C     *** just wanted one frame for this run ***
C-----------------------------------------------------------------------
C
      IF (INC .LE. 0) RETURN
C
C-----------------------------------------------------------------------
C     *** wanted more than one frame for this run ***
C-----------------------------------------------------------------------
C
      TIME=NDIV*INC     ! duration of each frame
C
C-----------------------------------------------------------------------
C     *** the first call just calculates the frame stop time ***
C-----------------------------------------------------------------------
C
      IF (FIRST) THEN
         KODE=0
         CALL ADDTM2R (FRAME_TIMES(1),FRAME_TIMES(2),TIME,
     *                 FRAME_TIMES(3),FRAME_TIMES(4))
         FIRST=.FALSE.
C
C-----------------------------------------------------------------------
C     *** the rest of the times, update both start and stop times ***
C-----------------------------------------------------------------------
C
      ELSE
C
C             --- see if frame stop time .GE.  run stop time ---
C
         CALL CMPTM2R (FRAME_TIMES(3),FRAME_TIMES(4),
     *                 RUN_TIMES(3),RUN_TIMES(4),IFLAG)
         IF (IFLAG .GE. 0) RETURN
C
         KODE=0
C
C             --- set frame start time = old frame stop time
C
         FRAME_TIMES(1)=FRAME_TIMES(3)
         FRAME_TIMES(2)=FRAME_TIMES(4)
C
C             --- add frame duration to start time to get stop time ---
C
         CALL ADDTM2R (FRAME_TIMES(1),FRAME_TIMES(2),TIME,
     *                 FRAME_TIMES(3),FRAME_TIMES(4))
C
C             --- set strip start time = frame start time ---
C
         STRIP_TIMES(1)=FRAME_TIMES(1)
         STRIP_TIMES(2)=FRAME_TIMES(2)
C
C             --- add strip duration to strip start time ---
C             ---            to get stop time            ---
C
         CALL ADDTM2R (STRIP_TIMES(1),STRIP_TIMES(2),DUR,
     *                 STRIP_TIMES(3),STRIP_TIMES(4))
      END IF
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END
