      PROGRAM CTSTIM
C
C-----------------------------------------------------------------------
C      CTSTIM.FTN --  COUNT RATE VERSUS TIME PLOT PROGRAM, RUNNING OFF
C                      MAF1 FORMAT DATA.
C
C V2.0 BARBRA GILES 18 AUG 82 DEVELOPED FROM SENTGS V2.0
C V2.1 JFE JOHNSON   9 DEC 82 CORRECTION TO PLOT MAPPING ALGORITHMIN
C                             PROCES
C V2.2 BLG          26 JAN 83 ADDITION OF AVERAGE/MAXIMUM OPTION
C----------------------------------------------------------------------|
C      V2.3                                                            |
C      MODIFIED BY     R.L.WEST     INTERGRAPH      4-DEC-1984         |
C               MODIFIED THE SUBROUTINE RESLTN TO ALLOW THE USER TO    |
C                  DECIDE THE NUMBER OF DIVISIONS TO BE PLOTTED        |
C                                                                      |
C               ADDED A CALL TO REWDED AFTER TIME INTERVAL IS DONE OR  |
C                  EOF DETECTED                                        |
C----------------------------------------------------------------------|
C      V3.0                                                            |
C      MODIFIED BY     R.L.WEST     BCSS     14-APR-1986               |
C               MODIFIED TO USE THE REAL*8 VERSION OF THE 'TIME        |
C               SUBROUTINES', AND TO SMALL TIME INTERVALS              |
C----------------------------------------------------------------------|
C      V3.1                                                            |
C      MODIFIED BY     R.L.WEST     BCSS      8-JUL-1986               |
C               INCORPORATED THE NEW VERSION OF IDCODC                 |
C----------------------------------------------------------------------|
C      V3.2                                                            |
C      MODIFIED BY     R.L.WEST     BCSS     10-MAR-1988               |
C               ELIMINATED THE EXTRA CALL TO GETMF1 ON THE SECOND AND  |
C               SUBSEQUENT PLOTS (IFIRST)                              |
C----------------------------------------------------------------------|
C      V3.3                                                            |
C      MODIFIED BY     R.L.WEST     BCSS      9-NOV-1988               |
C               ADDED THE OPTION TO OUTPUT DATA TO A FILE              |
C----------------------------------------------------------------------|
C      V3.4                                                            |
C      MODIFIED BY     R.L.WEST     BCSS     19-MAY-1989               |
C               Modified to use the NCAR plotting package and a few    |
C               minor changes.                                         |
C----------------------------------------------------------------------|
C      V4.0                                                            |
C      MODIFIED BY     R.L.WEST     BCSS     30-MAY-1990               |
C               Eliminated all plotting calls and add aperature bias   |
C               checking routines                                      |
C----------------------------------------------------------------------|
C
      BYTE      ICX
C
      INTEGER*2 MODBLK(8),IAVEMAX
C
      REAL      CTS_SAVE(1000),ERR_SAVE(1000)
C
      REAL*8    TIME_SAVE(1000)
C
      COMMON    /LUNDA/LUNDA,IDAFLG
C
C-------------------------------------------------------------------
C INITIALIZATION
C-------------------------------------------------------------------
C
      LUNDA=3
      LIN=1
      LUNTI=5
      LUNTO=6
      CALL DELUNS (LIN,LUNTI,LUNTO)
      WRITE (LUNTO,50)
   50 FORMAT (' CTSTIM V4.0')      ! UPDATE PLTNEW TOO 
      CALL DEOPEN
      CALL OPENDA            ! OPEN LIST FILE
C
   49 CONTINUE
      CALL INPUT_CTSTIM (KODE,MODBLK,IAVEMAX,ICX)
      IF (KODE .EQ. -1) GO TO 99
C
C---------------------------------------------------------------------
C PROCESSING
C---------------------------------------------------------------------
C
   40 CONTINUE
      CALL PROCES_CTSTIM (MODBLK,IRET,KFLAG,IAVEMAX,TIME_SAVE,CTS_SAVE,
     *             ERR_SAVE,NSAVE,ICX)
      IF (KFLAG .EQ. 0) GO TO 510
C
C---------------------------------------------------------------------
C LIST DATA
C---------------------------------------------------------------------
C
      CALL PLTNEW_CTSTIM (MODBLK,IAVEMAX,ICX)
      CALL LISTDA_CTSTIM (TIME_SAVE,CTS_SAVE,ERR_SAVE,NSAVE,ICX,)
C
C-------------------------------------------------------------------
C END OF FILE LOGIC
C-------------------------------------------------------------------
C
  510 IF (IRET .EQ. -10) WRITE(LUNTO,520)
  520 FORMAT (' END OF FILE')
      IF (IRET .EQ. 1) WRITE(LUNTO,521)
  521 FORMAT (' NO MORE SUBPERIODS')
      CALL DEFFRAR (KODE)
      IF (KODE .NE. 0) THEN
         WRITE (LUNTO,530)
  530    FORMAT (' NO MORE FRAMES')
         CALL REWDED
         GO TO 49
      END IF
      GO TO 40
C
C-------------------------------------------------------------------
C NORMAL EXIT
C-------------------------------------------------------------------
C
   99 CONTINUE
      CLOSE (UNIT=LUNDA)
      CALL EXIT
      STOP
      END

      SUBROUTINE INPUT_CTSTIM (KODE,MODBLK,IAVEMAX,ICX)
C
C-------------------------------------------------------------------
C
C INPUT SUBROUTINE FOR CTSTIM
C
C THE MODBLK ARRAY STORES A GIVEN DATA SELECTION, AS FOLLOWS
C   ELEMENT   FUNCTIONS		VALUES
C	1	HEAD		1=RADIAL,2=+Z,3=-Z
C	2	ILOHI		1=LO MASS,2=HI MASS
C	3	IM1		LOWER MASS SETTING
C	4	IM2		UPPER MASS SETTING
C	5	IRPA1		LOWER RPA SETTING
C	6	IRPA2		UPPER RPA SETTING
C	7	IANG1		LOWER PHASE ANGLE (+/- 180)
C	8	IANG2		UPPER PHASE ANGLE (+/- 180)
C
C-------------------------------------------------------------------
C
      BYTE       ICX,TEXT(4)
C
      INTEGER*2  MODBLK(8),IAVEMAX
C
C-------------------------------------------------------------------
C     PRPMPT FOR START ANS STOP TIME
C-------------------------------------------------------------------
C
      CALL LMSSETR (KODE)
      IF(KODE.EQ.-1)GO TO 99
C
C-------------------------------------------------------------------
C     PROMPT FOR DURATION OF EACH FRAME
C-------------------------------------------------------------------
C
      CALL FRASETR (KODE)
C
C-------------------------------------------------------------------
C      DEFINE WHICH HEAD
C-------------------------------------------------------------------
C
      CALL HEDSET (MODBLK(1))
C
C-------------------------------------------------------------------
C      DEFINE MASS SETTING RANGE
C-------------------------------------------------------------------
C
      CALL MASSET(JM1,JM2)
C
C-------------------------------------------------------------------
C      SINGLE MASS DET DEFINE ILOHI LO/HI FLAG
C-------------------------------------------------------------------
C
      CALL MASTXT(JM1,JM2,MODBLK(2),TEXT,TEXT)
      MODBLK(3)=JM1
      MODBLK(4)=JM2
      CALL MASCNV(MODBLK(3),MODBLK(4))
C
C-------------------------------------------------------------------
C      DEFINE RPA RANGE
C-------------------------------------------------------------------
C
      CALL RPASET(MODBLK(5),MODBLK(6))
C
C-------------------------------------------------------------------
C      DEFINE ANGLE RANGE
C-------------------------------------------------------------------
C
      CALL ANGSET(MODBLK(7),MODBLK(8))
C
C-------------------------------------------------------------------
C      DEFINE APERTURE BIAS
C-------------------------------------------------------------------
C
      CALL APSET (ICX)
C
C-------------------------------------------------------------------
C      DEFINE WHETHER AVERAGES OR MAXIMUMS NEEDED
C-------------------------------------------------------------------
C
      CALL AVEMAX_CTSTIM(IAVEMAX)
C
C-------------------------------------------------------------------
C-------------------------------------------------------------------
C
   99 RETURN
      END

      SUBROUTINE PROCES_CTSTIM(MODBLK,KODE,LFLAG,IAVEMAX,TIME_SAVE,CTS_SAVE,
     *                    ERR_SAVE,NSAVE,ICX)
C
C-----------------------------------------------------------------------
C
C THIS ROUTINE DOES ALL THE DATA ACCUMULATION FOR THE CURRENT PLOT FRAME
C PART OF CTSTIM PROGRAM
C
C-----------------------------------------------------------------------
C
      BYTE      ICX
C
      LOGICAL   IFIRST1
C
      INTEGER*2 IAVEMAX,INUM,MODBLK(8),KODE
C
      INTEGER*4 IFIRST(2),IMIL,IORBOFT,IORBTIME,IORBYD,ITIME(2,13),IYDOY
C
      REAL      CTS_SAVE(1000),ERR_SAVE(1000),ORBS(4,13)
C
      REAL*8    DUR,FRAME_TIMES(4),INC,RECT,RECYD,RUN_TIMES(4),
     *          STRIP_TIMES(4),TIME_SAVE(1000)
C
      COMMON    /BLKTIM/IYDOY,IMIL,
     *          /COMLIM/STRIP_TIMES,
     *          /COMTMS/RUN_TIMES,INC,DUR,
     *          /DELUNS/LUNDAT,LUNTI,LUNTO,
     *          /FRATMS/FRAME_TIMES,NDIV,
     *          /ORBDAT/ITIME,ORBS
     *          /ORBIT/IORBOFT,IORBYD,IORBTIME,INUM,IFIRST
C
      DATA      IFIRST1/.TRUE./
C
C-----------------------------------------------------------------------
C     INITIALIZE
C-----------------------------------------------------------------------
C
      NSAVE=0
      LFLAG=0
C
C-----------------------------------------------------------------------
C     OUTPUT NEW FRAME LIMITS
C-----------------------------------------------------------------------
C
      CALL FRAOPTR (LUNTO)
      CALL SUBOPTR (LUNTO)
C
C-----------------------------------------------------------------------
C     SEE HOW OFTEN TO SAVE ORBIT PARAMETERS
C-----------------------------------------------------------------------
C
      CALL ORBOFTR
C
C-----------------------------------------------------------------------
C     *** initialize orbit arrays for current frame ***
C-----------------------------------------------------------------------
C
      INUM=0
      DO I=1,13
         ITIME(1,I)=0
         ITIME(2,I)=0
         DO J=1,4
            ORBS(J,I)=0.0
         END DO
      END DO
C
C-----------------------------------------------------------------------
C     GET FIRST RECORD IN
C-----------------------------------------------------------------------
C
      IF (IFIRST1) THEN
         CALL GETMF1(KODE)
         RECYD=IYDOY
         RECT=FLOAT(IMIL)*1000.0D0
         IF (KODE .EQ. -10) GO TO 510
         IFIRST1=.FALSE.
      END IF
      NSAMP=DUR/15625.0D0
      JDIV=NDIV/12
C
C-----------------------------------------------------------------------
C     COLLECT THE DATA
C-----------------------------------------------------------------------
C
      DO 500 IDIV=1,NDIV
         ITSAMP=0
C
C-----------------------------------------------------------------------
C        INITIALISE WORKING ARRAYS
C-----------------------------------------------------------------------
C
         JFLAG=0
         CTS=0.0
         CTN=0.0
C
C-----------------------------------------------------------------------
C        CHECK THE APERTURE BIAS
C-----------------------------------------------------------------------
C
         CALL APTST (ICX,IFLAG)
         IF (IFLAG .EQ. -1) GO TO 10
C
C-----------------------------------------------------------------------
C        SEE IF RECORD IS WITHIN TIME LIMITS
C-----------------------------------------------------------------------
C
   40    CALL LMSTSSR (KODE,I1,I2)
         IF (KODE) 10,200,30
C
C-----------------------------------------------------------------------
C        GET NEXT RECORD
C-----------------------------------------------------------------------
C
   10    CALL GETMF1(KODE)
         RECYD=IYDOY
         RECT=FLOAT(IMIL)*1000.0D0
         IF (KODE .EQ. -10) GO TO 510            ! END OF FILE
         GO TO 40
C
C-----------------------------------------------------------------------
C        RECORD WITHIN TIME LIMITS
C-----------------------------------------------------------------------
C
  200    CONTINUE
         CALL DEFFGS                        ! DEFINE FLAGS
         CALL GETMOD                        ! AND INSTRUMENT MODE
C
C-----------------------------------------------------------------------
C        ACCUMULATE THE DATA
C-----------------------------------------------------------------------
C
         ILH=1
         ITSAMP=ITSAMP+(I2-I1)+1
         CALL GETCTS_CTSTIM(MODBLK,CTS,CTN,I1,I2,KFLAG,IAVEMAX)
         JFLAG=MAX0(JFLAG,KFLAG)
         LFLAG=MAX0(JFLAG,LFLAG)
C
C-----------------------------------------------------------------------
C        SAVE ORBIT DATA FOR THIS SUBPERIOD IF NECESSARY
C-----------------------------------------------------------------------
C
         CALL ORB_SAVE
  105    IF(I2.EQ.512 .AND. ITSAMP.NE.NSAMP)GO TO 10
C
C-----------------------------------------------------------------------
C        AVERAGE THE DATA, CALCULATE THE ERROR AND TIME
C-----------------------------------------------------------------------
C
         NSAVE=NSAVE+1
         IF (CTN .GT. 0.0) THEN
            CTS_SAVE(NSAVE)=CTS/CTN
            ERR_SAVE(NSAVE)=SQRT(CTS)/CTN
         ELSE
            CTS_SAVE(NSAVE)=-1
            ERR_SAVE(NSAVE)=-1
         END IF
         IF (STRIP_TIMES(4) .GT. STRIP_TIMES(2)) THEN
            TIME_SAVE(NSAVE)=(STRIP_TIMES(2)+STRIP_TIMES(4))/2.0D0
         ELSE
            TIME_SAVE(NSAVE)=(STRIP_TIMES(2)+STRIP_TIMES(4))/2.0D0
         END IF
C
C-----------------------------------------------------------------------
C        GET NEXT LIMITS
C-----------------------------------------------------------------------
C
   30    CALL LMSNXTR (KODE)
         CALL SUBOPTR (LUNTO)
         IF (KODE .NE. 0) GO TO 510
C
  500 CONTINUE
C
C-----------------------------------------------------------------------
C     DONE WITH THIS FRAME
C-----------------------------------------------------------------------
C
  510 CONTINUE
      RETURN
      END

      SUBROUTINE PLTNEW_CTSTIM(MODBLK,IAVEMAX,ICX)
C
C-----------------------------------------------------------------------
C
C ROUTINE OUTPUTS THE HEADER AND ORBIT INFORMATION
C PART OF THE CTSTIM PROGRAM
C
C JFEJ 05 MAR 82      FOR NEW SENTGS PROGRAM
C      25 JUL 82      MODS TO LABEL POSITIONS
C BLG  19 AUG 82        MODS TO CHANGE TO CTSTIM
C
C-----------------------------------------------------------------------
C
      BYTE      BUF(60),CM(2),CS(2),ICX,ILOHI(2),Q,TXT(4,2)
C
      INTEGER*2 HEAD(3),IAVEMAX,INUM,MODBLK(8)
C
      INTEGER*4 IFIRST(2),IORBOFT,IORBTIME,IORBYD,ITIME(2,13),ITMDM,MNA
C
      REAL      ORBS(4,13)
C
      REAL*8    FRAME_TIMES(4)
C
      COMMON    /DELUNS/LUNDAT,LUNIN,LUNOUT,
     *          /FRATMS/FRAME_TIMES,NDIV,
     *          /LUNDA/LUNDA,IDAFLG,
     *          /ORBDAT/ITIME,ORBS,
     *          /ORBIT/IORBOFT,IORBYD,IORBTIME,INUM,IFIRST
C
      DATA      Q/'?'/,ILOHI/'L','H'/,HEAD/'RL','+Z','-Z'/
C
C-----------------------------------------------------------------------
C       *** GENERATE FIRST HEADER LINE ***
C-----------------------------------------------------------------------
C
      ITMDM=FRAME_TIMES(2)/1000.0D0
      CALL MSHMSM(ITMDM,IHR,IMN,ISC,MS)
      IF (MS .GE. 500) THEN
         ISC=ISC+1
         IF (ISC .GE. 60) THEN
            ISC=ISC-60
            IMN=IMN+1
            IF (IMN .GE. 60) THEN
               IMN=IMN-60
               IHR=IHR+1
            END IF
         END IF
      END IF
C
      ITMDM=FRAME_TIMES(4)/1000.0D0
      CALL MSHMSM(ITMDM,JHR,JMN,JSC,MS)
      IF (MS .GE. 500) THEN
         JSC=JSC+1
         IF (JSC .GE. 60) THEN
            JSC=JSC-60
            JMN=JMN+1
            IF (JMN .GE. 60) THEN
               JMN=JMN-60
               JHR=JHR+1
            END IF
         END IF
      END IF
C
      IYR=FRAME_TIMES(1)/1000.0D0
      IDN=DMOD(FRAME_TIMES(1),1000.0D0)
      IYR=IYR+80
      CALL DNDT(IYR,IDN,MN,IDY,MNA)
C
      ENCODE (59,100,BUF) IYR,IDN,IDY,MNA,IHR,IMN,ISC,JHR,JMN,JSC
  100 FORMAT ('DE RIMS C-T SUMMARY (V4.0) ',I2,'/',2I3,'-',A3,I3.2,
     *        2('.',I2.2),'-',I2.2,2('.',I2.2)  )
      WRITE (LUNDA,'(59A1)') (BUF(I),I=1,59)
C
C-----------------------------------------------------------------------
C     *** GENERATE SECOND HEADER LINE ***
C-----------------------------------------------------------------------
C
      JM1=MODBLK(3)*((MODBLK(2)-1)*5-4)      ! RESTORE SIGN CONVENTION
      JM2=MODBLK(4)*((MODBLK(2)-1)*5-4)
      CALL MASTXT (JM1,JM2,IDUM,TXT,TXT(1,2))
      ENCODE (58,120,BUF) HEAD(MODBLK(1)),ILOHI(MODBLK(2)),MODBLK(3),
     *                    MODBLK(4),(TXT(I,MODBLK(2)),I=1,4),
     *                    (MODBLK(I),I=5,8),ICX
  120 FORMAT('H=',A2,'/',A1,' M ',I4,' TO ',I4,' ',4A1,' R ',I4,' TO ',
     *       I4,' A ',I4,' TO ',I4,1X,A1)
      WRITE (LUNDA,'(58A1)') (BUF(I),I=1,58)
C
C-----------------------------------------------------------------------
C       *** put on 'AVG' or 'MAX' ***
C-----------------------------------------------------------------------
C
      IF (IAVEMAX .EQ. 1) THEN
         WRITE (LUNDA,'(''AVG'')')
      ELSE
         WRITE (LUNDA,'(''MAX'')')
      END IF
C
C-----------------------------------------------------------------------
C     *** output the orbit information ***
C-----------------------------------------------------------------------
C
      WRITE (LUNDA,'(I3)') INUM
      DO I=1,INUM
         CALL MSHMSM (ITIME(2,I),IHR,IMN,ISC,MS)
         WRITE (LUNDA,'(1X,2I2.2,'':'',I2.2,''.'',I3.3,4F8.2)')
     *                                  IHR,IMN,ISC,MS,(ORBS(J,I),J=1,4)
      END DO
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END

      SUBROUTINE GETCTS_CTSTIM (MODBLK,CTS,CTN,I1,I2,JFLAG,IAVEMAX)
C
C-----------------------------------------------------------------------
C
C THIS SUBROUTINE GETS DATA FOR A GIVEN HEAD AND GIVEN MASS.
C CTS AND CTN ARE UPDATED WITH ALL THE SAMPLES I1 THRU I2, THAT SATISFY
C THE MODBLK REQUIREMENTS.
C PART OF THE CTSTIM PROGRAM
C
C INPUT ARGUMENTS ARE:
C      MODBLK      SEE SENTGS INPUT SUBROUTINE
C      I1          START SAMPLE INDEX OF DATA TO BE INCLUDED
C      I2          STOP SAMPLE INDEX. I1, I2 ARE IN RANGE [1,512]
C OUTPUT ARGUMENTS, IN ADDITION TO CTS, CTN,
C      JFLAG - SET TO 0 IF NO DATA ADDED TO ARRAYS, OTHERWISE 1
C
C NOTE *** BEFORE THIS ROUTINE IS CALLED, THE INFORMATION IN THE
C FOLLOWING COMMON BLOCKS MUST BE DEFINED
C      COMMON      UPDATED BY CALLING
C      ------      ------------------
C      RPAMSH      GETMOD.  CONTAINS INSTRUMENT RPA, IMS SETTINGS
C      I7FLGS      DEFFGS.  CONTAINS INSTRUMENT MODE FLAGS.
C
C V1.0 JFE JOHNSON 13 AUG 82
C V1.1 JFEJ        17 AUG 82 ADDED IDCODC CALL
C V1.2 RLWEST       8 JUL 86 INCORPORATED NEW VERSION IF IDCODC
C
C-----------------------------------------------------------------------
C
      INTEGER*2 IAVEMAX,ICDE(512,2),IDAT(2812),JCR(512,2),JMSH(512),
     *          JRPA(512),MODBLK(8)
C
      INTEGER*4 IDCODC
C
      COMMON    /MAF1/IDAT,
     *          /RPAMSH/JRPA,JMSH
C
      EQUIVALENCE (ICDE(1,1),IDAT(1789)),(JCR(1,1),IDAT(253))
C
C-----------------------------------------------------------------------
C      INITIALIZE
C-----------------------------------------------------------------------
C
      JFLAG=0
C
C-----------------------------------------------------------------------
C     first call refang, to define phase angle reference
C-----------------------------------------------------------------------
C
      CALL REFANG (DEGSAM,RAMANG)
C
      IF (MODBLK(1) .EQ. 1) GO TO 200
C
C-----------------------------------------------------------------------
C     z head processing
C-----------------------------------------------------------------------
C
      IDET=(MODBLK(1)-2)*2+MODBLK(2)
      DO 100 I=I1,I2
C
C-----------------------------------------------------------------------
C        check that rpa setting is in the required range
C-----------------------------------------------------------------------
C
         IF (JRPA(I).LT.MODBLK(5) .OR. JRPA(I).GT.MODBLK(6)) GO TO 100
C
C-----------------------------------------------------------------------
C        check that this mass is in the range required
C-----------------------------------------------------------------------
C
         IF(JMSH(I).LT.MODBLK(3).OR.JMSH(I).GT.MODBLK(4))GO TO 100
C
C-----------------------------------------------------------------------
C        check this sample is in the angle range required
C-----------------------------------------------------------------------
C
         IANG=ISANGL(DEGSAM,RAMANG,I)
         IF (IANG.LT.MODBLK(7) .OR. IANG.GT.MODBLK(8)) GO TO 100
C
C-----------------------------------------------------------------------
C        check we have data for this z head detector
C-----------------------------------------------------------------------
C
         IZMS=IGTZMS(IDET,I)
         IF (IZMS .LE. 0) GO TO 100
C
C-----------------------------------------------------------------------
C        save the data
C-----------------------------------------------------------------------
C
         JFLAG=1
         CTS1=IDCODC(ICDE(I,IZMS),ICTN)
         IF (IAVEMAX .EQ. 1) THEN
            CTS=CTS+CTS1
            CTN=CTN+ICTN
         ELSE
            CTS=AMAX1(CTS,CTS1)
            CTN=1.0
         END IF
C
  100 CONTINUE
      GO TO 400
C
  200 CONTINUE
C
C-----------------------------------------------------------------------
C     radial head processing
C-----------------------------------------------------------------------
C
      DO 300 I=I1,I2
C
C-----------------------------------------------------------------------
C        check that rpa setting is in the required range
C-----------------------------------------------------------------------
C
         IF (JRPA(I).LT.MODBLK(5) .OR. JRPA(I).GT.MODBLK(6)) GO TO 300
C
C-----------------------------------------------------------------------
C        check that this mass is in the range required
C-----------------------------------------------------------------------
C
         IF (JMSH(I).LT.MODBLK(3) .OR. JMSH(I).GT.MODBLK(4)) GO TO 100
C
C-----------------------------------------------------------------------
C        check this sample is in the angle range required
C-----------------------------------------------------------------------
C
         IANG=ISANGL(DEGSAM,RAMANG,I)
         IF(IANG.LT.MODBLK(7).OR.IANG.GT.MODBLK(8))GO TO 100
C
C-----------------------------------------------------------------------
C        save the data
C-----------------------------------------------------------------------
C
         JFLAG=1
         CTS1=IDCODC(JCR(I,MODBLK(2)),ICTN)
         IF (IAVEMAX .EQ. 1) THEN
            CTS=CTS+CTS1
            CTN=CTN+ICTN
         ELSE
            CTS=AMAX1(CTS,CTS1)
            CTN=1.0
         END IF
C
  300 CONTINUE
C
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
  400 CONTINUE
      RETURN
      END

      SUBROUTINE AVEMAX_CTSTIM (IAVEMAX)
C
C-----------------------------------------------------------------------
C
C  PART OF THE CTSTIM PROGRAM
C
C  THIS SUBROUTINE REQUESTS WHETHER AVERAGE COUNTS OR A MAXIMUM
C  COUNT IS REQUIRED.  IAVEMAX = 1 FOR AVERAGE COUNT
C                      IAVEMAX = 2 FOR MAXIMUM COUNT
C
C-----------------------------------------------------------------------
C
      INTEGER*2 IAVEMAX
C
      COMMON    /DELUNS/LUNDAT,LUNTI,LUNTO
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
   10 CONTINUE
      WRITE (LUNTO,100)
  100 FORMAT ($,' AVERAGES=1, MAXIMUMS=2 ? ')
      READ (LUNTI,*,END=99) IAVEMAX
      IF (IAVEMAX .LT. 1  .OR.  IAVEMAX .GT. 2) GO TO 10
      RETURN
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
99    CALL EXIT
      STOP
      END

      SUBROUTINE LISTDA_CTSTIM (TIME_SAVE,CTS_SAVE,ERR_SAVE,NSAVE)
C
C-----------------------------------------------------------------------
C                                                                      |
C      Writes the data out to the data file.                           |
C      PART OF THE CTSTIM PROGRAM                                      |
C                                                                      |
C-----------------------------------------------------------------------
C                                                                      |
C      Written by     R. L. WEST     BCSS      9-NOV-1988              |
C                                                                      |
C-----------------------------------------------------------------------
C                                                                      |
C      VARIABLE     MEANING                                            |
C        ***          ***                                              |
C      CTS_SAVE     array containing the counts per sample             |
C      ERR_SAVE     array containing the associated with the counts    |
C      NSAVE        the number of samples saved                        |
C      TIME_SAVE    the time of each sample saved                      |
C                                                                      |
C-----------------------------------------------------------------------
C                                                                      |
C      COMMON       PURPOSE                                            |
C        ***          ***                                              |
C                                                                      |
C-----------------------------------------------------------------------
C                                                                      |
C      SUB/FUNC     PURPOSE                                            |
C        ***          ***                                              |
C                                                                      |
C-----------------------------------------------------------------------
C
      INTEGER*2 IDAFLG,LUNDA,NSAVE
C
      INTEGER*4 MSEC
C
      REAL      CTS_SAVE(NSAVE),ERR_SAVE(NSAVE)
C
      REAL*8    TIME_SAVE(1000),HOUR,MINUTE,SEC,SEC1,SECM
C
      COMMON    /LUNDA/LUNDA,IDAFLG
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      WRITE (LUNDA,'(I6)') NSAVE
      DO I=1,NSAVE
         SEC=TIME_SAVE(I)/1.0D+06
         HOUR=SEC/3.6D+03
         IH=HOUR
         HOUR=IH
         MINUTE=(SEC-HOUR*3.6D+03)/6.0D+01
         IM=MINUTE
         MINUTE=IM
         SEC1=SEC-HOUR*3.6D+03-MINUTE*6.0D+01
         ISEC=SEC1
         SEC2=ISEC
         SECM=SEC1-SEC2
         MSEC=SECM*1.0D+06
         WRITE (LUNDA,'(2I2.2,'':'',I2.2,''.'',I6.6,2(PE13.5))')
     *                           IH,IM,ISEC,MSEC,CTS_SAVE(I),ERR_SAVE(I)
      END DO
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END
