	PROGRAM CESPEC
C
C-----------------------------------------------------------------------
C COUNTS VERSUS ENERGY FOR SINGLE DETECTOR/MASS, USES RIMS MAF1 AS INPUT
C
C V3.0 JFE JOHNSON  8 AUG 82
C                  15 AUG 82 CALLS GETMD1, TEST FOR ALOG10(0)
C V3.1 JFEJ        22 OCT 82 NOW USES CORRECT RPA VALUES IN PLOT
C V3.2 JFEJ	   14 NOV 82 CAN NOW OUTPUT PLOTTED VALUES TO FILE
C			     THEN USE IN MESPEC, IESPEC PROGRAMS.
C V3.3 RLWEST      19 NOV 82 UPDATED TO INCLUDE LINEAR Y-AXIS
C                            OPTION WITH VARIABLE RANGE
C V3.4 JFEJ	   14 DEC 82 CHECK IN FOR NDIF RETURNED FROM NDIFVL
C			     TO BE NON ZERO (PROCES)
C V4.0 RLWEST BCSS  1 DEC 87 MODIFIED TO NOT DO ANY PLOTTING SO CAN
C                            BE PUT ON OPTICAL DISK FOR GSFC
C V4.1 RLWEST BCSS 10 MAR 88 ELIMINATED THE EXTRA CALL TO GETMF1 ON THE
C                            SECOND AND SUBSEQUENT PLOTS (ITEST)
C V5.0 RLWEST BCSS  8 JAN 90 MADE COMPATIBLE WITH THE REAL*8 TIME 
C                            ROUTINES AND ADDED THE APERTURE SETTING
C                            ROUTINES.
C
C-----------------------------------------------------------------------
C
	PARAMETER NSIZE=32
	BYTE ICX
	REAL RCTS(NSIZE)
	INTEGER MODBLK(8),ICTN(NSIZE),IRPA(32)
	COMMON/LUNDA/LUNDA,IDAFLG
C
C-----------------------------------------------------------------------
C INITIALIZATION
C-----------------------------------------------------------------------
C
	LUNDA=3					! UNIT # FOR LIST FILE
	LIN=1
	LUNTI=5
	LUNTO=6
	CALL DELUNS(LIN,LUNTI,LUNTO)
	WRITE(LUNTO,50)
   50	FORMAT(' CESPEC V5.0')
	CALL DEOPEN
	CALL OPENDA				! OPEN LIST FILE
C
   49	CONTINUE
	CALL INPUT_CESPEC(KODE,MODBLK,ICX)
	IF(KODE.EQ.-1)GO TO 99
C
C-----------------------------------------------------------------------
C PROCESSING
C-----------------------------------------------------------------------
C
   40	CONTINUE
C-----------------------------------------------------------------------
C 		INITIALIZE ALL THE PARAMETERS
C-----------------------------------------------------------------------
	CALL INIT_CESPEC(RCTS,ICTN)
	KFLAG=0
C-----------------------------------------------------------------------
C 		ACCUMULATE DATA (KFLAG SET TO 1 IF ANY COLLECTED)
C-----------------------------------------------------------------------
	CALL PROCES_CESPEC(MODBLK,IRET,KFLAG,RCTS,ICTN,IRPA,NDIF,ICX)
	IF(KFLAG.EQ.0)GO TO 42
C-----------------------------------------------------------------------
C 		WRITE HEADER INFORMATION AND DATA
C-----------------------------------------------------------------------
	IF (IDAFLG .EQ. 1)
     *	              CALL WRTOUT_CESPEC(MODBLK,RCTS,ICTN,IRPA,NDIF,ICX)
C-----------------------------------------------------------------------
C		SEE IF MORE
C-----------------------------------------------------------------------
   42	IF(IRET.LT.0)GO TO 510
	CALL LMSNXTR(IRET)
	IF(IRET.EQ.0)GO TO 40
C
C-----------------------------------------------------------------------
C END OF FILE LOGIC
C-----------------------------------------------------------------------
C
  510	IF(IRET.EQ.-10)WRITE(LUNTO,520)
  520	FORMAT(' END OF FILE')
	IF(IRET.EQ.1)WRITE(LUNTO,521)
  521	FORMAT(' NO MORE SUBPERIODS')
	CALL REWDED
	GO TO 49
C
C-----------------------------------------------------------------------
C NORMAL EXIT
C-----------------------------------------------------------------------
C
   99	CONTINUE
	CLOSE(UNIT=LUNDA)
	CALL EXIT
	STOP
	END

	SUBROUTINE INPUT_CESPEC(KODE,MODBLK,ICX)
C
C-----------------------------------------------------------------------
C
C INPUT SUBROUTINE FOR CESPEC
C
C-----------------------------------------------------------------------
C
	INTEGER MODBLK(8)
C
C-----------------------------------------------------------------------
C THE MODBLK ARRAY STORES A GIVEN DATA SELECTION, AS FOLLOWS
C   ELEMENT   FUNCTIONS		VALUES
C	1	HEAD		1=RADIAL,2=+Z,3=-Z
C	2	ILOHI		1=LO MASS,2=HI MASS
C	3	IM1		LOWER MASS SETTING
C	4	IM2		UPPER MASS SETTING
C	5	IRPA1		LOWER RPA SETTING
C	6	IRPA2		UPPER RPA SETTING
C	7	IANG1		LOWER PHASE ANGLE (+/- 180)
C	8	IANG2		UPPER PHASE ANGLE (+/- 180)
C-----------------------------------------------------------------------
C
	BYTE ICX,TEXT(4)
	COMMON/DELUNS/LUNDA,LUNIN,LUNOUT
C
C-----------------------------------------------------------------------
C GET START AND STOP TIMES AND TIME INTERVAL
C-----------------------------------------------------------------------
C
	CALL LMSSETR(KODE)
	IF(KODE.EQ.-1)GO TO 99
	CALL SUBSETR(KODE)
C
C-----------------------------------------------------------------------
C DEFINE WHICH HEAD
C-----------------------------------------------------------------------
C
	CALL HEDSET(MODBLK(1))
C
C-----------------------------------------------------------------------
C DEFINE MASS SETTING RANGE
C-----------------------------------------------------------------------
C
	CALL MASSET(JM1,JM2)
C
C-----------------------------------------------------------------------
C SINGLE MASS DET DEFINE ILOHI LO/HI FLAG
C-----------------------------------------------------------------------
C
	CALL MASTXT(JM1,JM2,MODBLK(2),TEXT,TEXT)
	MODBLK(3)=JM1
	MODBLK(4)=JM2
	CALL MASCNV(MODBLK(3),MODBLK(4))
C
C-----------------------------------------------------------------------
C DEFINE ANGLE RANGE
C-----------------------------------------------------------------------
C
	CALL ANGSET(MODBLK(7),MODBLK(8))
C
C-----------------------------------------------------------------------
C DEFINE APERTURE BIAS
C-----------------------------------------------------------------------
C
	CALL APSET(ICX)
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
	RETURN
   99	KODE=-1
	RETURN
	END

	SUBROUTINE INIT_CESPEC(RCTS,ICTN)
C
C-----------------------------------------------------------------------
C INITILISATTION ROUTINE FOR CESPEC PROGRAM
C-----------------------------------------------------------------------
C
	REAL RCTS(32)
	INTEGER ICTN(32)
	COMMON/DELUNS/LUNDAT,LUNTI,LUNTO
C
C-----------------------------------------------------------------------
C ZERO DATA AREAS
C-----------------------------------------------------------------------
C
	DO 10 I=1,32
	   RCTS(I)=0.0
	   ICTN(I)=0
   10	CONTINUE
C
C-----------------------------------------------------------------------
C DEFINE AND OUTPUT NEW TIME LIMITS
C-----------------------------------------------------------------------
C
	CALL SUBOPTR(LUNTO)
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
	RETURN
	END

	SUBROUTINE PROCES_CESPEC(MODBLK,KODE,LFLAG,RCTS,ICTN,IRPA,NDIF,ICX)
C
C-----------------------------------------------------------------------
C THIS ROUTINE DOES ALL THE ACCUMULATION FOR THE CURRENT TIME INTERVAL
C FOR CESPEC
C NOTE THAT /RPAMSH/ IS USED HERE
C-----------------------------------------------------------------------
C
	LOGICAL IFIRST
	BYTE ICX
	INTEGER ICTN(32),MODBLK(8),IRPA(32),JRPA(512),IMSH(512),IFLAG
	REAL RCTS(32)
	COMMON/RPAMSH/JRPA,IMSH
	DATA IDIRST/.TRUE./
C
	LFLAG=0
C
C-----------------------------------------------------------------------
C GET FIRST BLOCK
C-----------------------------------------------------------------------
C
	IF (IFIRST) THEN
	   CALL GETMF1(KODE)
	   IF(KODE.LT.0)GO TO 30
	   IFIRST=.FALSE.
	END IF
C
C-----------------------------------------------------------------------
C SEE IF WITHIN TIME LIMITS
C-----------------------------------------------------------------------
C
   40	CALL LMSTSTR(KODE)
	IF(KODE)10,200,30
C
C-----------------------------------------------------------------------
C GET NEXT RECORD
C-----------------------------------------------------------------------
C
   10	CALL GETMF1(KODE)
	IF(KODE.EQ.-10)GO TO 30		! END OF FILE
	GO TO 40
C
  200	CONTINUE
C
C-----------------------------------------------------------------------
C THIS DATA IN CURRENT LIMITS SO PROCESS
C-----------------------------------------------------------------------
C
	IF(LFLAG.EQ.0)CALL ORBSAV
	CALL APTST (ICX,IFLAG)
	IF (IFLAG .EQ. -1) GO TO 10		! NOT AP BIAS DESIRES
	CALL DEFFGS				! DEFINE FLAGS
	CALL GETMD1				! AND INSTRUMENT MODE
C-----------------------------------------------------------------------
C 		DETERMINE THE UNIQUE RPA SEQUENCE
C		ASSUMED PRESENT IN FIRST 32 SAMPLES.
C-----------------------------------------------------------------------
	CALL FNDVAL(JRPA,32,IRPA,NDIF)		! GET UNIQUE VALUES
	IF(NDIF.LE.0)GO TO 10			! CHECK WE HAVE SOME
	CALL SORT(IRPA,NDIF)			! AND SORT THEM
C-----------------------------------------------------------------------
C 		NOW PROCESS THE DATA FOR SPIN-TIME PANEL
C-----------------------------------------------------------------------
	I1=1
	I2=512
	CALL SRTRP2(MODBLK,RCTS,ICTN,I1,I2,JFLAG,IRPA,NDIF)
	LFLAG=MAX0(JFLAG,LFLAG)
	GO TO 10				! GET NEXT RECORD
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
   30	RETURN
	END

	SUBROUTINE WRTOUT_CESPEC(MODBLK,RCTS,ICTN,IRPA,NDIF,ICX)
C
C-----------------------------------------------------------------------
C WRITES HEADER INFORMATION TO THE OUTPUT FILE 
C PART OF THE CESPEC PROGRAM.
C-----------------------------------------------------------------------
C
	BYTE ICX,BUF(80),ILOHI(2),TXT(4,2)
	INTEGER*2 HEADER(24),ICTN(NDIF),IRPA(NDIF),JHEAD(3),MODBLK(8)
	INTEGER*4 IMS,JMS
	REAL*8 MS1,MS2,YD1,YD2
	REAL RCTS(NDIF)
	COMMON/COMLIM/YD1,MS1,YD2,MS2
	COMMON/LUNDA/LUNDA,IDAFLG
	COMMON/HEDSAV/HEADER
	DATA ILOHI/'L','H'/,JHEAD/'RL','+Z','-Z'/
C
C-----------------------------------------------------------------------
C WRITE THE FIRST LINE
C-----------------------------------------------------------------------
C
	IYR=80.0D0+YD1/1000.0D0
	IDN=DMOD(YD1,1000.0D0)
	IMS=MS1/1000.0D0
	JMS=MS2/1000.0D0
	CALL MSHMSM(IMS,IHR,IMN,ISC,MS)
	CALL MSHMSM(JMS,JHR,JMN,JSC,MS)
	JM1=MODBLK(3)*((MODBLK(2)-1)*5-4)	! RESTORE SIGN CONVENTION
	JM2=MODBLK(4)*((MODBLK(2)-1)*5-4)
	CALL MASTXT(JM1,JM2,IDUM,TXT,TXT(1,2))
	ENCODE(80,100,BUF)JHEAD(MODBLK(1)),ILOHI(MODBLK(2)),
     1	(TXT(I,MODBLK(2)),I=1,4),IYR,IDN,IHR,IMN,ISC,JHR,JMN,JSC
  100	FORMAT('DE RIMS H=',A2,'/',A1,' ',4A1,' ',I2,'/',I3,' ',I2,
     1	2(':',I2),' -',I2,2(':',I2) )
	WRITE(LUNDA,200)(BUF(I),I=1,45)
  200	FORMAT(80A1)
C
C-----------------------------------------------------------------------
C WRITE THE SECOND LINE
C-----------------------------------------------------------------------
C

	R=0.0
	DO 300 I=9,11
	   RK=HEADER(I)*0.001
	   R=R+RK*RK
  300	CONTINUE
	R=SQRT(R)
	RL=HEADER(15)*0.01
	RLT=HEADER(19)*0.01
	RLAT=HEADER(17)*0.01
        V1=HEADER(12)*0.01
        V2=HEADER(13)*0.01
        V3=HEADER(14)*0.01
        VEL=SQRT(V1*V1+V2*V2+V3*V3)
	ENCODE(80,400,BUF)R,VEL,RLT,RLAT,RL,MODBLK(3),MODBLK(4)
  400	FORMAT('RE=',F4.2,' VEL=',F5.2,' LT=',F5.2,' MLAT=',F5.1,'DEG L=',
     1	F5.0,' M:',I5,':',I5)
	WRITE(LUNDA,200)(BUF(I),I=1,61)
C
C-----------------------------------------------------------------------
C WRITE THE THIRD LINE
C-----------------------------------------------------------------------
C
	ENCODE(80,500,BUF)MODBLK(7),MODBLK(8),ICX
  500	FORMAT('ANG RANGE: ',I4,' TO ',I4,' DEG',' AP BIAS: ',A1)
	WRITE(LUNDA,200)(BUF(I),I=1,38)
C
C-----------------------------------------------------------------------
C COUNT THE NUMBER OF SAMPLES AND WRITE TO THE OUTPUT FILE
C-----------------------------------------------------------------------
C
        NSMP=0
        DO 600 I=1,NDIF
           IF (ICTN(I) .LE. 0) GO TO 600
           NSMP=NSMP+1
  600   CONTINUE
	WRITE (LUNDA,700) NSMP
  700   FORMAT (I3)
C
C-----------------------------------------------------------------------
C WRITE OUT THE DATA VALUES
C-----------------------------------------------------------------------
C
	DO 800 I=1,NDIF
	   CTS=0.0
           CTE=0.0
	   IF(ICTN(I) .GT. 0) THEN
	      CTS=RCTS(I)/FLOAT(ICTN(I))
	      CTE=SQRT(RCTS(I))/FLOAT(ICTN(I))
	      X=IRPA(I)*0.050
	      WRITE(LUNDA,900)X,CTS,CTE
	   END IF
  800	CONTINUE
  900	FORMAT(F10.2,2(PE13.5))
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
	RETURN
	END
