      SUBROUTINE ADDTM2R (YD1,T1,INC,YD2,T2)
C
C-----------------------------------------------------------------------
C
C     Adds an increment of time (microseconds) to YD1,T1 resulting in
C     YD2,T2
C
C     Written by     R.L. WEST     BCSS      6-OCT-1989
C
C-----------------------------------------------------------------------
C     Modification of the original ADDTM2 written by JFE JOHNSON.
C-----------------------------------------------------------------------
C
      REAL*8 INC,D2,T1,T2,YD1,YD2,Y2
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      IY=YD1/1000.0D0
      Y2=IY
      D2=YD1-Y2*1000.0D0
      T2=T1+INC
      IF (T2 .GE. 86400000000.0D0) THEN
         DO WHILE (T2 .GE. 86400000000.0D0)
            T2=T2-86400000000.0D0
            D2=D2+1.0D0
         END DO
         IF (DMOD(Y2,4.0D0) .EQ. 0.0D0) THEN
            DO WHILE (D2 .GT. 366.0D0)
               D2=D2-366.0D0
               Y2=Y2+1.0D0
            END DO
         ELSE
            DO WHILE (D2 .GT. 365.0D0)
               D2=D2-365.0D0
               Y2=Y2+1.0D0
            END DO
         END IF
         YD2=Y2*1000.0D0+D2
      ELSE
         YD2=YD1
      END IF
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C
      RETURN
      END
