pro read_maga, date, time, Bphi, Btheta
; read MAG-A vectors from a daily VMS binary file and compute Bphi, Btheta
; Robert.M.Candey.1@gsfc.nasa.gov 1995 March 27

on_ioerror, finish
time_ds = time * 10L ; convert time from ms to 0.1 ms for MAG-A
if ((strupcase(!version.arch) eq 'VAX') or $
        (strupcase(!version.arch) eq 'ALPHA')) then onVAX = 1 else onVAX = 0
oneLine = {mag_struc, time:0L, Bx:0.0, By:0.0, Bz:0.0} ; , mode:0L}
	; or whatever format for MAG-A file (reading mode gives EOF error)
;maga time resolution is 62.5 millisecs
;maxCount = 24L*60L*60L*1000L/62.5
maxCount = 24L*60L*60L*16L+1L ; or whatever time resolution
magdata = replicate(oneLine, maxCount)
count = 0L
endTime = time_ds(n_elements(time_ds)-1) + 10000L ; add 1 sec to end time
curTime = -1L
openr, lun, string(date,format='(I5.5)') + '.magadat', /get_lun
while ((not  eof(lun) and (count lt (maxCount-1)) and $
	(curTime lt endTime))) do begin
;  readf, lun, oneLine ; if ASCII file
; if Binary file
  if (onVAX eq 1) then begin
    readu, lun, oneLine ; if Binary file
  endif else begin
    read_vax_block,lun,byte_array,end_of_file,error_flag,/extend
    if error_flag then message, 'Read_SATM error: VAX conversion problem'
    readStruc, byte_array, oneLine
    oneLine = conv_vax_unix(oneLine)
  endelse
  magdata(count) = oneLine
  count = count + 1
  curTime = oneLine.time
endwhile
finish:
if (count eq maxCount) then print, 'maxCount exceeded' else $
        magdata=magdata(0:count-1)
free_lun, lun
; could speed this up somehow by interpolating all these together
; MAG-A times in 0.1ms, so adjust HAPI times (in ms)
interpIndices, magdata.time, time_ds, nearest, nextNearest
Bx = interpValues(magdata.time, magdata.Bx, time_ds, nearest, nextNearest, 0.)
By = interpValues(magdata.time, magdata.By, time_ds, nearest, nextNearest, 0.)
Bz = interpValues(magdata.time, magdata.Bz, time_ds, nearest, nextNearest, 0.)
;Bx = hlapi_interp(magdata.time, magdata.Bx, time_ds, 0.)
;By = hlapi_interp(magdata.time, magdata.By, time_ds, 0.)
;Bz = hlapi_interp(magdata.time, magdata.Bz, time_ds, 0.)
magAng, Bx, By, Bz, Bphi, Btheta

return
end ; read_maga
