;DYNAMICS EXPLORER 2 (DE-2) MAGNETOMETER (MAG-B) HIGH RESOLUTION GMS DATA
; 1995 July 21; Robert.M.Candey.1@gsfc.nasa.gov

temp = {magb_str, $ 
Year:0L, $
Day:0L, $ ;	Day of year, January 1 = day 1
Time:0L, $ ; Time of MAG-B measurement in milliseconds from beginning of day
Mode:0L, $ ; Instrument mode at time measurement taken. No change on MAG-B
BR:0., $ ; Radial-Component of the Measured magnetic field in GMS coord.
BTH:0., $ ; Theta-Component of the Measured magnetic field in GMS coord.
BPH:0., $ ; Phi-Component of the Measured magnetic field in GMS coord.
MR:0., $ ; Radial-Component of the Model magnetic field in GMS coord.
MTH:0., $ ; Theta-Component of the Model magnetic field in GMS coordinates
MPH:0., $ ; Phi-Component of the Model magnetic field in GMS coordinates
GALT:0., $ ; Satellite altitude
MLONG:0., $ ; Magnetic longitude
MLAT:0., $ ; Magnetic latitude
MLT:0., $ ; Magnetic local time
ILAT:0. $ ; Invariant latitude
}

count = 0L
maxCount = 1000L ; 24L*60L*60L*16L + 100L
data = replicate(temp, maxCount)
filename = ' ' 
read, 'What GMS MAG-B file to read? ', filename
openr, lun, filename, /get_lun, /stream ; 60
while (count lt (maxCount-1)) and not eof(lun) do begin
  readu, lun, temp
  data(count) = temp
  count = count + 1
endwhile
if count ge maxCount then print, 'Exceeded maxCount' else $
  data = data (0:count-1)
free_lun, lun
if (strupcase(!version.os) ne 'VMS') then data = conv_vax_unix(data)

;      dehires_load, filename, start, finish, br, bth, bph, mod_br, mod_bth,$
;                    mod_bph, galt, mlt, ilat, mlong, mlat, time, flag
;      Inputs:   Daily file name, start time, end time
;      Outputs:  Br, Bth, Bph, Mr, Mth, Mph, altitude, magnetic local time,
;;                invariant latitude, magnetic longitude, magnetic latitude, 
;                time, and a flag if there was no data in the requested interval.
end
