pro LAPIspec4, hlapi, ea, energy, flux_elec1, flux_ions1
; Draws color spectrograms of the DE-2 LAPI and HAPI particle data
; .run load_hlapi?? to load in data
; originally by Michael Lambertson (ORI) November 1987
; altered for new data format by Bobby Candey (ORI) 14 November 1988
; uses 512 by 480 color image device
; plots multiple panels for a range of pitch angles  23 August 1990 BC
; converted to plot multiple electron and ion panels  24 August 1990 BC
; added HAPI display  20 October 1990 BC (Atlantic Research)
; converted to IDL version 2    BC 22 August 1991
; converted to Postscript or X window output, BC (Hughes STX) 1992 June 22
; fixed multiple bugs BC (Hughes STX) 1992 Aug 25
; cleaned up fonts for Postscript, BC 15 feb 1993
; added check for fixed size of spectrogram itself 18 Feb 1993
; added collection of desired sensor 22 Feb 1993

;*****************************************************************************
; SETUP

isLW = 0
isGray = 0
isPostscript = 0
isFixedSize = 0
read, 'Plot to X window (0) or Postscript file (1)? ', isPostscript
read, 'Gray scale (1) or color (0) ? ', isGray
if isPostscript then begin
  if isGray then read, 'Print on a laserwriter (1, else 0)? ', isLW
  read, 'Use fixed size (1) or let program calculate size of plot (0)? ', $
	isFixedSize
  set_plot,'PS'
  if isLW then begin
    device, /landscape, bits=4, font_size=12 ; color tables not used
    nColors = 16
  endif else begin
    device,/landscape,bits=8,font_size=12,/color,/INCHES,YOFFSET=9.75,XSIZE=8.5
	 ; , scale_factor=40
    nColors = 256
  endelse
  !p.color = 0
  !p.thick = 3.0 & !x.thick = 3.0 & !y.thick = 3.0
  !x.style = 1   & !y.style = 1
  !p.charthick = 3.0
  !p.charsize = 1.0
  !p.font = 0 ; hardware font, -1 for Hershey character set
  pfont = 0
  fontsize = 1 & smallfontsize = 1 & bigfontsize = 1.5
  tickLength = 200.
;  !p.position = [0.92, 0.5, 0.97, 0.9]
;  colorbarYTitle = 'Energy Flux (ergs/cm!E2!N sec sr eV)'
  colorbarYTitle = 'Energy Flux (ergs/cm!U2!N sec sr eV)'
  plotYTitle = 'Energy (eV)'
  plotPAheight = 360.
  !order = 1 ; invert TV output; ### only for Postscript?
endif else begin
  set_plot,'X'
  nColors = 256
  !p.color = 255
  !p.thick = 3.0 & !x.thick = 3.0 & !y.thick = 3.0
  !x.style = 1   & !y.style = 1
  !p.charthick = 3.0
  !p.charsize = 1.0
  !p.font = 0 ; hardware font, -1 for Hershey character set
  pfont = -1
  fontsize = 1 & smallfontsize = 1 & bigfontsize = 1
  tickLength = 4.
;  !p.position = [0.92, 0.5, 0.97, 0.9]
;  colorbarYTitle = 'Energy Flux (ergs/cm!E2!N sec sr eV)'
  colorbarYTitle = 'Energy Flux (ergs/cm!U2!N sec sr eV)'
  plotYTitle = 'Energy (eV)'
  plotPAheight = 36.
  !order = 1 ; invert TV output; ### only for Postscript?
endelse

LABELS = ['UT ', 'IL ', 'MLT', 'LST', 'LAT', 'LON', 'ALT']
NominalPA = [0.0, 7.5, 15.0, 30.0, 45.0, 60.0, 97.5, 112.5, 165.0, 180.0]
PAstr = ['  0', '7.5', ' 15', ' 30', ' 45', ' 60', ' 98', '112', '165', '180']
nsteps = hlapi.nsteps

!p.noerase = 1
;*****************************************************************************
; COLOR TABLES
; common colors,red,green,blue,cur_red,cur_green,cur_blue

;if isGray then begin
;  red1 = nColors - 1 - bindgen(nColors) ; inverted gray scale
  red1 = 255 - bindgen(256) ; inverted gray scale; ignored for isLW
  green1 = red1
  blue1 = red1
;endif ; isGray
;*****************************************************************************
; OPTIONS
COLOUR = 0
;READ, 'Color for text (230=beige, 0=black on LW and color, else 255)? ', COLOUR
if isPostscript then if (isGray and not isLW) then colour = 255

if ((not isGray) and (nColors eq 256)) then begin
;loadct1, 3, red1, green1, blue1, '$disk2:[orrmc.idl]lapicolor.tbl'
  restore,'goodcolor.xdr'
  red1(0) = 0 & green1(0) = 0 & blue1(0) = 0		; ensure black
  red1(255) = 255 & green1(255) = 255 & blue1(255) = 255	; ensure white
endif ; load color table
tvlct,red1,green1,blue1
;*****************************************************************************
; TIME
time = ea.time
BegT = 0
EndT = n_elements(time) - 1
print, 'Time indices from', BegT, ' = ', timeconvert(time(BegT)), $
  ' to', EndT, ' = ', timeconvert(time(EndT))
again:
;READ, 'Input beginning and ending time indices? ', BegT, EndT
read, 'Input beginning time (hh, mm, ss)? ', bhh, bmm, bss
BegTime = ((bhh * 60L + bmm) * 60L + bss) * 1000L
read, 'Input ending time (hh, mm, ss)? ', ehh, emm, ess
EndTime = ((ehh * 60L + emm) * 60L + ess) * 1000L
timeRange = where((time ge BegTime) and (time le EndTime), wc)
if (wc le 0) then begin
  print, 'Time range selected is out of range of data'
  goto, again
endif
BegT = timeRange(0)
EndT = timeRange(wc-1)
timeSize = float(EndT - BegT + 1.)
; start and end on whole minutes
;Begmin = fix((time(BegT) mod (60*60*1000)) / (60*1000))
;Endmin = fix(((time(BegT) mod (60*60*1000)) + 59*1000) / (60*1000))
;plot_time = (float(Endmin - Begmin) * 60 * float(nsteps) / steps_sec + 1.
;first_time = plot_time * (time(BegT)/(60*1000) - Begmin) / (Endmin-Begmin)
plot_time = timesize ; width of plot in time units
first_time = 0.
timeNdx = indgen(timeSize)

;*****************************************************************************
; PITCH ANGLES
print, ea(BegT).sensors_elec, format="('Electrons',16I6)"
print, format="(9x,16f6.1)", ea(BegT).pa_elec
print, ea(BegT).sensors_ions, format="('Ions     ',16I6)"
print, format="(9x,16f6.1)", ea(BegT).pa_ions
numPAs = 0
READ, 'Number of Pitch angle panels? ', numPAs
if ((numPAs le 2) and (hlapi.satID eq 'H')) then plotPA = 1 else plotPA = 0

;*****************************************************************************
; X-AXIS SCALING
Lside = 9. * !d.x_ch_size	; 50			; left edge coordinate
Rmargin = 10. * !d.x_ch_size	; 53.			; right side margin
Xcol = float(!d.x_size - Lside - Rmargin)
Xmag = Xcol / plot_time ; X magnification
;try these next 2 lines for fixed magnification
if not isPostscript then Xmag = float(fix(Xmag)) ; < 5.
if (Xmag lt 1.) then begin
  print, 'Time range exceeds plot area; time range will be truncated'
  Xmag = 1.
  plot_time = Xcol
  timeSize = plot_time
  EndT = BegT + timeSize
  timeNdx = indgen(timeSize)
endif
Xcol = plot_time * Xmag
print, 'X magnification =', Xmag
Rside = Lside + fix(plot_time * Xmag + 0.99)	; right edge coordinate

; list of indexes to even minutes for plotting tick marks
; put tick marks every minute if more than 1.5 minutes else every 10 seconds
if (timesize lt 1.5*60) then timestep = 10000 else $
  if (timesize lt 4. * 60.) then timestep = 30000 else $
  if (timesize lt 10. * 60.) then timestep = 60000 else $
  if (timesize lt 20. * 60.) then timestep = 120000 else $
  timestep = 180000 
MINS = WHERE(((time MOD timestep) LT 1000) AND $
	(time GE (time(BegT)-1000)) AND $
	(time LE (time(EndT)+1000)), wMins)
if (wMins le 0) then mins = [0] ; less than 10 seconds puts label at wrong place

;*****************************************************************************
; Get data
; ### allow for missing segments
;data = ea(BegT:EndT)
data = ea(timeRange)
fluxType = 3 ; energy flux
case n_params(0) of
  2: calc_flux, hlapi, data, fluxType, fluxOpt, energy, flux_elec, flux_ions
  4: begin
;       print, 'Electrons only'
;       flux_elec = flux_elec1(*,*,BegT:EndT)
       flux_elec = flux_elec1(*,*,timeRange)
     end ; case 4
  5: begin
;       print, 'Electrons and Ions only'
;       flux_elec = flux_elec1(*,*,BegT:EndT)
;       flux_ions = flux_ions1(*,*,BegT:EndT)
       flux_elec = flux_elec1(*,*,timeRange)
       flux_ions = flux_ions1(*,*,timeRange)
     end ; case 5
  else: begin
       print, 'Incorrect number of parameters'
       print, 'LAPIspec4, hlapi, ea, energy, flux_elec, flux_ions'
       return
      end ; else
endcase

;*****************************************************************************
; Y-AXIS SCALING
Bside = 12. * !d.y_ch_size	; 110. minimum	; bottom edge coordinate
Tmargin = 4. * !d.y_ch_size			; top margin
spacing = !d.y_ch_size	; 2. minimum			; spacing between plots

eVlog = alog10(energy)
eVhigh = 1 + fix(eVlog(0)) ; decade above maximum eV
eVlow = fix(eVlog(nsteps-1)) ; decade below minimum eV
fullsteps = float(eVhigh - eVlow) / (eVlog(0) - eVlog(nsteps-1)) * nsteps
	; new number of steps that would fill plot height from eVlow to eVhigh
firststep = (eVlog(nsteps-1) - eVlow) / (eVhigh - eVlow) * fullsteps

Yrow = float(!d.y_size - Bside - Tmargin - numPAs * spacing)
if (plotPA eq 1) then Yrow = Yrow - plotPAheight
Ymag = Yrow / (numPAs * fullsteps)
;Yrow = 1.0 * fix(0.4 * Xcol) ; make Y height 0.4 of X width
;Ymag = Yrow / fullsteps
; try these next 3 lines for fixed magnification
if not isPostscript then Ymag = float(fix(Ymag))
if (Ymag lt 1.) then begin
  print, 'Plot height exceeds plot area; Number of plots will be truncated'
  Ymag = 1.
  numPAs = fix(Yrow / fullsteps)
endif
Yrow = numPAs * (spacing + fullsteps * Ymag)
print, 'Y magnification =', Ymag
Tside = Bside + numPAs * spacing + fix(Ymag * (numPAs * fullsteps) + 0.99)
	; top edge
if (plotPA eq 1) then Tside = Tside + plotPAheight

;*****************************************************************************
; COLOR BAR
colorbarWidth = 3. * !d.x_ch_size
if (not isPostscript) then begin
  ;clt = bindgen(256)
  ;horizontal_clt = bytarr(256,colorbarWidth)
  ;for i = 0, colorbarWidth-1 do horizontal_clt(0,i) = clt
  ;vertical_clt = transpose(horizontal_clt)
  ;vertical = congridi(vertical_clt, colorbarWidth, Ymag * fullsteps)
  ;vertical = congridi(bindgen(1,nColors), colorbarWidth, Ymag * fullsteps)
  vertical = congrid(bindgen(1,nColors), colorbarWidth, Ymag * fullsteps,/interp)
;??  vertical = congrid(findgen(1,nColors), colorbarWidth, Ymag * fullsteps,/interp)
endif else begin
;  vertical = congrid(bindgen(1,nColors), 1, fullsteps,/interp)
  vertical = bindgen(1,nColors)
; ####? invert?
  if not isLW then vertical = nColors - 1 - vertical ; inverted gray scale
  vertical = bytscl(vertical, top=255)
endelse

;*****************************************************************************
; PLOT EACH PITCH ANGLE
plotcount = 1

for k = 0L, numPAs-1 do begin
  EorI = 0
;  read, 'Electrons (0) or Ions (1)? ', EorI
  read, 'Sensor ID number? ', sensorx
  EorI = sensorX mod 2
  read,'Min and Max log flux to display (range -7:-1) [-6,-2]? ', $
	minlogflux, maxlogflux
  CASE EorI OF
    0:BEGIN
      FLX = FLUX_elec
      PAs = data.pa_elec
      EIstring = 'ELECTRON'
      sens = data.sensors_elec
      END
    1:BEGIN
      FLX = FLUX_ions
      PAs = data.pa_ions
      EIstring = 'ION'
      sens = data.sensors_ions
      END
  ENDCASE

  Yb = float(Tside - (Ymag * fullsteps + spacing) * plotcount)
  if (plotPA and (plotcount eq 2)) then Yb = Yb - plotPAheight
	; bottom edge coordinate

;*****************************************************************************
; BUILD FLUX IMAGE
; ### depends on fixed sensor order
  w = where(sens(*,0) eq sensorx, wcount)
  if (wcount le 0) then begin
;    print,'Sensor ', sensorx,' not found in beginning sweep. Plot skipped'
    print,'Sensor ', sensorx,' not found in beginning sweep.'
;    goto, next_plot
    PAx = 0
  endif else begin
    PAx = w(0)
    w = where(sens(PAx,*) ne sensorx, wcount)
    if (wcount gt 0) then begin
;      print,'Sensor order changes for sensor ', sensorx,'.  Plot skipped'
      print,'Sensor order changes for sensor ', sensorx,'.'
;      goto, next_plot
    endif
  endelse
  displayflux1 = fltarr(nsteps, timesize) ; kludge to get 2-D array
  for j = 0L, timeSize - 1 do begin
    w = where(sens(*,j) eq sensorx, wcount)
    if (wcount gt 0) then begin
;;    displayflux1(*,j) = reverse(alog10(flx(PAx,*,j) > 1.e-9))
;    displayflux1(*,j) = alog10(flx(PAx,*,j) > 1.e-9)
      displayflux1(*,j) = alog10(flx(w(0),*,j) > 1.e-9)
    endif else begin
      displayflux1(*,j) = alog10((flx(0,*,j)*0.0) > 1.e-9) ; ### set to no display
    endelse
  endfor ; j
if isPostscript then begin
  displayflux = displayflux1 ; no rescaling for Postscript
endif else begin
;### could replace preceding lines with 
;;  displayflux1 = alog10(reform(flx(PAx,*,*),nsteps,timesize) > 1.e-9)
;  displayflux1=alog10(float(flx(PAx,*,*),nsteps,timesize) > 1.e-9)
;###  displayflux1 = reverse(displayflux1, 0) ; low to high energy order

  ; scale flux, convert to bytes, and plot
  ; linear image expansion of Xmag by Ymag using bilinear interpolation
;  displayflux = congridi(displayflux1, Ymag * nsteps, Xmag * timesize)
;  displayflux = polywarp(displayflux1, Ymag * nsteps, Xmag * timesize)
;  displayflux = rot_int(displayflux1, 0,3)

;###	could replace following lines with
  displayflux = rebin(displayflux1, Ymag*nsteps, Xmag*timesize,/sample)
;  displayflux = fltarr(Ymag * nsteps, Xmag * timesize)
;  for i = 0L, nsteps - 1 do $
;    for j = 0L, timesize - 1 do $
;      for iy = Ymag * i, Ymag * i + Ymag - 1 do $
;	 for jx = Xmag * j, Xmag * j + Xmag - 1 do $
;	   displayflux(iy, jx) = displayflux1(i,j)
endelse ; not isPostscript

; if ((min(displayflux) lt minlogflux) or $
;	(max(displayflux) gt maxlogflux)) then $
  if (max(displayflux) gt maxlogflux) then $
	print, 'Flux out of bounds in Displayflux for sensor', sensorX
  if ((not isPostscript) and (k eq 0)) then erase ; only on first panel
  displayFlux3 = bytscl(displayflux, min=minlogflux, max=maxlogflux, $
			top=255) ; ?top=nColors?
  if (isLW) then displayFlux3 = 255b - displayFlux3 ; inverted since color 
						; tables are not used
  if (not isPostscript) then begin
    TV, TRANSPOSE(displayflux3), Lside + Xmag*first_time, Yb + Ymag*firststep
  endif else begin ; Postscript
    if isFixedSize then begin
      print, 'Maximum size of plot in device coordinates: ', Xmag*timesize, $
	Ymag*nsteps
      read, 'Input desired fixed size (scales will be wrong)? ', Xfixed, Yfixed
      TV, TRANSPOSE(displayflux3),Lside + Xmag*first_time, Yb + Ymag*firststep, $
	xsize=Xfixed, ysize=Yfixed
    endif else begin
      TV, TRANSPOSE(displayflux3),Lside + Xmag*first_time, Yb + Ymag*firststep, $
	xsize=Xmag*timesize, ysize=Ymag*nsteps
    endelse
  endelse
;*****************************************************************************
; LABEL Y-AXES AND PUT IN COLOR BAR
; X-loc of color bar allowing for text
;  xcolorbar = !d.x_size-3-8-4-!d.x_ch_size*2-3-tickLength-colorbarWidth
  xcolorbar = Rside + !d.x_ch_size*1
  if not isPostscript then begin
    tv, vertical, xcolorbar, Yb	; plot color bar
  endif else begin
    tv, vertical, xcolorbar, Yb, $
	xsize=colorbarWidth, ysize=Ymag*fullSteps
  endelse
  fluxdecade = Ymag * fullsteps / (maxlogflux - minlogflux)
  for i = fix(minlogflux), fix(maxlogflux) do begin
    tickheight = Yb + fluxdecade * (i - minlogflux)
    plots, [xcolorbar + colorbarWidth, xcolorbar + colorbarWidth + tickLength],$
	[tickheight, tickheight], color=colour, /device ; plot ticks
    xyouts, xcolorbar + colorbarWidth + tickLength + 3, $
	tickheight - !d.y_ch_size/2.0, $
	'10!U'+string(i,'(I2)')+'!N', charsize=smallfontsize, color=colour, $
	/device
;	'10!E'+string(i,'(I2)')+'!N', charsize=smallfontsize, color=colour, $
;	/device
  endfor ; map through flux label

  energydecade = Ymag * fullsteps / (eVhigh - eVlow)
  for i = eVlow, eVhigh do begin
    tickheight = Yb + energydecade * (i - eVlow)
    plots, [Lside - tickLength, Lside], [tickheight, tickheight], $
	color=colour, /device ;plot ticks
    xyouts, Lside - tickLength - 1, tickheight - !d.y_ch_size/2.0, $
	'10!U'+string(i,'(I1)')+'!N', charsize=smallfontsize, color=colour, $
	/device, alignment=1.0 ; right justify
;	'10!E'+string(i,'(I1)')+'!N', charsize=smallfontsize, color=colour, $
;	/device, alignment=1.0 ; right justify
  endfor ; map through energy label

  Ymid = Yb + 0.5 * Ymag * fullsteps
;  Ymid = Yb + Ymag * fullsteps ; use with orientation=270 (from top)
;  Ymid = Yb ; use with orientation=90
;  xyOUTs,!d.x_ch_size*2.,Ymid,EIstring+string(PAs(PAx,0,0),'(F5.0)')+' deg.'+$
  xyOUTs,!d.x_ch_size*2.,Ymid,EIstring+string(PAs(PAx,0,0),'(F5.0)')+$
	string("260B)+'!c' + plotYTitle, $
	alignment=0.5, $
	charsize=smallfontsize, orientation=90, font=pfont,color=colour, /device
;###	; degrees symbol
;  xyOUTs, Lside-tickLength-!d.x_ch_size*2. -6, Ymid, plotYTitle, $
;	alignment=0.5, $
;	charsize=smallfontsize, orientation=90, font=pfont,color=colour, /device
  xyOUTs, !d.x_size, Ymid, colorbarYTitle, $
	alignment=0.5, $
	charsize=smallfontsize, orientation=90, font=pfont,color=colour, /device

  PLOTs, [Lside, Rside], [YB, YB], color=colour, /device
;   start at left edge of plot and draw line along bottom of plot

  FOR P = 0, n_elements(mins) - 1 DO BEGIN ; plot and label minute tick marks
    Xminutetick =  Lside + (mins(p) - BegT) * Xmag ; X coordinate of minute tick
    PLOTs, [Xminutetick, Xminutetick], [YB, YB - tickLength], $
	color=colour, /device ; mark bottom of minute tick mark
  endfor ; p

next_plot:

  if (plotPA and (plotcount eq 1)) then begin
    if (not isPostscript) then begin
      plotPAr = bytarr(plotPAheight,Xmag*timesize)
      plotPAr(PAs(PAx,0,timeNdx)/180.*plotPAheight, Xmag*timeNdx) = colour
      Yb = Yb - plotPAheight ; bottom edge coordinate
      TV, transpose(plotPAr), Lside, Yb
    endif else begin
      plotPAr = bytarr(plotPAheight,timesize)
      plotPAr(PAs(PAx,0,timeNdx)/180.*plotPAheight, timeNdx) = colour
      Yb = Yb - plotPAheight ; bottom edge coordinate
      TV, transpose(plotPAr), Lside, Yb, $
	xsize=Xmag*timesize, ysize=plotPAheight
    endelse
  endif ; plotPA

  plotcount = plotcount + 1

ENDFOR ; PA

;*****************************************************************************
; PUT UP HEADERS
if (hlapi.satid eq 'L') then STRTITLE1 = 'DE-2 LAPI Spectrograms' else $
		STRTITLE1 = 'DE-1 HAPI Spectrograms'
STRTITLE2 = 'Date: ' + dmy_fromjd(hlapi.yrday) + $
	'   Day: ' + STRING(hlapi.yrday, format='(I5)') + $
	'   Orbit # ' + STRING(FIX(hlapi.orbit), format='(I4)')
;space = 4. * !d.y_ch_size ; minimum 2
space = 2
xyOUTs, !d.x_size/2.0, Tside + space + 2. * !d.y_ch_size, STRTITLE1+'!c!I'+ $
	strTitle2+'!N', alignment=0.5, charsize=bigfontsize, color=COLOUR, /device
;xyOUTs, Lside, Tside + space, STRTITLE2, $
;	alignment=0.5, charsize=bigfontsize, color=COLOUR, /device

;*****************************************************************************
; LABEL X-AXIS
;if (Yb lt Bside) then begin
;  print, 'Yb too small', Yb
;  goto, errordest
;endif

YB = YB - 2
;;PLOTs, [Lside, Rside], [YB, YB], color=colour, /device
;; ; start at left edge of plot and draw line along bottom of plot
 
;FOR ZZ = 0, 6 DO begin
;  Yb1 = YB - 2. * !d.y_ch_size - (!d.y_ch_size+2) * ZZ
;  xyOUTs, 0, YB1, LABELS(ZZ), $
;	charsize=fontsize, color=COLOUR, /device ; plot labels on left side
;endfor ; zz
  Yb1 = YB - 2. * !d.y_ch_size
;  xyOUTs, 0, YB1, Labels(0)+'!c'+Labels(1)+'!c'+Labels(2)+'!c'+Labels(3)+'!c'+$
;	Labels(4)+'!c'+Labels(5)+'!c'+Labels(6), alignment=0.0, $
  xyOUTs, 0, YB1, 'UT!cIL!cMLT!cLST!cLat!cLon!cAlt', alignment=0.0, $
	charsize=fontsize, color=COLOUR, /device ; plot labels on left side

; ### call axis function in newer version
FOR P = 0L, n_elements(mins) - 1 DO BEGIN ; plot and label minute tick marks
  Xminutetick =  Lside + (mins(p) - BegT) * Xmag ; X coordinate of minute tick
;;  PLOTs, [Xminutetick, Xminutetick], [YB, YB - tickLength], $
;;	color=colour, /device ; mark bottom of minute tick mark

  MLT = ea(MINS(P)).MLT ; MLT
  LST = ea(MINS(P)).LST
;;  Yb1 = YB - 2. * !d.y_ch_size - (!d.y_ch_size+2) * 0
  Yb1 = YB - 2. * !d.y_ch_size
  xyOUTs, Xminutetick, YB1, $
	charsize=fontsize, color=COLOUR, /device, alignment=0.5, $
	'  ' + STRMID(timeconvert(time(mins(p))), 0, 8) + '!c' + $		; time
	STRING(ea(MINS(P)).ILAT, format='(F7.2)') + '!c' + $		; IL
	'  ' + STRING(FIX(MLT), format='(I2)') + ':' + $
	STRING(FIX((MLT MOD 1) * 60), format='(I2.2)') + '!c' + $	; MLT
	'  ' + STRING(FIX(LST), format='(I2)') + ':' + $
	STRING(FIX((LST MOD 1) * 60), format='(I2.2)') + '!c' + $	; LST
	STRING(ea(MINS(P)).LAT, format='(F7.2)') + '!c' + $		; Lat
	STRING(ea(MINS(P)).LON, format='(F7.1)') + '!c' + $		; Long
	STRING(FIX(ea(MINS(P)).ALT), format='(I7)')			; Alt

;  Yb1 = YB - 2. * !d.y_ch_size - (!d.y_ch_size+2) * 1
;  xyOUTs, Xminutetick, YB1, $
;	charsize=fontsize, color=COLOUR, /device, alignment=0.5, $
;	STRING(ea(MINS(P)).ILAT, format='(F7.2)')		; IL

;  Yb1 = YB - 2. * !d.y_ch_size - (!d.y_ch_size+2) * 2
;  MLT = ea(MINS(P)).MLT ; MLT
;  xyOUTs, Xminutetick, YB1, $
;	charsize=fontsize, color=COLOUR, /device, alignment=0.5, $
;	'  ' + STRING(FIX(MLT), format='(I2)') + ':' + $
;	STRING(FIX((MLT MOD 1) * 60), format='(I2.2)')		; MLT

;  Yb1 = YB - 2. * !d.y_ch_size - (!d.y_ch_size+2) * 3
;  LST = ea(MINS(P)).LST
;  xyOUTs, Xminutetick, YB1, $
;	charsize=fontsize, color=COLOUR, /device, alignment=0.5, $
;	'  ' + STRING(FIX(LST), format='(I2)') + ':' + $
;	STRING(FIX((LST MOD 1) * 60), format='(I2.2)')		; LST

;  Yb1 = YB - 2. * !d.y_ch_size - (!d.y_ch_size+2) * 4
;  xyOUTs, Xminutetick, YB1, $
;	charsize=fontsize, color=COLOUR, /device, alignment=0.5, $
;	STRING(ea(MINS(P)).LAT, format='(F7.2)')		; Lat

;  Yb1 = YB - 2. * !d.y_ch_size - (!d.y_ch_size+2) * 5
;  xyOUTs, Xminutetick, YB1, $
;	charsize=fontsize, color=COLOUR, /device, alignment=0.5, $
;	STRING(ea(MINS(P)).LON, format='(F7.1)')		; Long

;  Yb1 = YB - 2. * !d.y_ch_size - (!d.y_ch_size+2) * 6
;  xyOUTs, Xminutetick, YB1, $
;	charsize=fontsize, color=COLOUR, /device, alignment=0.5, $
;	STRING(FIX(ea(MINS(P)).ALT), format='(I7)')		; Alt

ENDfor ; p

xyOUTs,  Lside, YB - 2. * !d.y_ch_size - (!d.y_ch_size+2) * 8, $
	'Processed: ' + !STIME, $
	charsize=fontsize, color=COLOUR, /device
errordest:
if isPostscript then begin
  device, /close
;  spawn, 'plots idl.ps/del'
endif
END
