pro interpIndices, x_original, x_new, nearest, nextNearest
; compute nearest and nextNearest indices for matching x_new values to closest
; x_original values

; 2020Mar6 RMC
forward_function interpValues

n_x_new = n_elements(x_new)
n_x_original = n_elements(x_original)
nearest = long(x_new*0L)
nextNearest = nearest
count = 0L
while (count le (n_x_new-1)) do begin
    diff = abs(x_new(count) - x_original)
    mindiff = min(diff, near)
    if (near eq 0L) then begin
      nextNear = 1L
    endif else begin
      if (near eq (n_x_original - 1L)) then begin
        nextNear = n_x_original - 2L
      endif else begin ; find next smallest difference
        if (diff(near-1) lt diff(near+1)) then nextNear = near - 1L $
					  else nextNear = near + 1L
      endelse
    endelse   
    nearest(count) = near
    nextNearest(count) = nextNear
    count = count + 1L
endwhile
return
end ; interpIndices
function interpValues, x_original, y_original, x_new, nearest,nextNearest,y_wrap
; This program takes the 2 points nearest the desired point, and fits a 
; straight line through them, and interpolates or extrapolates to the desired
; point.
; problems:  this program assumes range of data 0 - y_wrap
; not for data that runs from -180 to 180 (for example)

; added kludge to work around IDL limit on size of loop variable
; Robert.M.Candey@gsfc.nasa.gov; 1995 Feb 1
; split into two parts for speedup; 1995 March 27

if (n_elements(y_wrap) le 0) then y_wrap = 0.
n_x_new = n_elements(x_new)
y_new = float(x_new*0.)

count = 0L
while (count le (n_x_new-1)) do begin
; check for wrap of cyclic data
    x1 = x_original(nearest(count)) & x2 = x_original(nextNearest(count))
    y1 = y_original(nearest(count)) & y2 = y_original(nextNearest(count))
    if (y_wrap ne 0) then begin
      if ( (y2 - y1) gt (y_wrap * 0.20) ) then y2 = y2 - y_wrap else $
      if ( (y1 - y2) gt (y_wrap * 0.20) ) then y2 = y2 + y_wrap
    endif
    y_new(count) = y1 + ((y2-y1)/(x2-x1)) * (x_new(count) - x1)
    count = count + 1L
endwhile
if (y_wrap ne 0) then begin
  w = where (y_new gt y_wrap, wc) & if (wc gt 0) then y_new(w) = y_new(w)-y_wrap
  w = where (y_new lt 0, wc)      & if (wc gt 0) then y_new(w) = y_new(w)+y_wrap
endif
return, y_new
end ; interpValues
