; NASA Goddard Space Flight Center, Code 632	Robert.M.Candey@gsfc.nasa.gov
; 1995 Jan 13
; Possible way to call reduce_satm.pro in batch mode, could also process one 
; file at a time from a command file with $ idl reduce_satm, ...

satm_file = ''
openr, lun, 'data.list', /get_lun
while not eof(lun) do begin
  readf, lun, satm_file, yrday, start_hour, start_min, start_sec, $
                 end_hour, end_min, end_sec
  reduce_satm, satm_file, yrday, start_hour, start_min, start_sec, $
                 end_hour, end_min, end_sec, flux_type=2 ; number flux
endwhile
free_lun, lun
end

; create another list of xdr files to process for a particular study with times 
;   of interest
xdr_file = ''
old_xdr_file = ''
openr, lun, 'xdr.list', /get_lun
while not eof(lun) do begin
  readf, lun, xdr_file, yrday, start_hour, start_min, start_sec, $
                 end_hour, end_min, end_sec
  if (xdr_file ne old_xdr_file) then restore, xdr_file
	 ; save time if same file as before
  old_xdr_file = xdr_file
; assuming on same day, compute beg and end times in millisec of day
  begTime = (((start_hour*60L)+start_min)*60L+start_sec)*1000L
  endTime = (((end_hour*60L)+end_min)*60L+end_sec)*1000L
  w = where((ea.time ge begTime) and (ea.time le endTime), wc)
  if (wc gt 0) then begin
    calc_flux, HLAPI, EA(w), flux_option, flux_type, energy, flux_elec, $
                 flux_ions, fluxOne_elec, fluxOne_ions
    doMyAnalysis, hlapi,ea(w),energy,flux_elec,flux_ions
  endif
endwhile
free_lun, lun
end
