function hlapi_interp, x_original, y_original, x_new, y_wrap
; This program takes the 2 points nearest the desired point, and fits a 
; straight line through them, and interpolates or extrapolates to the desired
; point.
; problems:  this program assumes range of data 0 - y_wrap
; not for data that runs from -180 to 180 (for example)

; added kludge to work around IDL limit on size of loop variable
; Robert.M.Candey@gsfc.nasa.gov; 1995 Feb 1

if (n_elements(y_wrap) le 0) then y_wrap = 0.
n_x_new = n_elements(x_new)
;y_new = fltarr(n_x_new)
y_new = float(x_new*0.)

maxloop = 50000L ; what is IDL's limit?
bigtop = long(n_x_new/maxloop)
smtop = maxloop
count = -1L
for bigloop = 0L, bigtop do begin
  if (bigloop eq bigtop) then smtop = n_x_new mod maxloop
  for smloop = 0L, smtop-1 do begin
    count = count + 1L ; or bigloop*maxloop + smloop
    if (count ge n_x_new) then message, 'Error in loop counting in hlapi_interp'
    diff = abs(x_new(count) - x_original)
    mindiff = min(diff, nearest)
    if (nearest eq 0) then begin
      nextnear = 1   
    endif else begin
      if (nearest eq (n_elements(x_original)-1)) then begin
        nextnear = n_elements(x_original) - 2
      endif else begin ; find next smallest difference
        if (diff(nearest-1) lt diff(nearest+1)) then nextnear = nearest - 1 $
						else nextnear = nearest + 1
      endelse
    endelse   
; check for wrap of cyclic data
    x1 = x_original(nearest) & x2 = x_original(nextnear)
    y1 = y_original(nearest) & y2 = y_original(nextnear)
    if (y_wrap ne 0) then begin
      if ( (y2 - y1) gt (y_wrap * 0.20) ) then y2 = y2 - y_wrap else $
      if ( (y1 - y2) gt (y_wrap * 0.20) ) then y2 = y2 + y_wrap
    endif
;    y_new(count) = y1 + ((y2-y1)/(x_original(nextnear)-x_original(nearest))) * $
;				 (x_new(count) - x_original(nearest))
    y_new(count) = y1 + ((y2-y1)/(x2-x1)) * (x_new(count) - x1)
  endfor ; smloop
endfor ; bigloop

if (y_wrap ne 0) then begin
  w = where (y_new gt y_wrap, wc) & if (wc gt 0) then y_new(w) = y_new(w)-y_wrap
  w = where (y_new lt 0, wc)      & if (wc gt 0) then y_new(w) = y_new(w)+y_wrap
endif

return, y_new
end
