pro sort_sens_lapi, counts, sensors, PA, EA, hlapi, debug=debug
; SORT_SENSORS.PRO sorts the sensor arrays into a specified order
;  by Bobby Candey (Atlantic Research) and Norman Reese (STx)
;  1990 October 31
; updated Robert.M.Candey@gsfc.nasa.gov; 1995 Feb 1
; changed to better handle mismatched number of ion and elec sensors; 
;     1999 Sept 1, BC
;
; if not keyword_set (debug) then debug=0

; sort roughly by pitch angle with electrons first followed by ions
; electron_order = [ 0,28, 8,24, 4,10,18,14,22,12,20,16, 6,26, 2]
;      ion_order = [ 1,29, 9,25, 5,11,19,15,23,13,21,17, 7,27, 3]

sensorOrder = [ 0,15,14,29, 4,19,12,27, 2,17, 5,20, 9,24, 7,   $
               22,11,26, 6,21,10,25, 8,23, 3,18,13,28, 1,16,30] 
wBadSensors = where( sensors gt 30, wbadc )
if (wBadc gt 0) then sensors(wBadSensors) = 30

for i=0L, hlapi.nsweeps-1 do begin
   sensor_sort = sensors(*,i)
   PA_sort = PA(*,i)
   sensorOrderIndex  = sort ( sensorOrder (sensor_sort) )
   sensor_sort = sensor_sort( sensorOrderIndex )
   PA_sort = PA_sort( sensorOrderIndex )
   wElec = where( ((sensor_sort mod 2) eq 0) and (sensor_sort lt 30), n_elec )
   wIons = where( ((sensor_sort mod 2) eq 1) and (sensor_sort lt 30), n_ions )

; *** error handling for sensors
;   if (n_elec gt hlapi.nsensors_elec) then begin
   if (n_elec ne hlapi.nsensors_elec) then begin
     print,"Error in # of Electron Sensors(",ea(i).time,"):",sensor_sort(wElec)
;      wElec = wElec(0:hlapi.nsensors_elec-1)
      wElec = wElec(0:((hlapi.nsensors_elec-1) < (n_elec-1)))
      n_elec = n_elements(wElec)
   endif
;   if (n_ions gt hlapi.nsensors_ions) then begin
   if (n_ions ne hlapi.nsensors_ions) then begin
     print,"Error in # of Ion Sensors(",ea(i).time,"):",sensor_sort(wIons)
;      wIons = wIons(0:hlapi.nsensors_Ions-1)
      wIons = wIons(0:((hlapi.nsensors_Ions-1) < (n_ions-1)))
      n_ions = n_elements(wIons)
   endif
;   print,sensor_sort(wElec),sensor_sort(wIons)
   if (n_elec gt 0) then begin
      EA(i).sensors_elec = sensor_sort( wElec )
      EA(i).PA_elec      = PA_sort( wElec )
      for k = 0L, hlapi.nsteps-1 do $
;	EA(i).counts_elec(*,k) = counts(SensorOrderIndex(wElec), k, i)
	EA(i).counts_elec(0:n_elec-1,k) = counts(SensorOrderIndex(wElec), k, i)
   endif
   if (n_ions gt 0) then begin
      EA(i).sensors_ions = sensor_sort( wIons )
      EA(i).PA_ions      = PA_sort( wIons )
      for k = 0L, hlapi.nsteps-1 do $
;	EA(i).counts_ions(*,k) = counts(SensorOrderIndex(wIons), k, i)
	EA(i).counts_ions(0:n_ions-1,k) = counts(SensorOrderIndex(wIons), k, i)
   endif
endfor ; i

return
end ; sort_sens_lapi
