function expand_PA, PA
; wrap pitch angles to 0:360 from 0:180
delta_PA = PA - shift(PA, 1) ; ignore first value
delta_PA(0) = 0
PA1 = PA
if (n_elements(PA) le 1) then return, PA1
if (delta_PA(1) lt 0) then begin ; start clockwise
  wPA = where(delta_PA gt 0,wc)
  if (wc gt 0) then PA1(wPA) = 360. - PA1(wPA)
endif else begin ; start counterclockwise
  wPA = where(delta_PA lt 0,wc)
  if (wc gt 0) then PA1(wPA) = 360. - PA1(wPA)
endelse
return, PA1
end ; expand_PA    
pro dist_fcn_idl, flux,PA_array,eV, par_tic,perp_tic,dfgrd_log,igrd,energy_vel,$
		par, perp, distfcn, hlapi, big
; Reads *.eco or *.ico distribution function file created by currtsplt
;    and convert to evenly spaced grid of vperp and vpar for contouring
; Writtened 19 August 1988 by Bobby Candey (ORI)
; Changed to use distribution function from load_hlapi  1990 May  BC
; add jury rig to ignore field-aligned detectors - removed
; add HAPI capability  15 May 1990 BC
; modified to work with IDL version 2   31 October 1991 BC
; changed for new HAPI/LAPI variables in structures; 1992 Nov 2, BC (Hughes STX)
; in particular, order of energy and sensors were switched
; removed old gridding routine and reforming arrays; BC, 13 Nov 1992

  flux1 = flux
  PA_array1 = PA_array
  PA_size = size(PA_array)
  if (PA_size(0) gt 1) then for i = 0,PA_size(1)-1 do $
    PA_array1(i,*,*) = expand_PA(PA_array1(i,*,*)); convert to 0:360 instead of 0:180

flux_size = size(flux1)
nSensors = flux_size(1)
nSteps = flux_size(2)
if (flux_size(0) gt 2) then nSweeps = flux_size(3) else nSweeps = 1

npt = nsensors * nsteps	* nSweeps	; Number of input data points
par = dblarr(npt)		; Parallel particle velocity or energy (x)
perp = dblarr(npt)		; Perpendicular particle velocity or energy (y)
distfcn = fltarr(npt)		; Distribution Function (z)
npar = 20		; Number of regular grid points in parallel direction
read, 'How many grid lines? ', npar
nperp = npar	; Number of regular grid points in perpendicular direction
par_tic = findgen(npar)		; Array of regular grid points in parallel (rx)
perp_tic = findgen(nperp)	; Array of regular grid points (ry)

degrad = 3.14159d0 / 180.d0
Me = 9.109534d-31	; mass of electron in kg
Mp = 1.6726485d-27	; mass of proton in kg
J_per_eV = 1.6021892d-19	; convert Joules from eV
Qm = 2.0d0 * J_per_eV / Me	; choose electrons

count = 0
if (energy_vel eq 1) then begin ; velocity space
  V_eV = sqrt(eV * Qm) * 0.001d0	; km/s
endif else begin ; energy space in eV
  V_eV = eV
endelse  
for i = 0, nSensors-1 do begin
  for j = 0, nSteps-1 do begin
    for k = 0, nSweeps-1 do begin

      if (strUpCase(hlapi.satID) ne 'H') then begin
        par(count) = V_eV(j) * cos(PA_array1(i,k) * degrad)
        perp(count) = V_eV(j) * sin(PA_array1(i,k) * degrad)
      endif else begin ; HAPI
        par(count) = V_eV(j) * cos(PA_array1(i,j,k) * degrad)
        perp(count) = V_eV(j) * sin(PA_array1(i,j,k) * degrad)
      endelse

      distfcn(count) = flux1(i,j,k)
      count = count + 1
    endfor ; k
  endfor ; j
endfor ; i

  if (strUpCase(hlapi.satID) ne 'H') then begin
  ; set up mirror image also
    par = [par, par]
    perp = [perp, -perp]
    distfcn = [distfcn, distfcn]
  endif ; LAPI

; Fill grid point arrays with evenly spaced values
; Could make them equal?
  minp = min([min(par),min(perp)])
  maxp = max([max(par),max(perp)])
  par_tic = par_tic * ((maxp - minp) / (npar - 1)) + minp
  perp_tic = perp_tic * ((maxp - minp) / (nperp - 1)) + minp
;  par_tic = par_tic * ((max(par) - min(par)) / (npar - 1)) + min(par)
;  perp_tic = perp_tic * ((max(perp) - min(perp)) / (nperp - 1)) + min(perp)

  big = float(fix(max(alog10(distfcn(where(distfcn ne 0.)))))) + 2. < 0. 
;  big = float(fix(max(alog10(distfcn(where(distfcn ne 0.)))))) 
;  big = -9.
; -9. ;1.e-9 ; ### check
  triangulate, par, perp, triangles, bounds ; , repeats=rep ; no need to check
;  print, 'Repeats found: ', n_elements(rep)
;  deltaPar = (maxp - minp) / (npar - 1)
;  deltaPerp = (maxp - minp) / (nperp - 1)
  deltaPar = (maxp - minp) / (npar - 1) * 1.0001
  deltaPerp = (maxp - minp) / (nperp - 1) * 1.0001
;;  small = 10.^(float(fix(min(alog10(distfcn)))) - 1.) ; convert top to minimum
  dfgrd = trigrid(par, perp, distfcn, triangles, [deltaPar, deltaPerp], $
	[minp, minp, maxp, maxp], missing=10.^big,/quintic)
;;	$ , missing=small)
if (energy_vel eq 1) then begin
  !x.title = 'V parallel, km/s (down positive)'
  !y.title = 'V perpendicular, km/s'
endif else begin
  !x.title = 'E parallel, eV (down positive)'
  !y.title = 'E perpendicular, eV'
endelse

dfgrd_log = dfgrd
w = where(dfgrd le 0., wc)
if (wc gt 0) then begin
  dfgrd_log(w) = big
  w = where(dfgrd gt 0., wc)
  if (wc gt 0) then dfgrd_log(w) = alog10(dfgrd(w))
endif else begin
  dfgrd_log = alog10(dfgrd)
endelse
!c = 0
return
end

if (n_elements(flux_type) gt 0) then $
	if (strpos(strupcase(flux_type),'DIST') ge 0) then goto, jump
calc_flux, hlapi, ea, 4, flux_type, energy, flux_elec, flux_ions, $
	fluxOne_elec, fluxOne_ions
jump:

last = n_elements(ea)-1
read, 'Energy (0) or velocity (1) space? ', energy_vel
print,'0 = ',timeconvert(ea(0).time),'  ',last,' = ',timeconvert(ea(last).time)
;read,'What time range (120, 121)',time1, time2

read,'Start time ? (hh, mm, ss) ',hr0,min0,sec0
msec0 = hhmmss2ms(hr0,min0,sec0)
starttime = min (abs(ea.time - msec0),time1)
if (strUpCase(hlapi.satID) eq 'H') then begin
  read,'End time ? (hh, mm ,ss) ',hr1,min1,sec1
  msec1 = hhmmss2ms(hr1,min1,sec1)
  endtime = min (abs(ea.time - msec1),time2)
  print,time1,' ',timeconvert(ea(time1).time),' ',time2,' ',timeconvert(ea(time2).time)
endif else begin ; HAPI
  print,time1,' ',timeconvert(ea(time1).time)
endelse

  !p.title = string(hlapi.yrday,format="(I5)") + ' ' + $
	timeconvert(ea(time1).time) + ' UT' + $
	string(hlapi.orbit,format="(' Orbit=',I5)") + $
	string(ea(time1).ILat,format="(' IL=',F5.1)") + $
	string(ea(time1).MLT,format="(' MLT=',F4.1)") + $
	string(ea(time1).ALT,format="(' Alt=',F6.0)")
if (strUpCase(hlapi.satID) ne 'H') then begin
  flux = flux_elec(*,*,time1)
  PA_array = ea(time1).PA_elec
  sensor_array = ea(time1).sensors_elec
  doFieldAligned = 1
;   read, 'Process field-aligned detectors (yes=1, no=0)? ', doFieldAligned
  if not doFieldAligned then begin
    wnotFieldAligned = where((sensor_array gt 3) and (sensor_array lt 26), wc)
    if (wc gt 0) then begin
      flux = flux(wnotFieldAligned,*)
      PA_array = PA_array(wnotFieldAligned)
      sensor_array = sensor_array(wnotField_aligned)
    endif
  endif ; no Field-Aligned sensors
; remove 15 degree sensor if flux is 0.0 at 5 eV or sensor eq 24 (25 for ions)
  nsteps = n_elements(energy)
  wc = 0
  if (hlapi.yrday ge 81327) then wBad = where(flux(*,nsteps-1) eq 0.0, wc)
; or if (hlapi.yrday ge 81327) then wBad = where(sensor_array eq 24, wc)
  if (wc gt 0) then begin
    wnotBad = where(flux(*,nsteps-1) ne 0.0, wc)
; or  wnotBad = where(sensor_array ne 24, wc)
    if (wc gt 0) then begin
      flux = flux(wnotBad,*)
      PA_array = PA_array(wnotBad)
      sensor_array = sensor_array(wnotBad)
    endif
  endif
endif else begin ; HAPI
  flux = flux_elec(*,*,time1:time2)
  PA_array = ea(time1:time2).PA_elec
  sensor_array = ea(time1:time2).sensors_elec
endelse

PA_size = size(PA_array)
eV = energy
maxeV = 3000.
read, 'Maximum energy to plot? ', maxeV
loweV = where(energy le maxeV, wc) ; 5 eV to 3 keV
if (wc gt 0) then begin
  flux = flux(*,loweV,*)
  if (strUpCase(hlapi.satid) eq 'H') then PA_array = PA_array(*,loweV,*)
  eV = eV(loweV)
endif

dist_fcn_idl, flux,PA_array,eV, par_tic,perp_tic,dfgrd_log,igrd,energy_vel,$
		par, perp, dist_fcn, hlapi, big
df = dfgrd_log
w = where(dfgrd_log lt big, wc)
if (wc gt 0) then begin
  small = float(fix(min(df(w)))) - 1.
  large = float(fix(max(df(w)))) + 1.
endif else begin
  small = float(fix(min(df))) - 1.
  large = float(fix(max(df))) + 1.
endelse
; only needed for surface without max_value
w = where(dfgrd_log ge big, wc)
if (wc gt 0) then df(w) = small
delta = 0.25
nlevels = (large - small - 2.) / delta
while (nlevels gt 30) do begin
  delta = delta * 2.
  nlevels = (large - small - 2.) / delta
endwhile

contour_even, par_tic, perp_tic
;print,'contour,dfgrd_log,par_tic,perp_tic,/follow,nlevels=30,max_value=big-1.'
print,'contour,dfgrd_log,par_tic,perp_tic,/follow,$'
print,	'levels=findgen(nlevels)*delta+small+1.,max_value=large'
print, 'surface, df, par_tic,perp_tic, ax=30, az=30'
;print, 'surface, dfgrd_log, par_tic,perp_tic, ax=30, az=30;,max_value=big-1.'
;contour,dfgrd_log,par_tic,perp_tic,/follow,levels=-23.+findgen(30)*0.25,$
contour,dfgrd_log,par_tic,perp_tic,/follow,$
	levels=findgen(nlevels)*delta+small+1.,max_value=large
;contour,dfgrd_log,par_tic,perp_tic,/follow,nlevels=30, $
;	max_value=big-1.
; ,/spline or spline=0.005
oplot, par, perp, psym = 3 ; periods
oplot, par, -perp, psym = 3 ; periods
;surface, dfgrd_log, par_tic,perp_tic, ax=30, az=30;,max_value=big-1.
;surface, df, par_tic,perp_tic, ax=30, az=30
end
