;edi_hk_survey.pro
;
;Created: Mark Chutter, UNH
;Dec. 15, 2000 
;
;Modified:
;Dec. 18, 2000 MWC added space for Optics and Energy; adjusted layout
;May   8, 2001 MWC added check for files with no valid packets.
;June 25, 2001 MWC now uses actual data times
;
; Calling Interface:
; f_type      char    (i)     Type of data as text (RDM, FTP)
; f_name      char    (i)     data file name
;
; Keywords:
;
;This reads a day long EDI HK file and plots some quantities of
;interest.
;IF the EDI_HK_SV_OUT_DIR environment variable is set, the PS plots
;are placed in that directory; otherwise the plots are put in the
;users home directory

PRO hk_survey_read, f_type, f_name, start_str, num_hours, stamp, hk_sv

survey_data = {$
                time:0.D, $
                bmag:0., $
                bcone:0., $
                fgmr:0U, $
                evt1:0U, $
                evt2:0U, $
                gdu1_pc:0., $
                gdu2_pc:0., $
                submo:0, $
                pacmo:0U, $
                modid:0, $
                optcs:0, $
                enrgy:0., $
                cdtyp:0, $
                despn:0, $
                extrp:0, $
                nsamp:0, $
                count:0 $
              }

stamp = ''

num_points =  700 * num_hours
hk_sv = replicate(survey_data, num_points)
midnight = '00:00:00.000000'

pick_cvt_str_sec, start_str, start_time
start_time_d = double(start_time[0]) + double(start_time[1]) * 1.D-6
end_time = start_time[0] + num_hours * 3600L

pick_hk_init, f_type, f_name
s = pickst_hk(start_str, stat)

;this is to skip past bad packets
WHILE s.status EQ -1 DO s = pickst_hk(start_str, stat)
IF s.status LT 0 THEN return

pick_cvt_sec_vax, s.packet_time, time_str

time_parts = str_sep(time_str, ' ')
stamp = 'CL' + strtrim(string(s.sc_id), 2) + '_' + time_parts[0]

time_index = 0L
count = 1
new_file = 0
WHILE new_file GE 0 DO BEGIN
    new_file = new_file + 1
    WHILE s.status GT -1 AND s.packet_time[0] LT end_time AND $
      count LT num_points-1 DO BEGIN

        hk_sv[time_index].time = double(s.packet_time[0]) + $
          double(s.packet_time[1]) * 1.D-6 - $
          start_time_d

        hk_sv[time_index].fgmr = s.fgmr
        hk_sv[time_index].submo = s.submo
        hk_sv[time_index].pacmo = s.pacmo
        hk_sv[time_index].modid = s.modid
        hk_sv[time_index].optcs = s.optcs
        IF s.enrgy EQ 0 THEN hk_sv[time_index].enrgy = 1.0 $
        ELSE hk_sv[time_index].enrgy = 0.5
        hk_sv[time_index].cdtyp = s.cdtyp
        hk_sv[time_index].despn = s.despn
        hk_sv[time_index].extrp = s.extrp
        hk_sv[time_index].nsamp = s.nsamp
        hk_sv[time_index].evt1 = s.gdu1.evt1
        hk_sv[time_index].evt2 = s.gdu2.evt1
        hk_sv[time_index].gdu1_pc = s.gdu1.gdpc
        hk_sv[time_index].gdu2_pc = s.gdu2.gdpc
        hk_sv[time_index].bmag = s.bmag
        hk_sv[time_index].bcone = s.bcone
        count = count + 1
        time_index = time_index + 1

        s = pickn_hk(stat)
    ENDWHILE

    IF f_type EQ 'rdm' AND new_file EQ 2 THEN BEGIN
        dot_pos = strpos(f_name, '.1')
        IF dot_pos GT -1 THEN BEGIN
            search_name = f_name
            strput, search_name, '.3', dot_pos
            next_hk_file = findfile(search_name)
            IF n_elements(next_hk_file) GT 0 THEN BEGIN
                IF next_hk_file[0] NE '' THEN BEGIN
                    pick_close
                    pick_hk_init, f_type, next_hk_file
                    s = pickn_hk(stat)
                ENDIF
            ENDIF
        ENDIF
    ENDIF ELSE IF f_type EQ 'rdm' AND new_file EQ 1 THEN BEGIN
        dot_pos = strpos(f_name, '.1')
        IF dot_pos GT -1 THEN BEGIN
            search_name = f_name
            strput, search_name, '.2', dot_pos
            next_hk_file = findfile(search_name)
            IF n_elements(next_hk_file) GT 0 THEN BEGIN
                IF next_hk_file[0] NE '' THEN BEGIN
                    pick_close
                    pick_hk_init, f_type, next_hk_file
                    s = pickn_hk(stat)
                ENDIF
            ENDIF
        ENDIF
    ENDIF ELSE new_file = -1
ENDWHILE
pick_close
END

