PRO hi_res_pp, date, data_flag = data_flag, ps = ps, png = png, $
               cdf_in_dir = cdf_in_dir, plot_dir = plot_dir

;hi_res_pp.pro
;
;Created: Mark Chutter, UNH
;July 22, 2002
;
;Modified:
;Oct.  1, 2002 MWC added ambient GEOS counts and anisotropy
;                  parameters; changed plot symbols and labels in
;                  preparation for the 3 hour plots world debut added
;                  amb_geos energy
;Mar. 11, 2004 MWC added check for having multiple MSF versions and
;                  changed output locations
;May  18, 2004 MWC updated edi_cdf_dir
;Jun. 28, 2004 MWC changed name of merged file from *PP* to *MP*
;July 21, 2005 MWC oops, I was setting the energy string incorrectly:
;                  get_amb_geos_0 set the energy to be 0.5 or 1 KeV
;Oct. 20, 2006 MWC changed Ambient to q0 for q0_counts
;Oct. 30, 2006 MWC changed location of unh_CDF directory
;May  23, 2007 MWC changed location of unh_CDF directory

;Calling Interface:
;date         string (i) 'YYYYMMDD'
;
;Keywords:
;data_flag is used to select which combination of 'Good','Caution',
;and 'Bad' data should be used.
;0 means use all (DEFAULT)
;1 means use 'good' and 'caution' data
;2 means use 'good' data only
;3 means make a plot for level 1, and 2
;9 means make a plot for level 0, 1, and 2
;ps will cause the output plot to be Postscript
;png if png and ps keywords are set, then make a PNG file of the plot
;

pp_plot_version = 'HR V1.18'

;CDFPATH is the directory for input CDFs
edi_cdf_dir = '/nfs/cluster4/unh_CDF/latest/'
IF edi_cdf_dir EQ '' THEN BEGIN
    print, 'CDFPATH environment variable is not defined'
    return
ENDIF
;usecdf_in _dir keyword to override output directory
IF keyword_set(cdf_in_dir) THEN edi_cdf_dir = cdf_in_dir

;PP_PLOT_PATH is the output directory
pp_plot_path = getenv('HI_RES_PP_PLOT_PATH')
IF pp_plot_path EQ '' THEN BEGIN
    print, 'PP_PLOT_PATH environment variable is not defined'
    return
ENDIF
;use plot_dir keyword to override output directory
IF keyword_set(plot_dir) THEN pp_plot_path = plot_dir
pp_plot_path = '/nfs/cl4/merged_pp/'

msf_dir = getenv('MSF_DIR')
IF msf_dir EQ '' THEN BEGIN
    print, 'MSF_DIR environment variable is not defined'
    return
ENDIF

edi_q0_dir = getenv('Q0_PATH')
IF edi_q0_dir EQ '' THEN BEGIN
    print, 'Q0_PATH environment variable is not defined'
    return
ENDIF

long_date = long(date);used to check Ambient GEOS validity
                      ;May 31, 2002 was first "good" day
start_time = '00:00:00'
tick_time = [0.D, 10800.D, 21600.D, 32400.D, 43200.D, $
             54000.D, 64800.D, 75600.D, 86400.D]
duration = 24
xtickv_val = dindgen(49) * 1800.D

file_type = 'msf'
out_name = strarr(8)

;make a little color table
mwc_color_table, plot_color
ww_color = plot_color[1]
ag_color = plot_color[5]

;set page size and spacing
xsize = 620. ; this should fit on A4 paper, 650 would be for US letter
ysize = 820.
start_x = 80.
stop_x = 540.
x_len = stop_x - start_x
n_plots = 7
y_gap = 0.2
top_space = 50
bottom_space = 100
rel_size = intarr(n_plots)

plot_struct = {$
                xstyle:0, $
                xticks:0, $
                xminor:0, $
                xticklen:0., $
                xtickname:strarr(7), $
                xtickv:dblarr(7), $
                ystyle:0, $
                yticks:0, $
                yminor:0, $
                yticklen:0., $
                ytitle:'      ' $
              }

plot_defs = replicate(plot_struct, n_plots)

;data_quality is which combination of "Good","Caution", and "Bad"
;should be used
IF keyword_set(data_flag) THEN data_quality = data_flag $
ELSE data_quality = 0
;translate the date to 'YYMMDD' and find files
msf_date = strmid(date, 2, 6)
search_name = msf_dir + 'msf_*/' + msf_date + 'em*'
;msf_X will be '' if no file is found
msf_3 = findfile(search_name + '3',count = search_count)

filename_to_date_str, file_type, msf_3[search_count-1], date_str

;convert the start time from string to double time of day
start_hour = strmid(start_time, 0, 2)
start_hour_int = fix(start_hour)
stop_hour_int = start_hour_int + duration
start_time_d = double(start_hour_int)
stop_time_d = double(stop_hour_int) + 86400.D
start_str = date_str + ' '+ start_time

year_str = strmid(date, 0, 4)
month_str = strmid(date, 4, 2)
year = long(strmid(date, 0, 4))
month = long(strmid(date, 4, 2))
day = long(strmid(date, 6, 2))
cdf_epoch, epoch_midnight, year, month, day, 0, 0, 0, 0, /compute_epoch

;extract the data
;from EDI HK data
;extract_hk_b, file_type, msf_3[0], start_str, duration, stamp, hk_sv_3
hk_survey_read, file_type, msf_3[0], start_str, duration, stamp, hk_sv_3

;from EDI SCI data
q0_list = edi_q0_dir + 'c3_edi_q0_' + date + '_v*.cdf'
check_q0 = findfile(q0_list, count = file_count_q0)
IF file_count_q0 GT 0 THEN BEGIN
    len_name = strlen(check_q0[0])
    num_names = n_elements(check_q0)
    cdf_version = intarr(num_names)
    FOR kk = 0, num_names-1 DO $
      cdf_version[kk] = fix(strmid(check_q0[kk], len_name-6, 2))
    max_ver = max(cdf_version)
    where_max = where(max_ver EQ cdf_version)
    name_q0 = (check_q0[where_max])
    print, name_q0
    id_q0 = cdf_open(name_q0[0])
    cdf_control, id_q0, var = 'Epoch__C3_EDI_AMB', get_var_info = r1
    nrec1 = r1.maxrec+1
    cdf_varget, id_q0, 'q0_counts_CL3_1KeV', q0_counts, $;was Ambient
      rec_start = 0, rec_count = nrec1
    cdf_varget, id_q0, 'q0_counts_CL3_500eV', q0_counts_500, $;was Ambient
      rec_start = 0, rec_count = nrec1
    cdf_varget, id_q0, 'Epoch__C3_EDI_AMB', epoch_q0, $
      rec_start = 0, rec_count = nrec1
    q0_times = reform((epoch_q0 - epoch_midnight)/1000.d0) ; ssm
ENDIF ELSE BEGIN
    q0_times = [99998.D, 99999.D]
    q0_counts = [0., 0.]
    q0_counts_500 = [0., 0.]
ENDELSE

;from EDI PP CDF files
;make sure the CDF file exists
file_3 = edi_cdf_dir + 'c3/c3_mp_edi_' + date + '_v*.cdf'
check_3 = findfile(file_3, count = file_count_3)
IF file_count_3 GT 0 THEN BEGIN
    len_name = strlen(check_3[0])
    num_names = n_elements(check_3)
    cdf_version = intarr(num_names)
    FOR kk = 0, num_names-1 DO $
      cdf_version[kk] = fix(strmid(check_3[kk], len_name-13, 2))
    max_ver = max(cdf_version)
    where_max = where(max_ver EQ cdf_version)
    name_3 = (check_3[where_max])
    print, name_3
    id3 = cdf_open(name_3[0])
    cdf_control, id3, var = 'Epoch__C3_MP_EDI', get_var_info = r3
    nrec3 = r3.maxrec+1
    IF nrec3 GT 0 THEN BEGIN
        cdf_varget, id3, 'V_ed_xyz_gse__C3_MP_EDI', drift_velo_gse_3, $
          rec_start = 0, rec_count = nrec3
        cdf_varget, id3, 'Epoch__C3_MP_EDI', t_epoch3, $
          rec_start = 0, rec_count = nrec3
        cdf_varget, id3, 'Status__C3_MP_EDI', status3, $
          rec_start = 0, rec_count = nrec3
        IF n_elements(t_epoch3) GT 1 THEN BEGIN
            t_epoch3 = reform(t_epoch3)
            t_ssm_3 = reform((t_epoch3 - epoch_midnight)/1000.d0) ; ssm
        ENDIF
    ENDIF ELSE t_ssm_3 = 0.D
ENDIF

;get Ambient GEOS spin resolution data
get_amb_geos_0, 'msf', '/nfs/cluster/', date, '00:00:00', 24, 3, amb_geos, start_date

;adjust scale of total counts
total_ag = (amb_geos.total_counts)/10.

;adjust scale of param_0 and param_1
param_0 = (amb_geos.param_0 + 2.) * 45.
param_0 = (amb_geos.param_0 + 50.) * 1.8
w = where(param_0 GT 270., count)
IF count GT 0 THEN param_0[w] = 270.
w = where(param_0 LT -90., count)
IF count GT 0 THEN param_0[w] = -90.

param_1 = amb_geos.param_1 * 22.5
param_1 = amb_geos.param_1 * 0.9
w = where(param_1 GT 90., count)
IF count GT 0 THEN param_1[w] = 90.
w = where(param_1 LT -90., count)
IF count GT 0 THEN param_1[w] = -90.

;someone could get in trouble if they forget how different the
;ephemeris data can be for large seperation!
sp_stat = spaux_info(3, tick_time, 'ssm', date = date, $
                     rmag = rmag, $
                     local_time = local_time, $
                     invlat = invlat, $
                     maglat = maglat)

size_3 = size(t_ssm_3)

IF data_quality EQ 9 THEN BEGIN
    start_quality = 0
    stop_quality = 2
ENDIF ELSE IF data_quality EQ 3 THEN BEGIN
    start_quality = 1
    stop_quality = 2
ENDIF ELSE BEGIN
    start_quality = data_quality
    stop_quality = data_quality
ENDELSE

FOR i_quality = start_quality, stop_quality DO BEGIN

;fill these with dummy data in case there is no data from the CDFs
    plot_time_3 = [0.D, 86400.D]
    drift_velo_gse_x_rel_3 = [-1.e+31, -1.e+31]
    drift_velo_gse_y_rel_3 = [-1.e+31, -1.e+31]
    drift_velo_gse_z_rel_3 = [-1.e+31, -1.e+31]
    drift_vel_3 = [-1.e+31, -1.e+31]
    drift_v_lambda_3 = [-1.e+31, -1.e+31]
    drift_v_phi_3 = [-1.e+31, -1.e+31]
    
;set plot time for data relative to the start time if there is data
    IF size_3[0] NE 0 THEN BEGIN
        w_3 = where(t_ssm_3 GE start_time_d AND t_ssm_3 LT stop_time_d AND $
                    status3[0, *] GE i_quality AND $
                    status3[0, *] LT 3, count_3)
        num_points_3 = count_3
        IF count_3 GT 1 THEN BEGIN
            plot_time_3 = t_ssm_3[w_3] - start_time_d
            drift_velo_gse_x_rel_3 = drift_velo_gse_3[0, w_3]
            drift_velo_gse_y_rel_3 = drift_velo_gse_3[1, w_3]
            drift_velo_gse_z_rel_3 = drift_velo_gse_3[2, w_3]
            drift_vel_3 = sqrt(drift_velo_gse_x_rel_3^2 + $
                               drift_velo_gse_y_rel_3^2 + $
                               drift_velo_gse_z_rel_3^2)
            drift_v_lambda_3 = asin(drift_velo_gse_z_rel_3 / $
                                    drift_vel_3) / !dtor
            drift_v_phi_3 = atan(drift_velo_gse_y_rel_3, $
                                 drift_velo_gse_x_rel_3) / !dtor
            w_phi = where(drift_v_phi_3 LT -90., phi_3_count)
            IF phi_3_count GT 0 THEN $
              drift_v_phi_3[w_phi] = drift_v_phi_3[w_phi] + 360.
        ENDIF
    ENDIF ELSE count_3 = 0
    
    IF keyword_set(ps) THEN out_dev = 1 $
    ELSE out_dev = 0
    IF (out_dev eq 0) THEN BEGIN
        window, xsize = xsize, ysize = ysize
    ENDIF

    out_name[0] = pp_plot_path + year_str + '/' + month_str + $
                  '/EDI_00_03_' + date
    out_name[1] = pp_plot_path + year_str + '/' + month_str + $
                  '/EDI_03_06_' + date
    out_name[2] = pp_plot_path + year_str + '/' + month_str + $
                  '/EDI_06_09_' + date
    out_name[3] = pp_plot_path + year_str + '/' + month_str + $
                  '/EDI_09_12_' + date
    out_name[4] = pp_plot_path + year_str + '/' + month_str + $
                  '/EDI_12_15_' + date
    out_name[5] = pp_plot_path + year_str + '/' + month_str + $
                  '/EDI_15_18_' + date
    out_name[6] = pp_plot_path + year_str + '/' + month_str + $
                  '/EDI_18_21_' + date
    out_name[7] = pp_plot_path + year_str + '/' + month_str + $
                  '/EDI_21_24_' + date

    IF i_quality EQ 2 THEN out_name[*] = out_name[*]
    IF i_quality EQ 1 THEN out_name[*] = out_name[*] + '_Caution'
    IF i_quality EQ 0 THEN out_name[*] = out_name[*] + '_All'
    
    rel_size = [2, 2, 3, 3, 4, 1, 1]
    layout_plots, rel_size, y_gap, ysize, top_space, bottom_space, plot_loc
    plot_loc[1, 4] = 650;make gap between 3 and 24 hour plots

;set the tick information
    plot_defs[*].xstyle = 1
    plot_defs[*].xticks = 1
    plot_defs[0].xticks = 6
    plot_defs[*].xminor = 1
    plot_defs[0].xminor = 3
    plot_defs[5].xminor = 0
    plot_defs[*].xticklen = -0.05
    plot_defs[*].xtickname[*] = ' '
    plot_defs[*].ystyle = 1
    plot_defs[0].yticks = 2
    plot_defs[1].yticks = 3
    plot_defs[2].yticks = 4
    plot_defs[3].yticks = 4
    plot_defs[4].yticks = 2
    plot_defs[5].yticks = 1
    plot_defs[6].yticks = 2
    plot_defs[*].yminor = 1
    plot_defs[4].yminor = 0
    plot_defs[5].yminor = 0
    plot_defs[6].yminor = 0
    plot_defs[*].yticklen = -0.01
    
    FOR interval = 0, 7 DO BEGIN
        
        IF (out_dev eq 1) THEN BEGIN
            ag_color = plot_color[4]
            set_plot, 'ps'
            device, filename =  out_name[interval] + '.ps', $
              portrait = 1, font_size = 14, /inches, xsize = 8, ysize = 10, $
              xoffset = 0, yoffset = 0.4, /color
        ENDIF
        IF (out_dev eq 0) AND interval GT 0 THEN BEGIN
            print, 'Press RETURN for next page'
            next_page = ''
            read, next_page
            erase
        ENDIF
        !noeras = 1
        
        IF i_quality EQ 2 THEN title = 'EDI SC3 ' + date
        IF i_quality EQ 1 THEN title = 'EDI SC3 ' + date + ' Good and Caution'
        IF i_quality EQ 0 THEN title = 'EDI SC3 ' + date + ' All Data'
        xyouts, 0.35, .97, /normal, size = 1.5, title
        
        CASE interval OF
            0:BEGIN
                xrange = [0.D, 10800.D]
            END
            1:BEGIN
                xrange = [10800.D, 21600.D]
            END
            2:BEGIN
                xrange = [21600.D, 32400.D]
            END
            3:BEGIN
                xrange = [32400.D, 43200.D]
            END
            4:BEGIN
                xrange = [43200.D, 54000.D]
            END
            5:BEGIN
                xrange = [54000.D, 64800.D]
            END
            6:BEGIN
                xrange = [64800.D, 75600.D]
            END
            7:BEGIN
                xrange = [75600.D, 86400.D]
            END
        ENDCASE
        xtickv = xtickv_val[interval*6:interval*6+6]
        e_str = ' '
        w = where(amb_geos.time GE xrange[0] AND $
                  amb_geos.time LT xrange[1] AND $
                  amb_geos.energy GE 0, ag_e_count)
        IF ag_e_count GT 0 THEN BEGIN
            IF amb_geos[w[0]].energy EQ 1.0 THEN e_str = '1 KeV' $
            ELSE e_str = '500 eV'
        ENDIF

        FOR i = 0, n_plots-1 DO BEGIN
            plot_time = plot_time_3
            ylog = 0 ;default is linear, set ylog for individual cases
            psym = 4
            
            CASE i OF
                6:BEGIN
                    plot_time = [0.D, 86400.D]
                    plot_data = [-1.e+31, -1.e+31]
                    psym = 3
                    ylog = 1
                    yrange = [1., 1.e4]
                    ytickname = ['1.e0', '1.e2', '1.e4']
                    ytickv = [1.e0, 1.e2, 1.e4]
                    ytitle = 'GDU1!CEvt1'
                END
                5:BEGIN
                    ylog = 1
                    plot_time = [0.D, 86400.D]
                    plot_data = [-1.e+31, -1.e+31]
                    psym = 3    ;1
                    yrange = [1., 1000.]
                    ytickv = [1, 1000]
                    ytickname = ['WW', 'AG']
                    ytitle = 'FGM B!CSci'
                END
                4:BEGIN
                    ylog = 1
                    plot_data = drift_vel_3
                    yrange = [0.1, 200.]
                    ytickname = ['1.', '10.', '100.']
                    ytickv = [1., 10., 100.]
                    ytitle = 'V (km/s)'
                END
                3:BEGIN
                    plot_data = drift_v_lambda_3
                    yrange = [-90., 90.]
                    ytickname = ['-90.', '-45', '0.', '45.', '90.']
                    ytickv = [-90., -45., 0., 45., 90.]
                    ytitle = '!4k!X!IV!Mx!N (GSE)'
                END
                2:BEGIN
                    plot_data = drift_v_phi_3
                    yrange = [-90., 270.]
                    ytickname = ['-90.', '0.', '90.', '180.', '270.']
                    ytickv = [-90., 0., 90., 180., 270.]
                    ytitle = '!4u!X!IV!Mx!N (GSE)'
                END
                1:BEGIN
                    ylog = 1
                    plot_time = [0.D, 86400.D]
                    plot_data = [-1.e+31, -1.e+31]
                    yrange = [1., 1000.]
                    ytickname = ['1.', '10.', '100.', '1000.']
                    ytickv = [1., 10., 100., 1000.]
                    ytitle = 'FGM B'
                END
                0:BEGIN
                    plot_time = [0.D, 86400.D]
                    plot_data = [-1.e+31, -1.e+31]
                    yrange = [0., 180.]
                    ytitle = 'B Cone'

                    IF sp_stat NE 0 THEN BEGIN
                        prep_tick_ephem_spaux, 3, xtickv, 'ssm', date = date
                        xtickformat = 'tick_ephem_mwc'
                    ENDIF
                    xtickv = xtickv - start_time_d
                END
                
            ENDCASE
            
                                ;dummy_time and dummy_data are used to
                                ;make an initial plot without any data
            dummy_time = xrange
            dummy_data = [0., 0.]
            
            IF i EQ 0 THEN $
              plot, dummy_time, dummy_data, /nodata, /normal, $
              xstyle = plot_defs[i].xstyle, $
              xticks = plot_defs[i].xticks, $
              xminor = plot_defs[i].xminor, $
              xticklen = plot_defs[i].xticklen, $
              xtickv = xtickv, $
              xtickformat = xtickformat, $
              xrange = xrange, $
              ystyle = plot_defs[i].ystyle, $
              yticks = plot_defs[i].yticks, $
              yminor = plot_defs[i].yminor, $
              yticklen = plot_defs[i].yticklen, $
              ytitle = ytitle, $
              ylog = ylog, $
              yrange = yrange, $
              psym = psym, $
              pos = [start_x/xsize, plot_loc[0, i]/ysize, $
                     stop_x/xsize, plot_loc[1, i]/ysize]
            
            IF i GT 0 AND i LT 5 THEN $
              plot, dummy_time, dummy_data, /nodata, /normal, $
              xstyle = plot_defs[i].xstyle, $
              xticks = plot_defs[i].xticks, $
              xminor = plot_defs[i].xminor, $
;              xticklen = plot_defs[i].xticklen, $
              xtickname = plot_defs[i].xtickname, $
              xrange = xrange, $
              ystyle = plot_defs[i].ystyle, $
              yticks = plot_defs[i].yticks, $
              yminor = plot_defs[i].yminor, $
              yticklen = plot_defs[i].yticklen, $
              ytickname = ytickname, $
              ytickv = ytickv, $
              ytitle = ytitle, $
              ylog = ylog, $
              yrange = yrange, $
              psym = psym, $
              pos = [start_x/xsize, plot_loc[0, i]/ysize, $
                     stop_x/xsize, plot_loc[1, i]/ysize]

            IF i GE 5 THEN $
              plot, dummy_time, dummy_data, /nodata, /normal, $
              xstyle = plot_defs[i].xstyle, $
              xticks = plot_defs[i].xticks, $
              xminor = plot_defs[i].xminor, $
;              xticklen = plot_defs[i].xticklen, $
              xtickname = plot_defs[i].xtickname, $
              xrange = [0.D, 86400.D], $
              ystyle = plot_defs[i].ystyle, $
              yticks = plot_defs[i].yticks, $
              yminor = plot_defs[i].yminor, $
              yticklen = plot_defs[i].yticklen, $
              ytickname = ytickname, $
              ytickv = ytickv, $
              ytitle = ytitle, $
              ylog = ylog, $
              yrange = yrange, $
              psym = psym, $
              pos = [start_x/xsize, plot_loc[0, i]/ysize, $
                     stop_x/xsize, plot_loc[1, i]/ysize]
            
            IF i EQ 1 THEN BEGIN
                IF long_date GE 20020531 THEN BEGIN
                    w = where(hk_sv_3.modid EQ 5 OR $
                              hk_sv_3.modid EQ 21, fgm_count)
                    IF fgm_count GT 1 THEN $
                      oplot, hk_sv_3[w].time, hk_sv_3[w].bmag, $
                      psym = 3, symsize = 0.25
                ENDIF ELSE BEGIN
                    w = where(hk_sv_3.modid EQ 5, fgm_count)
                    IF fgm_count GT 1 THEN $
                      oplot, hk_sv_3[w].time, hk_sv_3[w].bmag, $
                      psym = 3, symsize = 0.25
                ENDELSE
            ENDIF
            IF i EQ 0 THEN BEGIN
                IF long_date GE 20020531 THEN BEGIN
                    w = where(hk_sv_3.modid EQ 5 OR $
                              hk_sv_3.modid EQ 21, fgm_count)
                    IF fgm_count GT 1 THEN $
                      oplot, hk_sv_3[w].time, hk_sv_3[w].bcone, $
                      psym = 3, symsize = 0.25
                ENDIF ELSE BEGIN
                    w = where(hk_sv_3.modid EQ 5, fgm_count)
                    IF fgm_count GT 1 THEN $
                      oplot, hk_sv_3[w].time, hk_sv_3[w].bcone, $
                      psym = 3, symsize = 0.25
                ENDELSE
            ENDIF
            IF i EQ 2 THEN BEGIN
                oplot, [0.D, 86400.D], [90., 90.], linestyle = 2
                IF count_3 GT 2 THEN oplot, plot_time, plot_data, $
                  color = ww_color, psym = psym, symsize = 0.25
                w = where(param_0 NE 90., count)
                IF count GT 1 THEN $
                  oplot, amb_geos[w].time, param_0[w], $
                  color = ag_color, psym = psym, symsize = 0.25
            ENDIF
            IF i EQ 3 THEN BEGIN
                oplot, [0.D, 86400.D], [0., 0.], linestyle = 2
                IF count_3 GT 2 THEN oplot, plot_time, plot_data, $
                  color = ww_color, psym = psym, symsize = 0.25
                w = where(param_1 NE 0., count)
                IF count GT 1 THEN $
                  oplot, amb_geos[w].time, param_1[w], $
                  color = ag_color, psym = psym, symsize = 0.25
            ENDIF
            IF i EQ 4 THEN BEGIN
                IF count_3 GT 2 THEN oplot, plot_time, plot_data, $
                  color = ww_color, psym = psym, symsize = 0.25
                oplot, amb_geos.time, total_ag, $
                  color = ag_color, psym = psym, symsize = 0.25
            ENDIF
            IF i EQ 5 THEN BEGIN
                IF long_date GE 20020531 THEN BEGIN
                    w = where(hk_sv_3.modid EQ 5 OR $
                              hk_sv_3.modid EQ 21, fgm_count)
                    IF fgm_count GT 1 THEN $
                      oplot, hk_sv_3[w].time, hk_sv_3[w].bmag, psym = 3
                ENDIF ELSE BEGIN
                    w = where(hk_sv_3.modid EQ 5, fgm_count)
                    IF fgm_count GT 1 THEN $
                      oplot, hk_sv_3[w].time, hk_sv_3[w].bmag, psym = 3
                ENDELSE
                w = where(hk_sv_3.modid EQ 5, ww_count)
                IF ww_count GT 1 THEN BEGIN
                    dummy = fltarr(ww_count)
                    dummy[*] = 1.
                    oplot, hk_sv_3[w].time, dummy, $
                      color = ww_color, psym = 4
                ENDIF
                w = where(hk_sv_3.modid EQ 21, ag_count)
                IF ag_count GT 1 THEN BEGIN
                    dummy = fltarr(ag_count)
                    dummy[*] = 1000.
                    oplot, hk_sv_3[w].time, dummy, $
                      color = ag_color, psym = 4
                ENDIF
            ENDIF
            IF i EQ 6 THEN BEGIN
                w = where(hk_sv_3.modid EQ 5, ww_count)
                IF ww_count GT 1 THEN BEGIN
                    oplot, hk_sv_3[w].time, hk_sv_3[w].evt1, $
                      color = ww_color, psym = psym, symsize = 0.25
                ENDIF
                w = where(hk_sv_3.modid EQ 21, ag_count)
                IF ag_count GT 1 THEN BEGIN
                    oplot, hk_sv_3[w].time, hk_sv_3[w].evt1, $
                      color = ag_color, psym = psym, symsize = 0.25
                ENDIF
                oplot, xrange, [1.e0, 1.e0], color = plot_color[2], thick = 5
                oplot, xrange, [0.8e4, 0.8e4], color = plot_color[2], thick = 5
                oplot, [xrange[0], xrange[0]], [1.e0, 1.e4], $
                  color = plot_color[2], thick = 2
                oplot, [xrange[1], xrange[1]], [1.e0, 1.e4], $
                  color = plot_color[2], thick = 2
            ENDIF
            IF i EQ 2 THEN BEGIN
                axis, yaxis = 0, yticklen = -0.01, yminor = -1, $
                  yrange = [-90., 270.], $
                  ytickname = ['-90.', '0.', '90.', '180.', '270.'], $
                  ytickv = [-90., 0., 90., 180., 270.], $
                  ytitle = '!4u!X!IV!Mx!N (GSE)', $
                  color = ww_color
                axis, yaxis = 1, yticklen = -0.01, yminor = -1, $
                  ytickname = ['-100.', '-50.', ' 0.', ' 50.', ' 100.'], $
                  ytitle = '(0-180)/!4r!X', $
                  color = ag_color
            ENDIF
            IF i EQ 3 THEN BEGIN
                axis, yaxis = 0, yticklen = -0.01, yminor = -1, $
                  yrange = [-90., 90.], $
                  ytickname = ['-90.', '-45', '0.', '45.', '90.'], $
                  ytickv = [-90., -45., 0., 45., 90.], $
                  ytitle = '!4k!X!IV!Mx!N (GSE)', $
                  color = ww_color
                axis, yaxis = 1, yticklen = -0.01, yminor = -1, $
                  ytickname = ['-100.', '-50.', ' 0.', ' 50.', ' 100.'], $
                  ytitle = '(FA-90)/!4r!X', $
                  color = ag_color
            ENDIF
            IF i EQ 4 THEN BEGIN
                axis, xaxis = 1, xticks = 6, xminor = 3, $
                  xtickname = [' ', ' ', ' ', ' ', ' ', ' ', ' '], $
                  xticklen = -0.05, xtickv = xtickv
                axis, yaxis = 0, yticklen = -0.01, yminor = -1, $
                  yticks = 2, $
                  yrange = [0.1, 200.], $
                  ytickname = ['1.', '10.', '100.'], $
                  ytickv = [1., 10., 100.], $
                  ytitle = 'V (km/s)', $
                  color = ww_color
                axis, yaxis = 1, yticklen = -0.01, yminor = -1, $
                  ytickname = ['  10.', ' 100.', ' 1000.'], $
                  ytitle = 'Av. cts/samp ' + e_str, $
                  /ylog, ystyle = 1, yticks = 2, $
                  yrange = [0.1, 200.], ytickv = [1., 10., 100.], $
                  color = ag_color
            ENDIF
        ENDFOR

        axis_xtickname = ['00:00', '04:00', '08:00', '12:00', $
                          '16:00', '20:00', '24:00']
        axis, xaxis = 1, xticks = 6, xminor = 4, $
          xtickname = axis_xtickname, $
          xticklen = -0.1

        xyouts, 10/xsize, (plot_loc[0, 0]-19)/ysize, $
          'UT!CLT!CINV!CR!CMLAT!CSC3', /normal

;create a time stamp and place it on the right side.
        plot_stamp

;create bestarg version stamp and place it on the right side
        bestarg_version_stamp

        xyouts, .995, 0.25, /norm, /noclip, orient = 90.0, align = 0.5, $
          pp_plot_version, color = plot_color[8], size = 0.5

        xyouts, 0.2, 0.12,/norm,  orientation = 55., 'NOT FOR PUBLICATION', $
          size = 5, color = plot_color[0], charthick = 2.

        IF (out_dev eq 1) THEN BEGIN
            device, /close
        ENDIF
    
    ENDFOR

    IF keyword_set(png) AND keyword_set(ps) THEN BEGIN
        FOR interval = 0, 7 DO BEGIN
            temp_name = out_name[interval]
            command_string = 'convert -density 288 -geometry 25% -sharpen 3 ' + temp_name + '.ps ' + temp_name + '.png'
            spawn, command_string
            command_string = 'rm ' + temp_name + '.ps'
            spawn, command_string
        ENDFOR
    ENDIF
ENDFOR

IF (out_dev eq 1) THEN BEGIN
    set_plot, 'x'
ENDIF

END

