PRO get_amb_geos_0, f_type, file_path, date, start_time_str, duration, $
                    sc_id, amb_geos, start_date

;get_amb_geos
;
;Created: Mark Chutter, UNH
;Feb. 7, 2002 
;
;Modified:
;Mar. 13, 2002 MWC had parallel and anti switched for GDU1
;Sep. 25, 2002 MWC added total counts and 2 anisotropy parameters to
;                  the output structure
;Oct.  1, 2002 MWC the par, perp, and anti have been replaced by pitch
;                  angles of 0, 90, and 180; param_1 corrected
;Oct.  4, 2002 MWC added energy
;Nov.  6, 2002 MWC subtract TMR from time
;Nov. 18, 2002 MWC added duration argument
;Mar. 25, 2003 MWC added theta correction, put back BM for ftp type
;Feb.  2, 2005 MWC new operations make it useful to have a fill value
;                  for directions with no counts, e.g., there will be
;                  no perp counts when firing only at 0 and 180 pitch
;                  angle
;Feb. 22, 2005 MWC get energy from HK data
;Feb. 24, 2005 MWC added submo for identifying burst mode data
;Apr.  3, 2005 MWC added calibration options and half the counts from
;                  NM to equalize with BM
;Apr.  4, 2005 MWC oops, halved BM counts, not NM
;May  10, 2005 MWC D1 on SC3 started having a much lower response
;                  than D2 in 2005 intermittently.  When this occurs,
;                  the counts from D1 have been set to -999
;Nov. 27, 2007 MWC removed some extraneous code before submission to archive
;
;Calling Interface:
;f_type          char (i)     Type of data as text (RDM, FTP)
;f_name          char (i)     data file name
;date            char (i)     string of the form: 'YYYYMMDD'
;start_time_str  char (i)     string of the form: 'HH:MM:SS'
;num_hours       int  (i)     number of hours or minutes to plot
;
;Keywords:
;
COMMON amb_geos, time_1_0, time_2_0, time_90, time_1_180, time_2_180, $
  data29_1_0, data29_1_90, data29_1_180, $
  data29_2_0, data29_2_90, data29_2_180, $
  btime, bmag, bcone, energy, submo

SC3_low_d1 = 0 ;gets set if D1 on SC3 has counts much lower than D2

sc_str = strcompress(string(sc_id), /remove_all)

i = 0
survey_data = {$
              time:0.D, $
              energy:0., $
              bmag:0., $
              bcone:0., $
              submo:0, $
              data29_1_0:-1e31, $
              data29_1_90:-1e31, $
              data29_1_180:-1e31, $
              data29_2_0:-1e31, $
              data29_2_90:-1e31, $
              data29_2_180:-1e31, $
              total_counts:0., $ ;for both GDUs
              param_0:0., $     ;anisotropy parameter 0
              param_1:0. $      ;anisotropy parameter 1
              }

num_points =  700 * duration
amb_geos = replicate(survey_data, num_points)

month_array  = ["Jan","Feb","Mar","Apr","May","Jun",$
                "Jul","Aug","Sep","Oct","Nov","Dec"]

year = strmid(date, 0, 4)
month = strmid(date, 4, 2)
day = strmid(date, 6, 2)
start_date = day + '-' + month_array[month-1] + '-' + year
start_str = start_date + ' ' + start_time_str

pick_cvt_str_sec, start_str, start_time
start_time_d = double(start_time[0]) + double(start_time[1]) * 1.D-6
end_time = start_time[0] + duration * 3600L

f_type = strlowcase(f_type)
IF f_type EQ 'msf' THEN BEGIN
    find_edi_files, f_type, file_path, start_date, 'msf', n_sc, $
      sci_files, sc_id = sc_str
ENDIF ELSE BEGIN
    find_edi_files, f_type, file_path, start_date, 'nsd', n_sc, $
      sci_files, sc_id = sc_str
    find_edi_files, f_type, file_path, start_date, 'bsd', n_sc, $
      bsd_files, sc_id = sc_str
    find_edi_files, f_type, file_path, start_date, 'hkd', n_sc, $
      hk_files, sc_id = sc_str
ENDELSE

;first get the MSF or NM data, BM data is gotten later
pick_close
pick_init, f_type, sci_files[0]
IF f_type EQ 'msf' THEN s = pickst_sc(pid, start_str, stat, /get_hk_data) $
ELSE s = pickst_sc(pid, start_str, stat)
IF s.status GT 0 THEN BEGIN
    WHILE s.status GT 0 AND $
      s.hdr.packet_time[0] LT end_time[0] DO BEGIN

        pick_cvt_sec_vax, s.hdr.packet_time, data_time
        amb_geos[i].time = double(s.hdr.packet_time[0]) + $
          double(s.hdr.packet_time[1]) * 1.D-6 - start_time_d - 5.155521D
        IF f_type EQ 'msf' THEN BEGIN
            amb_geos[i].bmag = s.hk.bmag
            amb_geos[i].bcone = s.hk.bcone
            amb_geos[i].submo = s.hk.submo
            IF s.hk.enrgy EQ 0 THEN amb_geos[i].energy = 1.0 $
            ELSE amb_geos[i].energy = 0.5
        ENDIF
        IF s.hdr.science_mode EQ '15'x THEN BEGIN
            counts_1_0 = 0
            counts_1_90 = 0
            counts_1_180 = 0
            counts_2_0 = 0
            counts_2_90 = 0
            counts_2_180 = 0

            w_nonzero = where(s.pacmo0.amb_geos.data29_1 NE 0. OR $
                              s.pacmo0.amb_geos.data29_2 NE 0. OR $
                              s.pacmo0.amb_geos.theta NE 0., nonzero_count)
            IF nonzero_count GT 0 THEN BEGIN
                time = s.pacmo0.amb_geos[w_nonzero].time
                b_perp = s.pacmo0.amb_geos[w_nonzero].b_perp
                bz_gz = s.pacmo0.amb_geos[w_nonzero].bz_gz
                data29_1 = s.pacmo0.amb_geos[w_nonzero].data29_1
                data29_2 = s.pacmo0.amb_geos[w_nonzero].data29_2
                theta = s.pacmo0.amb_geos[w_nonzero].theta
                phi_g2 = s.pacmo0.amb_geos[w_nonzero].phi
                phi_tmp = 180. - phi_g2
                w = where(phi_tmp LT 0., ag_count)
                IF ag_count GT 0 THEN phi_tmp[w] = phi_tmp[w] + 360.
                phi_g1 = phi_tmp

;On SC3 detector 1 started having a much lower response than detector
;2 on startup in 2005.  When the response over a TMR for D1 is 1/5 the
;response of D2, the counts will be set to -999
                IF sc_id EQ 3 AND mean(data29_1) LT 0 THEN BEGIN
                    SC3_low_d1 = 1
                    data29_1[*] = 0
                ENDIF

                ;counts are accumulated over 8 BCIs in NM vs. 4 for BM
                IF s.hdr.sub_mode NE 5 THEN BEGIN
                    data29_1 = data29_1 / 2.
                    data29_2 = data29_2 / 2.
                ENDIF

                ;perpendicular counts
                w = where(b_perp GT 0, nsamp_1_90)
                nsamp_2_90 = nsamp_1_90
                IF nsamp_1_90 GT 0 THEN BEGIN
                    counts_1_90 = total(data29_1[w])
                    counts_2_90 = total(data29_2[w])
                ENDIF
            
                ;g1z fires in Bz direction:
                ;det 2 has 0 PA (_2_ quantities)
                ;det 1 has 180 PA (_1_ quantities)
                w = where(bz_gz EQ 1 AND $
                          b_perp EQ 0, nsamp_1_180)
                nsamp_2_0 = nsamp_1_180
                IF nsamp_1_180 GT 0 THEN BEGIN
                    counts = s.pacmo0.amb_geos[w].data29_1
                    counts_1_180 = total(data29_1[w])
                    counts_2_0 = total(data29_2[w])
                ENDIF

                ;det 2 has 180 PA (_2_ quantities)
                ;det 1 has 0 PA (_1_ quantities)
                w = where(bz_gz EQ 0 AND $
                          b_perp EQ 0, nsamp_1_0)
                nsamp_2_180 = nsamp_1_0
                IF nsamp_1_0 GT 0 THEN BEGIN
                    counts_1_0 = total(data29_1[w])
                    counts_2_180 = total(data29_2[w])
                ENDIF

                c0 = float(counts_1_0 + counts_2_0)
                nsamp_0 = float(nsamp_1_0 + nsamp_2_0)
                c0_bar = c0 / nsamp_0 
                nsamp_0_sq = nsamp_0 * nsamp_0
                IF c0 LT 25. THEN c0_adjust = 25. / nsamp_0_sq $
                ELSE c0_adjust = c0 / nsamp_0_sq
                
                c90 = float(counts_1_90 + counts_2_90)
                nsamp_90 = float(nsamp_1_90 + nsamp_2_90)
                c90_bar = c90 / nsamp_90
                nsamp_90_sq = nsamp_90 * nsamp_90
                IF c90 LT 25. THEN c90_adjust = 25. / nsamp_90_sq $
                ELSE c90_adjust = c90 / nsamp_90_sq
                
                c180 = float(counts_1_180 + counts_2_180)
                nsamp_180 = float(nsamp_1_180 + nsamp_2_180)
                c180_bar = c180 / nsamp_180
                nsamp_180_sq = nsamp_180 * nsamp_180
                IF c180 LT 25. THEN c180_adjust = 25. / nsamp_180_sq $
                ELSE c180_adjust = c180 / nsamp_180_sq
                
                c_all_bar = (c0 + c90 + c180) / (nsamp_0 + nsamp_90 + nsamp_180)
                amb_geos[i].total_counts = c_all_bar
                
                amb_geos[i].param_0 = $
                  (c0_bar - c180_bar) / $
                  sqrt(c0_adjust + c180_adjust)
                amb_geos[i].param_1 = $
                  (0.5*(c0_bar + c180_bar) - c90_bar) / $
                  sqrt(0.25*(c0_adjust + c180_adjust) + c90_adjust)
                
                IF nsamp_1_0 GT 0 THEN $
                  amb_geos[i].data29_1_0 = counts_1_0 / $
                    nsamp_1_0
                IF nsamp_2_0 GT 0 THEN $
                  amb_geos[i].data29_2_0 = counts_2_0 / $
                    nsamp_2_0
                IF nsamp_1_90 GT 0 THEN $
              amb_geos[i].data29_1_90 = counts_1_90 / $
                nsamp_1_90
                IF nsamp_2_90 GT 0 THEN $
                  amb_geos[i].data29_2_90 = counts_2_90 / $
                    nsamp_2_90
                IF nsamp_1_180 GT 0 THEN $
                  amb_geos[i].data29_1_180 = counts_1_180 / $
                    nsamp_1_180
                IF nsamp_2_180 GT 0 THEN $
                  amb_geos[i].data29_2_180 = counts_2_180 / $
                    nsamp_2_180
            ENDIF
        ENDIF
        i = i + 1
        IF f_type EQ 'msf' THEN s = picka_sc(pid, stat, /get_hk_data) $
        ELSE s = picka_sc(pid, stat)
    ENDWHILE
ENDIF
IF f_type NE 'msf' THEN BEGIN ;get BM data
    n_sc = n_elements(bsd_files)
    IF n_sc EQ 1 THEN BEGIN
        IF bsd_files[0] NE ''  THEN BEGIN
            pick_close
            pick_init, f_type, bsd_files[0]    
            s = pickst_sc(pid, start_str, stat)
            IF s.status GT 0 THEN BEGIN
                WHILE s.status GT 0 AND $
                  s.hdr.packet_time[0] LT end_time[0] DO BEGIN
                    
                    pick_cvt_sec_vax, s.hdr.packet_time, data_time
                    amb_geos[i].time = double(s.hdr.packet_time[0]) + $
                      double(s.hdr.packet_time[1]) * 1.D-6 - start_time_d
                    
                    IF s.hdr.science_mode EQ '15'x THEN BEGIN
                        counts_1_0 = 0
                        counts_1_90 = 0
                        counts_1_180 = 0
                        counts_2_0 = 0
                        counts_2_90 = 0
                        counts_2_180 = 0

                        w_nonzero = where(s.pacmo0.amb_geos.data29_1 NE 0. OR $
                                          s.pacmo0.amb_geos.data29_2 NE 0. OR $
                                          s.pacmo0.amb_geos.theta NE 0., $
                                          nonzero_count)
                        IF nonzero_count GT 0 THEN BEGIN
                            time = s.pacmo0.amb_geos[w_nonzero].time
                            b_perp = s.pacmo0.amb_geos[w_nonzero].b_perp
                            bz_gz = s.pacmo0.amb_geos[w_nonzero].bz_gz
                            data29_1 = s.pacmo0.amb_geos[w_nonzero].data29_1
                            data29_2 = s.pacmo0.amb_geos[w_nonzero].data29_2
                            theta = s.pacmo0.amb_geos[w_nonzero].theta
                            phi_g2 = s.pacmo0.amb_geos[w_nonzero].phi
                            phi_tmp = 180. - phi_g2
                            w = where(phi_tmp LT 0., ag_count)
                            IF ag_count GT 0 THEN phi_tmp[w] = phi_tmp[w] + 360.
                            phi_g1 = phi_tmp

;counts are accumulated over 8 BCIs in NM vs. 4 for BM
                            IF s.hdr.sub_mode EQ 5 THEN BEGIN
                                data29_1 = data29_1 / 2.
                                data29_2 = data29_2 / 2.
                            ENDIF

                            ;perpendicular counts
                            w = where(b_perp GT 0, nsamp_1_90)
                            nsamp_2_90 = nsamp_1_90
                            IF nsamp_1_90 GT 0 THEN BEGIN
                                counts_1_90 = total(data29_1[w])
                                counts_2_90 = total(data29_2[w])
                            ENDIF
                            
                            ;g1z fires in Bz direction:
                            ;det 2 has 0 PA (_2_ quantities)
                            ;det 1 has 180 PA (_1_ quantities)
                            w = where(bz_gz EQ 1 AND $
                                      b_perp EQ 0, nsamp_1_180)
                            nsamp_2_0 = nsamp_1_180
                            IF nsamp_1_180 GT 0 THEN BEGIN
                                counts = s.pacmo0.amb_geos[w].data29_1
                                counts_1_180 = total(data29_1[w])
                                counts_2_0 = total(data29_2[w])
                            ENDIF
                            
                            ;det 2 has 180 PA (_2_ quantities)
                            ;det 1 has 0 PA (_1_ quantities)
                            w = where(bz_gz EQ 0 AND $
                                      b_perp EQ 0, nsamp_1_0)
                            nsamp_2_180 = nsamp_1_0
                            IF nsamp_1_0 GT 0 THEN BEGIN
                                counts_1_0 = total(data29_1[w])
                                counts_2_180 = total(data29_2[w])
                            ENDIF
                            
                            c0 = float(counts_1_0 + counts_2_0)
                            nsamp_0 = float(nsamp_1_0 + nsamp_2_0)
                            c0_bar = c0 / nsamp_0 
                            nsamp_0_sq = nsamp_0 * nsamp_0
                            IF c0 LT 25. THEN c0_adjust = 25. / nsamp_0_sq $
                            ELSE c0_adjust = c0 / nsamp_0_sq
                            
                            c90 = float(counts_1_90 + counts_2_90)
                            nsamp_90 = float(nsamp_1_90 + nsamp_2_90)
                            c90_bar = c90 / nsamp_90
                            nsamp_90_sq = nsamp_90 * nsamp_90
                            IF c90 LT 25. THEN c90_adjust = 25. / nsamp_90_sq $
                            ELSE c90_adjust = c90 / nsamp_90_sq
                            
                            c180 = float(counts_1_180 + counts_2_180)
                            nsamp_180 = float(nsamp_1_180 + nsamp_2_180)
                            c180_bar = c180 / nsamp_180
                            nsamp_180_sq = nsamp_180 * nsamp_180
                            IF c180 LT 25. THEN c180_adjust = 25. / $
                              nsamp_180_sq $
                            ELSE c180_adjust = c180 / nsamp_180_sq
                            
                            c_all_bar = (c0 + c90 + c180) / $
                                        (nsamp_0 + nsamp_90 + nsamp_180)
                            amb_geos[i].total_counts = c_all_bar
                        
                            amb_geos[i].param_0 = $
                              (c0_bar - c180_bar) / $
                              sqrt(c0_adjust + c180_adjust)
                            amb_geos[i].param_1 = $
                              (0.5*(c0_bar + c180_bar) - c90_bar) / $
                              sqrt(0.25*(c0_adjust + c180_adjust) + c90_adjust)
                            
                            amb_geos[i].data29_1_0 = counts_1_0 / $
                              nsamp_1_0
                            amb_geos[i].data29_2_0 = counts_2_0 / $
                              nsamp_2_0
                            amb_geos[i].data29_1_90 = counts_1_90 / $
                              nsamp_1_90
                            amb_geos[i].data29_2_90 = counts_2_90 / $
                              nsamp_2_90
                            amb_geos[i].data29_1_180 = counts_1_180 / $
                              nsamp_1_180
                            amb_geos[i].data29_2_180 = counts_2_180 / $
                              nsamp_2_180
                        ENDIF
                    ENDIF
                    i = i + 1
                    s = picka_sc(pid, stat)
                ENDWHILE
            ENDIF
        ENDIF
    ENDIF
    n_sc = n_elements(hk_files)
    IF n_sc EQ 1 THEN BEGIN
        IF hk_files[0] NE ''  THEN BEGIN
            pick_close
            pick_hk_init, f_type, hk_files[0]    
            s = pickst_hk(start_str, stat)
            IF s.status GT 0 THEN BEGIN
                WHILE s.status GT 0 AND $
                  s.packet_time[0] LT end_time[0] DO BEGIN
                    pick_cvt_sec_vax, s.packet_time, data_time
                    time = double(s.packet_time[0]) + $
                      double(s.packet_time[1]) * 1.D-6 - start_time_d
                    w = where(time EQ amb_geos.time, count)
                    IF count EQ 1 THEN BEGIN
                        amb_geos[w].bmag = s.bmag
                        amb_geos[w].bcone = s.bcone
                        amb_geos[w].submo = s.submo
                        IF s.enrgy EQ 0 THEN amb_geos[w].energy = 1.0 $
                        ELSE amb_geos[w].energy = 0.5
                    ENDIF
                    s = pickn_hk(stat)
                ENDWHILE
            ENDIF
        ENDIF
    ENDIF
ENDIF

btime = amb_geos.time
time_1_0 = btime
time_2_0 = btime
time_90 = btime
time_1_180 = btime
time_2_180 = btime

bmag = amb_geos.bmag
bcone = amb_geos.bcone
energy = amb_geos.energy
submo = amb_geos.submo
data29_1_0 = amb_geos.data29_1_0
data29_1_90 = amb_geos.data29_1_90
data29_1_180 = amb_geos.data29_1_180
data29_2_0 = amb_geos.data29_2_0
data29_2_90 = amb_geos.data29_2_90
data29_2_180 = amb_geos.data29_2_180

pick_close

IF SC3_low_d1 EQ 1 THEN BEGIN
    print, 'This data includes intervals where the counts'
    print, 'for D1 on SC3 have been set to -999 because of'
    print, 'dropout issues.'
ENDIF


END

