/******************************************************************************
                          timelib.h  -  description
                             -------------------
    begin                : Tue Jul 24 15:28:00 CEST 2001

    author               : Hans Vaith
    email                : hav@mpe.mpg.de
    copyright            : (C) 2001 by Max-Planck-Institut fr extra-
                           terrestrische Physik, D-85740 Garching

    Cluster-II EDI: header file for timelib.cpp
******************************************************************************
$Id: timelib.h,v 1.2 2005/04/07 08:34:43 hav Exp $
$Log: timelib.h,v $
Revision 1.2  2005/04/07 08:34:43  hav
more dev

Revision 1.1.1.1  2002/10/14 17:08:19  hav
c/c++ sources

Revision 1.2  2001/08/01 15:15:44  hav
new constants

Revision 1.1  2001/07/25 14:58:08  hav
Initial revision

******************************************************************************/

#ifndef _TIMELIB_H_
#define _TIMELIB_H_

/******************** INCLUDE FILES ******************************************/

#include <stdio.h>

/******************** CONSTANTS AND MACROS ***********************************/

#define TL_YEAR  1
#define TL_MONTH 2
#define TL_DAY   3
#define TL_DOY   4
#define TL_HOUR  5
#define TL_MIN   6
#define TL_SEC   7
#define TL_MSEC  8
#define TL_USEC  9
#define TL_NSEC 10
#define TL_CT   11


/******************** TYPE DEFINITIONS ***************************************/

/* time structure */
typedef struct {
   short year;
   short doy;   /* day of year */
   short day;   // day of month (1-31)
   short month; // 1-12
   short hr;
   short min;
   short sec;
   short msec;
   short usec;
   short nsec;
   long double ct;     // time in seconds since 1-Jan-1970
} scet;


/******************** FUNCTION PROTOTYPES ************************************/

void TL_Set(scet *tp, short year, short month, short day,
                      short hr, short min, short sec,
                      short msec, short usec, short nsec);
void TL_SetCt(scet *tp, long double value);
void TL_AddCt(scet *tp, long double value);
void TL_Add(scet *tp, int what, int value);
void TL_PrintDateTime(scet *tp, FILE *fp);
void TL_PrintDate(scet *tp, FILE *fp);
int  TL_DateCmp(scet t1, scet t2);

#endif
