/*****************************************************************************
 openfile.h --- header file for simplified file opening
 *****************************************************************************
$Id: openfile.h,v 1.1.1.1 2002/10/14 17:08:19 hav Exp $
******************************************************************************
$Log: openfile.h,v $
Revision 1.1.1.1  2002/10/14 17:08:19  hav
c/c++ sources

Revision 1.4  2002/01/23 11:06:57  hav
no change

Revision 1.3  2001/07/25 14:48:07  hav
new mode for fopen added

******************************************************************************/

#ifndef _OPENFILE_H_
#define _OPENFILE_H_

/******************* INCLUDE FILES ******************************************/

#include <stdio.h>

/******************* MACROS AND CONSTANTS ***********************************/

#define OPF_RT  0  /* open for reading in text mode   */
#define OPF_RB  1  /* open for reading in binary mode */
#define OPF_WT  2  /* open for writing in text mode */
#define OPF_WB  3  /* open for writing in binary mode */
#define OPF_AT  4  /* open for appending in text mode */
#define OPF_AB  5  /* open for appending in binary mode */
#define OPF_WBP 6  /* open for read/write, delete existing, binary mode */

#define OPF_CONT  0
#define OPF_EXIT  1

#define OPF_DEC   0
#define OPF_PC    1

/******************* FUNCTION PROTOTYPES ***********************************/

FILE *OpenFile(const char *fn, int mode, int action);

#endif

