/******************************************************************************
                           cl2tm.h  -  description
                             -------------------
    begin                : June 07 15:02 CET 2001

    author               : Hans Vaith
    email                : hav@mpe.mpg.de
    copyright            : (C) 2001 by Max-Planck-Institut fr extra-
                           terrestrische Physik, D-85740 Garching

******************************************************************************
$Id: cl2tm.h,v 1.2 2003/03/31 18:41:44 hav Exp $
$Log: cl2tm.h,v $
Revision 1.2  2003/03/31 18:41:44  hav
support for RAPID

Revision 1.1.1.1  2002/10/14 17:08:19  hav
c/c++ sources

Revision 1.6  2002/05/28 07:34:31  hav
no functional change

Revision 1.5  2002/01/23 11:06:30  hav
added function CL2TM_GetScId()

Revision 1.4  2001/11/12 17:38:18  hav
added prototype of CL2TM_GetDataType()

Revision 1.3  2001/09/12 12:09:19  hav
*** empty log message ***

Revision 1.2  2001/07/26 16:03:16  hav
new file type constants

Revision 1.1  2001/07/25 14:48:38  hav
Initial revision

*****************************************************************************/

#ifndef _CL2TM_H_
#define _CL2TM_H_

/******************** INCLUDE FILES ******************************************/

#include <stdio.h>
#include "timelib.h"

/******************** CONSTANTS AND MACROS ***********************************/

#define MAXLEN  256

#define FILE_TYPE_SCSDMP 1
#define FILE_TYPE_CDDS   2
#define FILE_TYPE_RDM    3
#define FILE_TYPE_MSF    4


#define HK_SIZE      90
#define NM_SIZE     980
#define BM1_SIZE   6944
#define BM2_SIZE    992
#define BM3_SIZE  23188

// data sources
// ------------
#define CL2TM_DSRC_NDF  0  // not defined
#define CL2TM_DSRC_SC   1
#define CL2TM_DSRC_EDI  2
#define CL2TM_DSRC_CMDH 3 // COMMAND LOG
#define CL2TM_DSRC_FGM  4 
#define CL2TM_DSRC_MSF  5 // EDI MSF
#define CL2TM_DSRC_RAP  6 // RAPID


// tm types
// --------
#define CL2TM_NDF_DATA  0 // not defined
#define CL2TM_NSD_DATA  1
#define CL2TM_BSD_DATA  2
#define CL2TM_HKD_DATA  3
#define CL2TM_AUX_DATA  4
#define CL2TM_MSF_DATA  5


/******************** TYPE DEFINITIONS ***************************************/


/* DDS/SCS tm header breakup */
typedef struct {
  scet sc_time;
  char sc_id;
  char data_source;
  char data_type; /* EDISIM TM mode identifier in case of SCS DMP data */
  long packet_length;
  char gst_id;    /* ground station id */
  char channel;
  char time_qual;
  char tasi;
} tmheader;

/* structure for DDS/SCS tm header + data */
typedef struct {
   FILE *ofp;     //
   long pktno;   // packet number
   tmheader hdr; // tm header
   short *data;  // tm data
} tmpacket;


/******************** FUNCTION PROTOTYPES ************************************/

void CL2TM_OpenFile(const char *fn);
void CL2TM_CloseFile(void);
void CL2TM_ReadData(FILE *ofp);
int  CL2TM_ReadPacket(tmpacket *tmptr);
int  CL2TM_GetFileType(void);
int  CL2TM_GetDataType(void);
int  CL2TM_GetScId(void);

#endif




