PRO pick_tcal_init, SNAME, FNAME, rename_ftp = rename_ftp
; CLUSTER II IDL Procedure
;
; Abstract: open time calibration data file
;
; created by: Mark Chutter
; Apr. 12, 2001
;
; Modified: 
;
; Calling Interface:
; SNAME         char    (i)     Type of data as text (ARCHIVE,RDM,RTA)
; FNAME         char    (i)     data file name
;
; Return Value:
;
; Description:
; This opens an RDM time calibration file.
;
; Example:
; 
; SNAME = 'rdm'
; FNAME = '000115la.1a1'
;
; ...
; PICK_TCAL_INIT(SNAME,FNAME)
; status= PICKA_SC(sc_pick_id,PSTATUS)
; ...
;
COMMON tcal, pick_tcal_lun

SFDU_label = bytarr(20)
SFDU_length = 0L

SNAME = STRLOWCASE(SNAME)

file_type = SNAME
openr, pick_tcal_lun, FNAME, /get_lun, error = err
IF (err NE 0) THEN BEGIN
    print, 'Could not find SC_HK file!'
    pick_tcal_lun = -3 ;-3 is not a valid LUN so I use it for this error
    return
ENDIF

IF (file_type EQ 'ftp') THEN BEGIN
    readu, pick_tcal_lun, SFDU_label ;for the entire packet
    readu, pick_tcal_lun, SFDU_label ;for the first LVO - the acknowledgement
    SFDU_length = 0L
    FOR i = 0, 7 DO $
      SFDU_length = SFDU_length + 10L^(7-i) * (LONG(SFDU_label[12+i]) - 48L)
    ack = bytarr(SFDU_length)
    readu, pick_tcal_lun, ack
    SFDU_length = 0L
    readu, pick_tcal_lun, SFDU_label ;for the second LVO - the catalogue entry
    FOR i = 0, 7 DO $
      SFDU_length = SFDU_length + 10L^(7-i) * (LONG(SFDU_label[12+i]) - 48L)
    catalogue = bytarr(SFDU_length)
    readu, pick_tcal_lun, catalogue
    readu, pick_tcal_lun, SFDU_label ;for the third LVO - the data

    file_type = 'rdm'; now treat file like RDM
ENDIF

return

END
