PRO pick_srp_time, Tsrp,Tspin,shk_record
;C++  
;C ABSTRACT:
;C 
;C   Calculate Sun Reference Pulse time/spin phase from CLUSTER S/C-HK buffer
;C 
;C FORMAL PARAMETERS:
;C
;C
;C FUNCTIONAL DESCRIPTION:
;C 
;C   This module calculates the SRP time of a spin both in PICK C-time
;C   (seconds since 1970 & us/sec). Calculation according to the CSDS approved 
;C   algorithm as outlined in DS-QMW-TN-0007.
;C 
;C--
;C MODIFICATION HISTORY:
;C
;C [gcdc_modification]...  
;C 
;C INCLUDED FILES:
;C 
;C REFERENCES:
;C 
;C FILENAME: PICK_SRP_TIME.FOR
;C 
;C COMPILER: DEC FORTRAN 6.3
;C 
;C CREATION: 06-MAY-1996
;C 
;C VERSION: V0.1
;C 
;C AUTHOR: K. Prokopiu, MPE Garching
;C--
	implicit  none

	include 'idb_parameter.inc'
	include 'pick_parameter.inc'
	include 'pick_structure.inc'
	include 'sc_pick_parameter.inc'
	include 'sc_pick_structure.inc'
	include 'pick_common.inc'

	integer*4 n_srp			! Number of SRPs
	1,        status		! Return status from I/O routines
	1,        hk_day		! Days since 1958.0 for RAPID HK data
	1,	  Tsrp(2)		! PICK C time 1/1/1970 & us

	real*8    hk_time		! Time of RAPID HK record, sec of day
	real*8	  t_srp(12)		! SRP time
	real*4	  Tspin

	byte	  dummy
	integer*4 msf_day,i,bn_srp,nnsrp
	real*8    msf_secoday
	byte      shk_data(3600)

	record /sc_pick_pck_struct/ shk_record
C
C Swap the contents of the SHK data bytewise because the PICK Library
C   has another byte order returned than is originally in the file
C
FOR i = 
;do i=1,18 BEGIN
    shk_data(I*2) = shk_record.byte_data(13+(i*2)-1)
    shk_data((i*2)-1)=shk_record.byte_data(13+(i*2))
ENDFOR 
C
C Extract all available T_SRPs (offsets) from the SHK packet 
C	  
msf_getsrp, shk_data, n_srp, t_srp
C
C If the average spin does look strange (at the start of a program) then
C   set with default values
C
IF (pick_last_tspin/pick_tspin_avgcnt GT 4.5 OR $
    pick_last_tspin/pick_tspin_avgcnt LT 3.5 OR $
    pick_tspin_avgcnt le 0.0) THEN BEGIN
    pick_last_tspin = 4.0
    pick_tspin_avgcnt = 1.0
ENDIF
C
C If no t_srp was found then we will then return the last Tsrp and Tspin
C   and leave it to the user to check the validity of the value
C
IF (n_srp EQ 0) THEN BEGIN
    Tsrp(1) = pick_last_tsrp(1)
    Tsrp(2) = pick_last_tsrp(2)
    Tspin = pick_last_tspin / pick_tspin_avgcnt
    return
ENDIF
C
C If ok then we take the first t_srp value and convert it to PICK C-time
C   from 1-jan-1958 to 1-jan-1970 + us
C
Tsrp(1) = shk_record.packet_time(1) + int(t_srp(1))
Tsrp(2) = shk_record.packet_time(2) + $
  int( ( t_srp(1) - int(t_srp(1)) ) * 1000000)

IF (Tsrp(2) gt 1000000) THEN BEGIN
Tsrp(2) = Tsrp(2) - 1000000
Tsrp(1) = Tsrp(1) + 1
ENDIF
IF (Tsrp(2) lt 0) THEN BEGIN
    Tsrp(2) = Tsrp(2) + 1000000
    Tsrp(1) = Tsrp(1) - 1
ENDIF
C
C The spin phase can only be calculated if we have at least two Tsrp values
C  case a: n_srp > 1: calculate the spinphase directly from the two Tsrp
C  case b: n_srp = 1: get this tsrp and the last tsrp and calculate Tspin
C  case c: n_srp = 0: resend the last Tspin
C
IF (n_srp GE 1) THEN BEGIN
    t_srp(2) = dble(tsrp(1)) + dble(tsrp(2)) / 1000000.0d0
    t_srp(1) = dble(pick_last_tsrp(1)) + $
      dble(pick_last_tsrp(2)) / 1000000.0d0
    Tspin = t_srp(2) - t_srp(1)
ENDIF

IF (Tspin GT 4.5 OR Tspin LT 3.5) THEN $
  Tspin = pick_last_tspin / pick_tspin_avgcnt

pick_last_tspin = pick_last_tspin + Tspin
pick_tspin_avgcnt = pick_tspin_avgcnt + 1.0
pick_last_tsrp(1) = Tsrp(1)
pick_last_tsrp(2) = Tsrp(2)
Tspin = pick_last_tspin / pick_tspin_avgcnt

return
END
