FUNCTION nm1_pacmo5_fill, packet, hdr, sc_id
; CLUSTER II IDL Function
;
; Abstract: fill an EDI nm1_pacmo5 data structure
;
; Created by: Mark Chutter, UNH 
; June 29, 1999
;
; Modified:
; July 23, 1999 MWC move btime correction to dealias_clu_time_tag
; Aug.  9, 1999 MWC changed error field to status
; Oct. 19, 1999 MWC used common block for structure definitions
; Feb. 29, 2000 MWC added to check to see if there is any data; this
;                   is useful when trying to look at simulator files
; Mar. 23, 2000 MWC fixed count
; May   9, 2000 MWC time tag at TMR was incorrect
; Aug. 28, 2000 MWC added check to see if delta time tags was too large
; Sep. 29, 2000 MWC TM can lie, if the data_count is 42 then subtract 1
; Oct. 20, 2000 MWC set status to DELTA_TIME_TAG_BIG is
;                   dealias_cl_time_tag returns with
;                   status = DELTA_TIME_TAG_BIG 
; Nov.  7, 2000 MWC add the time of one data structure to btime
; Nov. 13, 2000 MWC added sc_id
; Nov. 18, 2000 MWC find_beam_times now assigns atime and beam times
; Nov. 19, 2000 MWC typo from cut and paste, sorry
; Nov. 20, 2000 MWC just pass header to find_beam_times
; Mar.  7, 2001 MWC added sc_id and hdr.packet_time to gd_fill because
;                   of TOF definition changes
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; July 19, 2001 MWC oops, when I checked to see if the data count was
;                   0, I just returned without setting the status
; Jan. 14, 2002 MWC added sc_pick_amb_geos_struct
; Apr. 29, 2002 MWC simplified the code a bit by getting rid of fctmr checks.
;                   The old version is saved as nm1_pacmo5_fill.fctmr
;                   in case we ever want it back.
; June 28, 2002 MWC double size of NUMBER_PACMO0_DATA and added call
;                   to gd_one_fill if EDI is in one detector mode
; Sep. 25, 2002 MWC set NUMBER_PACMO5_DATA back to 41; add check for
;                   one detector mode
; Oct. 31, 2002 MWC atime was botched for 2 detector WW
;
; Calling Interface:
; packet bytarr              (i) EDI science packet
; hdr    sc_pick_ehdr_struct (i) EDI header structure
;
; Return Value:
; A sc_pick_npacmo5_struct structure is returned.  If the status field is
; less than 1, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; nm1_pacmo5_fill fills a nominal mode 1, pacmo 5 data structure.  It
; is not a user level function.

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

@pick_const

PACMO5_DATA_START = 44
PACMO5_DATA_SIZE = 20; /* size in bytes */
NUMBER_PACMO5_DATA = 41

bci_start = 0
time_tag_TMR = 0
btime = lonarr(2)

pacmo5 = sc_pick_npacmo5_struct
pacmo5.status = 1

pacmo5.time_tag = long(packet[40]) * '100'xL + long(packet[41])
pacmo5.data_count = fix(packet[42]) * '100'x + fix(packet[43])
IF pacmo5.data_count EQ 42 THEN pacmo5.data_count = 41
IF hdr.one_det EQ 1 THEN $
  pacmo5.data_count = pacmo5.data_count * 2
;WW is the only mode that uses pacmo5

IF pacmo5.data_count EQ 0 OR $
  hdr.science_mode NE '5'x THEN BEGIN
    pacmo5.status = INVALID_EDI_DATA
    return, pacmo5
ENDIF

time_tag_TMR = long(packet[8]) * '100'xL + long(packet[9])
dealias_clu_time_tag, hdr, time_tag_TMR, pacmo5.time_tag, btime, $
  sc_id, status
IF status EQ DELTA_TIME_TAG_BIG THEN BEGIN
    pacmo5.status = DELTA_TIME_TAG_BIG
    return, pacmo5
ENDIF

bci_buf = packet[PACMO5_DATA_START:$
                 PACMO5_DATA_START+NUMBER_PACMO5_DATA*PACMO5_DATA_SIZE-1]

IF hdr.one_det EQ 0 THEN BEGIN
    data = gd_fill(bci_buf, pacmo5.data_count, NUMBER_PACMO5_DATA, 5, $
                   sc_id, hdr.packet_time)
    find_beam_times, btime, hdr, NUMBER_PACMO5_DATA, data, atime, $
      beam_time1, beam_time2
ENDIF ELSE BEGIN
    data = gd_one_fill(bci_buf, 2*NUMBER_PACMO5_DATA, 2*NUMBER_PACMO5_DATA, $
                       5, sc_id, hdr.packet_time, hdr.which_det)
    find_beam_times, btime, hdr, NUMBER_PACMO5_DATA, data, atime, $
      beam_time1, beam_time2, /one_det
ENDELSE

pacmo5.data = data

IF hdr.one_det EQ 0 THEN BEGIN
    pacmo5.data[0:NUMBER_PACMO5_DATA-1].atime[0] = $
      reform(atime[0, 0:NUMBER_PACMO5_DATA-1])
    pacmo5.data[0:NUMBER_PACMO5_DATA-1].atime[1] = $
      reform(atime[1, 0:NUMBER_PACMO5_DATA-1])
    pacmo5.data[0:NUMBER_PACMO5_DATA-1].beam_time1 = beam_time1
    pacmo5.data[0:NUMBER_PACMO5_DATA-1].beam_time2 = beam_time2
ENDIF ELSE BEGIN
    pacmo5.data.atime = atime
    pacmo5.data.beam_time1 = beam_time1
    pacmo5.data.beam_time2 = beam_time2
ENDELSE

return, pacmo5
END

