FUNCTION nm1_pacmo4_fill, packet, pga1_config
; CLUSTER II IDL Function
;
; Abstract: fill an EDI nm1_pacmo4 data structure
;
; Created by: Mark Chutter, UNH 
; April 2, 2001
;
; Modified:
; Jan. 14, 2002 MWC added sc_pick_amb_geos_struct
;
; Calling Interface:
; packet        bytarr (i) EDI science packet
; pga1_config   byte   (i) flag to show whether pga1 is configured
;
; Return Value:
; A sc_pick_npacmo4_struct structure is returned.  If the status field is
; less than 1, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; nm1_pacmo4_fill fills a nominal mode 1, pacmo 4 data structure.  It
; is not a user level function.

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

@pick_const

pacmo4 = sc_pick_npacmo4_struct
pacmo4.status = 1

pacmo4.pga1_conf = pga1_config
print, pga1_config
;if PGA1 has not yet been configured then there is no secondary
;header.  Word 4 is a TMR count and word 5 is a data count.  Starting
;at word 6 there are 8 word structures (really just 4 cuz it repeats)
IF pga1_config EQ 0 THEN BEGIN
    pacmo4.data_count = (fix(packet[8]) * '100'x + fix(packet[9])) * 2
    index = indgen(pacmo4.data_count)
    offset = index * 8 + 12
ENDIF ELSE BEGIN
    pacmo4.timetag32 = long(packet[42]) * '100'x + long(packet[43])
    pacmo4.data_count = fix(packet[44]) * '100'x + fix(packet[45])
    IF pacmo4.data_count GT 0 THEN BEGIN
        index = indgen(pacmo4.data_count)
        offset = index * 8 + 46
    ENDIF ELSE BEGIN
        pacmo4.status = INVALID_EDI_DATA
        return, pacmo4
    ENDELSE
ENDELSE

pacmo4.conpc[index] = (float((packet[offset[index]] AND '0F'x) * '100'x + $
                             packet[offset[index]+1]) - 512.) * 0.4888
gdufix = 512. - pacmo4.conpc * 0.716
pacmo4.gd1pc[index] = (float((packet[offset[index]+2] AND '0F'x) * '100'x + $
                             packet[offset[index]+3]) - gdufix) * 0.4888
pacmo4.gd2pc[index] = (float((packet[offset[index]+4] AND '0F'x) * '100'x + $
                             packet[offset[index]+5]) - gdufix) * 0.4888
vol28 = fix(packet[offset[index]+6] AND '0F'x) * '100'x + $
            fix(packet[offset[index]+7])
pacmo4.vol28[index] = (vol28 - '200'x) * 0.08992805

IF pga1_config GT 0 THEN BEGIN
    pacmo4.timetag64 = long(packet[880]) * '100'x + long(packet[881])
    pacmo4.mux = fix(packet[884]) * '100'x + fix(packet[885])
    index = indgen(16)
    pacmo4.gdu_timetags[index] = long(packet[index * 2 + 886]) * '100'x + $
      long(packet[index * 2 + 887])
ENDIF

return, pacmo4
END
