FUNCTION nm1_pacmo1_fill, packet, hdr, sc_id
; CLUSTER II IDL Function
;
; Abstract: fill an EDI nm1_pacmo1 data structure
;
; Created by: Mark Chutter, UNH 
; June 29, 1999
;
; Modified:
; July 23, 1999 MWC move btime correction to dealias_clu_time_tag
; Aug.  9, 1999 MWC changed error field to status
; Oct. 18, 1999 MWC changed indexing in loops to use an offset and
;                   fixed the low bits of i1 and i2 which were not
;                   being 'anded' with '0F'x
; Oct. 19, 1999 MWC used common block for structure definitions
; Feb. 29, 2000 MWC added to check to see if there is any data; this
;                   is useful when trying to look at simulator files
; May   9, 2000 MWC time tag at TMR was incorrect
; May  23, 2000 MWC now that I have a better appreciation for index
;                   and frame bits, I see that I had included the
;                   frame bits in the index.  Ich mache nicht mehr.
; Aug. 28, 2000 MWC added check to see if delta time tags was too large
; Oct. 20, 2000 MWC set status to DELTA_TIME_TAG_BIG is
;                   dealias_cl_time_tag returns with 
;                   status = DELTA_TIME_TAG_BIG
; Nov.  7, 2000 MWC add the time of one data structure to btime
; Nov. 13, 2000 MWC added sc_id
; Nov. 18, 2000 MWC find_beam_times now assigns atime and beam times
; Nov. 20, 2000 MWC just pass header to find_beam_times
; Mar.  8, 2001 MWC added sc_id and hdr.packet_time to bci16_fill because
;                   of TOF definition changes
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; July 19, 2001 MWC oops, when I checked to see if the data count was
;                   0, I just returned without setting the status
; Jan. 14, 2002 MWC added sc_pick_amb_geos_struct
;
; Calling Interface:
; packet bytarr              (i) EDI science packet
; hdr    sc_pick_ehdr_struct (i) EDI header structure
;
; Return Value:
; A sc_pick_npacmo1_struct structure is returned.  If the status field is
; less than 1, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; nm1_pacmo1_fill fills a nominal mode 1, pacmo 1 data structure.  It
; is not a user level function.

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

@pick_const

PACMO1_DATA_START = 44
NUMBER_PACMO1_DATA = 81
PACMO1_DATA_SIZE = 10; /* size in bytes */
PACMO1_LO_INDEX_OFFSET = 854
PACMO1_HI_INDEX_OFFSET = 936
fctmr = 0
bci_start = 0
time_tag_TMR = 0
btime = lonarr(2)

pacmo1 = sc_pick_npacmo1_struct
pacmo1.status = 1

pacmo1.time_tag = long(packet[40]) * '100'x + long(packet[41])
pacmo1.data_count = fix(packet[42]) * '100'x + fix(packet[43])
IF pacmo1.data_count EQ 0 THEN BEGIN
    pacmo1.status = INVALID_EDI_DATA
    return, pacmo1
ENDIF

IF ((hdr.science_mode EQ '1'x) OR $
    (hdr.science_mode EQ '2'x) OR $
    (hdr.science_mode EQ '5'x) OR $
    (hdr.science_mode EQ '8'x) OR $
    (hdr.science_mode EQ '13'x)) THEN fctmr = 1  

IF (fctmr EQ 1) THEN BEGIN
    time_tag_TMR = long(packet[8]) * '100'xL + long(packet[9])
    dealias_clu_time_tag, hdr, time_tag_TMR, pacmo1.time_tag, btime, $
      sc_id, status
    IF status EQ DELTA_TIME_TAG_BIG THEN BEGIN
        pacmo1.status = DELTA_TIME_TAG_BIG
        return, pacmo1
    ENDIF
ENDIF

bci_buf = packet[PACMO1_DATA_START:$
                 PACMO1_DATA_START+pacmo1.data_count*PACMO1_DATA_SIZE-1]
data = bci16_fill(bci_buf, pacmo1.data_count, sc_id, hdr.packet_time)
pacmo1.data = data

; unpack the low bits of the index
FOR i = 0, pacmo1.data_count-1 DO BEGIN
    offset = PACMO1_LO_INDEX_OFFSET + i
    pacmo1.data[i].i1 = ishft((packet[offset]), -4) AND '0F'x
    pacmo1.data[i].i2 = packet[offset] AND '0F'x
ENDFOR

; Add the high bits of the index if there is more than one 5-word */
; structure.  If there is an odd number, the index bits for the last */
; structure are in a different place. */

IF (pacmo1.data_count GT 1) THEN BEGIN

    FOR i=0, (pacmo1.data_count)/2-1 DO BEGIN
        index1 = 2 * i
        index2 = index1 + 1
        offset = PACMO1_HI_INDEX_OFFSET+i
        pacmo1.data[index1].i1 = pacmo1.data[index1].i1 + $
          ishft((packet[offset] AND '80'x), -3)
        pacmo1.data[index1].i2 = pacmo1.data[index1].i2 + $
          ishft((packet[offset] AND '20'x), -1)
        pacmo1.data[index2].i1 = pacmo1.data[index2].i1 + $
          ishft((packet[offset] AND '08'x), 1)
        pacmo1.data[index2].i2 = pacmo1.data[index2].i2 + $
          ishft((packet[offset] AND '02'x), 3)
        pacmo1.data[index1].frame1 = ishft((packet[offset] AND '40'x), -6)
        pacmo1.data[index1].frame2 = ishft((packet[offset] AND '10'x), -4)
        pacmo1.data[index2].frame1 = ishft((packet[offset] AND '04'x), -2)
        pacmo1.data[index2].frame2 = (packet[offset] AND '01'x)
    ENDFOR

ENDIF

; if the data count is odd 
IF ((pacmo1.data_count mod 2) EQ 1) THEN BEGIN
    pacmo1.data[pacmo1.data_count-1].i1 = $
      pacmo1.data[pacmo1.data_count-1].i1 + $
      ishft((packet[PACMO1_HI_INDEX_OFFSET + $
                    (pacmo1.data_count/2)] AND '08'x), 1)
    pacmo1.data[pacmo1.data_count-1].i2 = $
      pacmo1.data[pacmo1.data_count-1].i2 + $
      ishft((packet[PACMO1_HI_INDEX_OFFSET + $
                    (pacmo1.data_count/2)] AND '02'x), 3)
    pacmo1.data[pacmo1.data_count-1].frame1 = $
      ishft((packet[PACMO1_HI_INDEX_OFFSET + $
                    (pacmo1.data_count/2)] AND '04'x), -2)
    pacmo1.data[pacmo1.data_count-1].frame2 = $
      packet[PACMO1_HI_INDEX_OFFSET + $
             (pacmo1.data_count/2)] AND '01'x
ENDIF

IF (fctmr EQ 1) THEN BEGIN
    find_beam_times, btime, hdr, $
      pacmo1.data_count, pacmo1.data, atime, beam_time1, beam_time2
END
pacmo1.data.atime = atime
pacmo1.data.beam_time1 = beam_time1
pacmo1.data.beam_time2 = beam_time2

return, pacmo1
END

