FUNCTION new_decompress, comp_data
; CLUSTER II IDL Function
;
; Abstract: inflate compressed EDI data
;
; Created by: Mark Chutter, UNH
; June  8, 2000
;
; Modified:
; Aug. 21, 2000 MWC Oops, forgot to return anything
; Aug. 25, 2000 MWC both compressed and uncompressed data should be unsigned
; Nov.  2, 2001 MWC replaced GT with GE
;
; Calling Interface:
; comp_data   uintarr (i) the compressed data
; decomp_data uintarr (i/o) the decompressed data
;
; Return Value:
;
; Affected Variables:
;
; Description:
; edi_decompress inflates compressed EDI data from BCI32 data and
; BM1 Pacmo 0 channels 2 and 3.  It inflates all the data at once
; rather than a piece at a time like the old version.

decomp_data = uintarr(n_elements(comp_data))

w = where(comp_data LT '40'xu, count)
IF count GT 0 THEN $
  decomp_data[w] = fix(comp_data[w])
w = where((comp_data GE '40'xu) AND (comp_data LT '60'xu), count)
IF count GT 0 THEN $
  decomp_data[w] = '40'xu + ((comp_data[w] - '40'xu) * '2'xu)
w = where((comp_data GE '60'xu) AND (comp_data LT '80'xu), count)
IF count GT 0 THEN $
  decomp_data[w] = '80'xu + ((comp_data[w] - '60'xu) * '4'xu)
w = where((comp_data GE '80'xu) AND (comp_data LT 'A0'xu), count)
IF count GT 0 THEN $
  decomp_data[w] = '100'xu + ((comp_data[w] - '80'xu) * '8'xu)
w = where((comp_data GE 'A0'xu) AND (comp_data LT 'C0'xu), count)
IF count GT 0 THEN $
  decomp_data[w] = '200'xu + ((comp_data[w] - 'A0'xu) * '10'xu)
w = where((comp_data GE 'C0'xu) AND (comp_data LT 'E0'xu), count)
IF count GT 0 THEN $
  decomp_data[w] = '400'xu + ((comp_data[w] - 'C0'xu) * '20'xu)
w = where((comp_data GE 'E0'xu) AND (comp_data LT 'FF'xu), count)
IF count GT 0 THEN $
  decomp_data[w] = '800'xu + ((comp_data[w] - 'E0'xu) * '40'xu)
w = where(comp_data EQ 'FF'xu, count)
IF count GT 0 THEN $
  decomp_data[w] = '1000'xu
return, decomp_data

END


