FUNCTION m5_fill, sec_header
; CLUSTER II IDL Function
;
; Abstract: fill an EDI m5 data structure
;
; Created by: Mark Chutter, UNH 
; July 1, 1999
;
; Modified:
; Oct. 19, 1999 MWC used common block for structure definitions
; Dec.  8, 1999 MWC added m
; Jan. 12, 2000 MWC fixed m
; Jan. 13, 2000 MWC fixed deltaflag and WW step indices
; Mar. 22, 2000 MWC changed init_tbl to init_table
; Jul. 10, 2000 MWC added code_type, staff_gains, and limits_by_tc
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; June 28, 2001 MWC when making the beam current plots, I discovered
;                   that there were some packets with invalid beam
;                   current indices
; July 10, 2001 MWC added PICK_VERBOSE keyword
; Jan. 14, 2002 MWC added amb_geos struct
; Apr.  9, 2002 MWC added description of optics state
;
; Calling Interface:
; sec_header_buf bytarr (i) secondary header of the EDI science packet 
;
; Return Value:
; A sc_pick_esm5_struct structure is returned.  If the error field is
; not zero, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; m5_fill fills an m5 data structure (sc_pick_esm5_struct) from the
; secondary header of an EDI science packet according to the
; specifications of the EDI User's Manual

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

m5 = sc_pick_esm5_struct

m5.fctmr = long(sec_header[0]) * '100'xL + long(sec_header[1])
m5.init_table = sec_header[2]
m5.energy_state = ishft((sec_header[3] AND '40'x), -6)
m = ishft((sec_header[3] AND '30'x), -4)

CASE m OF

    0:m5.m = 16
    1:m5.m = 8
    2:m5.m = 4
    3:m5.m = 2

ENDCASE

;optics state
;2 wide angle
;3 max SNR
;4 shutdown
;5 ?
;6 largest signal
;7 wide D
m5.optics_state = sec_header[3] AND '0F'x
m5.bcnx1 = sec_header[4]
m5.bcnx2 = sec_header[5]
m5.ndxdt = ishft((sec_header[6] AND 'F0'x), -4)
m5.fract = sec_header[6] AND '0F'x
m5.sob = sec_header[7]
m5.eeprom = fix(sec_header[8]) * '100'x + fix(sec_header[9]);why?
m5.code_type = ishft((sec_header[9] AND '80'x), -7) ;long or short code
m5.staff_gains = ishft((sec_header[9] AND '40'x), -6) ;staff gains off or on
m5.limits_by_tc = ishft((sec_header[9] AND '20'x), -5) ;limits set by user TC
m5.deltaflag = ishft((sec_header[10] AND 'C0'x), -6)
m5.deltabci = sec_header[10] AND '3F'x
m5.gdu1_ww_step = ishft((sec_header[11] AND 'F0'x), -4)
m5.gdu2_ww_step = sec_header[11] AND 'F'x
m5.limhi = sec_header[12]
m5.limlo = sec_header[13]
m5.gdu1_cmd17 = fix(sec_header[14]) * '100'x + fix(sec_header[15])
m5.ave1sgnl = sec_header[16]
m5.ave2sgnl = sec_header[17]
m5.max1sgnl = sec_header[18]
m5.max2sgnl = sec_header[19]
m5.ave1bkgd = sec_header[20]
m5.ave2bkgd = sec_header[21]
m5.ss1_locnt = sec_header[22]
m5.ss2_locnt = sec_header[23]
m5.ss1_hicnt = sec_header[24]
m5.ss2_hicnt = sec_header[25]
m5.reverse1 = sec_header[26]
m5.reverse2 = sec_header[27]
m5.max1_678 = sec_header[28]
m5.max2_678 = sec_header[29]
m5.valid = fix(sec_header[30]) * '100'x + fix(sec_header[31])

verbose = getenv('PICK_VERBOSE')
;If the beam current indices are GT 36, then set valid to invalid data
IF m5.bcnx1 GT 36 OR m5.bcnx2 GT 36 THEN BEGIN
    m5.valid = 0 
    IF verbose NE '' THEN BEGIN
        print, 'Beam current indices are too high'
        print, 'gun 1: ', m5.bcnx1,  ' gun 2: ', m5.bcnx2
    ENDIF
ENDIF

return, m5
END
