; CLUSTER II IDL structure definitions
;
; hk_struct.pro
;
; Created by: Mark Chutter, UNH
; August 30, 1999
;
; Modified:
; Oct. 19, 1999 MWC added common block hk_structs
; Dec.  8, 2000 MWC added variable section
; Dec. 15, 2000 MWC added nsamp, extrp
; Jan.  5, 2001 MWC added data_stream
; Apr.  3, 2001 MWC formatted COMMON block
; July 11, 2002 MWC renamed 5v1f to 5vif
;
; This file contains the definitions of all the structures used to
; store EDI housekeeping data.
COMMON hk_structs, $
  sc_pick_ana_sensor_struct, sc_pick_dig_sensor_struct, $
  sc_pick_sensor_struct, $
  sc_pick_gdu_01_struct, sc_pick_gdu_23_struct, $
  sc_pick_gdu_45_struct, sc_pick_gdu_67_struct, $
  sc_pick_gdu_struct, sc_pick_I_V_struct, $
  sc_pick_hk_struct

sc_pick_ana_sensor_struct = {sc_pick_ana_sensor_struct, $
                             rf25: 0., $ ;  2.5 V reference 
                             hvcr: 0., $ ;  HV PS Current 
                             hver: 0., $ ;  HV PS Error 
                             hvrf: 0., $ ;  HV PS Ref 
                             prgn: 0., $ ;  Preamp Gain 
                             n_5v: 0., $ ;  -5V LV PS 
                             p_5v: 0., $ ;  +5 V LV PS 
                             stmp: 0.} ;  Temperature 

sc_pick_dig_sensor_struct = {sc_pick_dig_sensor_struct, $
                             disa: 0b, $ ;  Disarm bit
                             ovrf: 0b, $ ;  overflow bit
                             basa: 0b, $ ;  Base Address 
                             acpo: 0b, $ ;  Accumulator Pointer Field 
                             copo: 0b, $ ;  Correlator Pointer Field 
                             pwst: 0b, $ ;  Power Strobing 
                             dtim: 0b, $ ;  Dead Time Setting 
                             exim: 0b, $ ;  Execute Immediately 
                             swap: 0b, $ ;  Swap Channels 
                             tpls: 0b} ;  Test Pulser Enable 

sc_pick_sensor_struct = {sc_pick_sensor_struct, $
                         stps: 0, $ ;  Sensor (1=step, 0=no step) 
                         pw24: 0, $ ;  Sensor disarm bit 
                         dgtl: {sc_pick_dig_sensor_struct}, $
                         mx1: {sc_pick_ana_sensor_struct}, $
                         mx2: {sc_pick_ana_sensor_struct}}

sc_pick_gdu_01_struct = {sc_pick_gdu_01_struct, $
                         i_d1: 0., $ ; Error Deflector 1
                         i_d2: 0., $ ; Error Deflector 2
                         i_d3: 0., $ ; Error Deflector 3
                         i_d4: 0., $ ; Error Deflector 4
                         i_d5: 0., $ ; Error Deflector 5
                         i_d6: 0., $ ; Error Deflector 6
                         i_d7: 0., $ ; Error Deflector 7
                         i_d8: 0., $ ; Error Deflector 8
                         i_an: 0., $ ; Error Anode
                         i_fc: 0., $ ; Error Fokus
                         i_ca: 0., $ ; Error Cathode
                         i_bw: 0., $ ; Error Beam Width
                         i_bc: 0., $ ; Beam Current
                         gndg: 0., $ ; GND Ref.
                         i_eu: 0., $ ; Error Upper Deflector
                         i_au: 0.}   ; Error Upper Injector

sc_pick_gdu_23_struct = {sc_pick_gdu_23_struct, $
                         vs28: 0., $ ; 28 V Supply
                         v5uf: 0., $ ; +5V/5 UF Conv.
                         p5vc: 0., $ ; +5V/5
                         gnd0: 0., $ ; GND Ref.
                         n5vc: 0., $ ; -5V/5
                         v5if: 0., $ ; +5V INT/5
                         v5p1: 0., $ ; +5 PG1/5
                         v5p2: 0., $ ; +5 PG2/5
                         gpux: 0., $ ; 2Ua-+1.4Ux
                         gnux: 0., $ ; 2Ua+-1.4Ux
                         gpuy: 0., $ ; 2Ua-+1.4Uy
                         gnuy: 0., $ ; 2Ua+-1.4Uy
                         g_an: 0., $ ; Ua
                         g_fc: 0., $ ; Uf
                         g_ca: 0., $ ; Uc
                         g_bw: 0.}   ; Uw

sc_pick_gdu_45_struct = {sc_pick_gdu_45_struct, $
                         o_eu: 0., $ ; Upper Deflector
                         o_au: 0., $ ; Upper Injector
                         g_bc: 0., $ ; Beam Current Ref
                         gtmp: 0., $ ; Temperature
                         reg1: 0., $ ; Regulator 1
                         reg2: 0., $ ; Regulator 2
                         n2vr: 0., $ ; -2.0V Ref
                         i_cs: 0., $ ; Cathode Supply Current
                         o_el: 0., $ ; Lower Deflector
                         o_al: 0., $ ; Lower Injector
                         o_oa: 0., $ ; Outer Analyzer
                         o_sr: 0., $ ; Sensor Reference
                         o_sp: 0., $ ; Suppressor
                         o_ia: 0., $ ; Inner Analyzer
                         o_rc: 0., $ ; Retainer Cone
                         o_et: 0.} ;Extractor

sc_pick_gdu_67_struct = {sc_pick_gdu_67_struct, $
                         i_el: 0., $ ; Error Lower Deflector
                         i_al: 0., $ ; Error Lower Injector
                         i_oa: 0., $ ; Error Outer Analyser
                         i_sr: 0., $ ; Error Sensor Reference
                         i_sp: 0., $ ; Error Suppressor
                         i_ia: 0., $ ; Error Inner Analyser
                         i_rc: 0., $ ; Error Retainer Cone
                         i_et: 0., $ ; Error Extractor
                         cfq1: 0., $ ; Converter Frequency
                         cfq2: 0., $ ; Converter Frequency
                         cfq3: 0., $ ; Converter Frequency
                         cfq4: 0., $ ; Converter Frequency
                         cfq5: 0., $ ; Converter Frequency
                         cfq6: 0., $ ; Converter Frequency
                         cfq7: 0., $ ; Converter Frequency
                         cfq8: 0.}   ; Converter Frequency

sc_pick_gdu_struct = {sc_pick_gdu_struct, $
                      gdpc: 0., $ ;  GDU Primary Current 
                      gdol: 0, $ ;  GDU Current Over Limit 
                      mcad: 0, $ ;  GDU Max Corr Address 
                      mcrr: 0, $ ;  GDU Max Corr Rate 
                      gdu21: 0U, $ ;  GDU Data Word 21 
                      gdu22: 0U, $ ;  GDU Data Word 22 
                      gdu17: 0U, $ ;  GDU Data Word 17 
                      evt1: 0U, $ ;  EVT1 Rates 
                      evt2: 0U, $ ;  EVT2 Rates 
                      pw22: 0, $ ;  GDU data word 22, bit 1 
                      hvon: 0, $ ;  GDU HVON CMD 
                      gdu_01: {sc_pick_gdu_01_struct}, $ ; GDU HK Parameters
                      gdu_23: {sc_pick_gdu_23_struct}, $
                      gdu_45: {sc_pick_gdu_45_struct}, $
                      gdu_67: {sc_pick_gdu_67_struct}}

sc_pick_I_V_struct = {sc_pick_I_V_struct, $
                      conpc: 0., $ ;  Controller Primary Current 
                      vol28: 0, $ ;  Primary 28 Volt Over Limit 
                      sol5v: 0, $ ;  5 Volt Secondary Current Over Limit 
                      cur5v: 0., $ ;  5V Current 
                      cu12v: 0., $ ;  10V Current 
                      cn12v: 0., $ ;  -10V Current 
                      acu5v: 0., $ ;  5V Auxillary Current 
                      vol5v: 0., $ ;  5V Voltage 
                      vo12v: 0., $ ;  10V Voltage 
                      vn12v: 0., $ ;  -10V Voltage 
                      avo5v: 0.}   ;  Auxillary Voltage 

sc_pick_hk_struct = {sc_pick_hk_struct, $
                     packet_type: 0L, $
                     packet_number: 0L, $
                     packet_time: lonarr(2), $
                     sc_id: 0, $ ; SC number
                     data_stream: 0B, $ ;byte 13 of DDS header
                     frcnt: 0U, $ ;  GDU Frame Counter 
                     submo: 0, $ ;  Telemetry Submode ID
                     i_v:   {sc_pick_I_V_struct}, $ ; currents and voltages
                     wrscm: 0, $ ;  Wrong Science Mode 
                     eewrp: 0, $ ;  EEprom Write Protected: 0=false, 1=true 
                     eepon: 0, $ ;  EEproms on/off 
                     crcnt: 0, $ ;  Commands Received 
                     cvcnt: 0, $ ;  Commands Verified 
                     lastc: 0U, $ ;  Last Command Sent 
                     sucoc: 0, $ ;  SubCom Counter 
                     hvdis: 0, $ ;  HV Disable Connector 
                     modid: 0, $ ;  Science Mode 
                     chksu: 0, $ ;  Checksum 
                     pllst: 0, $ ;  PLL Status 
                     bmagn: 0U, $ ; FGM range and B-Magnitude 
                     bmag : 0., $ ; B
                     fgmr : 0, $ ;  FGM range
                     gdchs: 0, $ ;  Select GDU Channel 1 
                     gdsel: 0, $ ;  GDU 0=GDU1, 1=GDU2 
                     vasec: 0, $ ;  Variable Section ID 
                     gdset: 0, $ ;  GDU subcom counter 
                     pgacf: 0, $ ; PGA flags 0=none, 1=PGAi, 2=PGA1, 3=all
                     ramad: 0L, $ ;  RAM Address
                     ram:uintarr(16), $ ; variable
                     sens1: {sc_pick_sensor_struct}, $
                     sens2: {sc_pick_sensor_struct}, $
                     bcone: 0., $ ; MWC created this one
                     cdtyp: 0, $ ; MWC created this name 
                                  ;code type, short(0) or long(1)
                     optcs: 0, $
                     enrgy: 0, $
                     despn: 0, $ ; MWC created this name 
                                  ; despin(0) or despin+staff(1)
                     intbl: 0, $ ; init table
                     nsamp: 0, $ ; 2 or 4 sample
                     extrp: 0, $ ; extrapolation if 1
                     pacmo: 0, $ ;  TM Packing Mode 
                     m8sta: 0, $ ;  Mode8 Status 
                     eechk: 0, $ ;  EEPROM checksum error
                     gdu1: {sc_pick_gdu_struct}, $
                     gdu2: {sc_pick_gdu_struct}, $
                     status:0}

