FUNCTION get_calib_fgm, start_time, time_length, flag_gap = flag_gap
; CLUSTER II IDL Function
;
; Abstract: read magnetometer data file
;
; created by: Mark Chutter
; Sep. 13, 2000
;
; Modified: 
; Sep. 15, 2000 MWC removed format statements to read - much faster
; Sep. 21, 2000 MWC made samples larger just to be safe and set status 
;                   to the number of actual samples
; Oct.  5, 2000 MWC and I thought we would never get more than 22.5
;                   samples per second; in BM1 there can be 69.xxx;
;                   return a count of 0 in error packets; added some
;                   error checking
; Oct. 10, 2000 MWC FGM has Bz as spin axis, so it is stored in Bx;
;                   still need to finish this 
; Oct. 24, 2000 MWC well, FGM Bx seems to be more like EDI Bx; still
;                   need to explore this
; Dec.  8, 2000 MWC oops, status should not be set to the number of
;                   FGM data points which could very easily overflow
;                   an int; also added flag_gap keyword.
; Jan. 22, 2001 MWC now save the last piece of FGM data to use as a
;                   starting point for next call
; Nov. 29, 2001 SSK changed size check of mag_t
;
; Calling Interface:
; start_time  double   (i) a double precision start time
; time_length double   (i) how many seconds of data requested
;
; Return Value:
; a structure containing arrays for time, bx, by, bz, and bmag
;
; Description:
; Read a magnetometer data file and extract data whose times
; lie between start_time and start_time + time_length

COMMON mag_lun, pick_mag_lun
COMMON last_FGM, mag_t, x, y, z
@pick_const

cnt = 0L
time_offset = 0.D
samples = long(time_length+1) * 70
mag_time = dblarr(samples)
bx = fltarr(samples)
by = fltarr(samples)
bz = fltarr(samples)
bmag = fltarr(samples)
mag_string = ''
size_check = size(mag_t)
IF size_check[1] NE 5 THEN $
  mag_t = 0.D
on_ioerror, eof

size_check = size(x)
IF size_check[1] EQ 0 THEN $
  readf, pick_mag_lun, mag_t, x, y, z
;print, mag_t, format = '(d32)'

IF mag_t GT start_time+time_length THEN BEGIN
    fgm_err = {$
                count: 0L, $
                status: -1 $
              }
    fgm_err.status = FGM_ERROR
    return, fgm_err
ENDIF

WHILE mag_t LE start_time DO BEGIN
    readf, pick_mag_lun, mag_t, x, y, z
ENDWHILE

;stop
IF keyword_set(flag_gap) AND $
  mag_t GT (start_time + 1.D) THEN BEGIN ;FGM data gap
    fgm_err = {$
                count: 0L, $
                status: -1 $
              }
    fgm_err.status = FGM_ERROR
    return, fgm_err
ENDIF

mag_time[cnt] = mag_t
bx[cnt] = x
by[cnt] = y
bz[cnt] = z
cnt = 1L

WHILE time_offset LT time_length DO BEGIN
    readf, pick_mag_lun, mag_t, x, y, z
    mag_time[cnt] = mag_t
    time_offset = mag_time[cnt] - mag_time[0]
    bx[cnt] = x
    by[cnt] = y
    bz[cnt] = z
    cnt = cnt + 1L
ENDWHILE
cnt = cnt - 1
;now store the exact range of values into a structure
fgm = {count:0L, $
       mag_time:dblarr(cnt), $
       bx:fltarr(cnt), $
       by:fltarr(cnt), $
       bz:fltarr(cnt), $
       bmag:fltarr(cnt), $
       status:0}
fgm.count = cnt
fgm.mag_time = mag_time[0:cnt-1]
fgm.bx = bx[0:cnt-1]
fgm.by = by[0:cnt-1]
fgm.bz = bz[0:cnt-1]
fgm.bmag = sqrt(fgm.bx*fgm.bx + fgm.by*fgm.by + fgm.bz*fgm.bz)
fgm.status = 1
return, fgm

eof: fgm_err = {$
                 count: 0L, $
                 status: -1 $
               }
fgm_err.status = FGM_ERROR
return, fgm_err

END
